/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSProgressIndicator;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTProgressIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    NSBezierPath visiblePath;

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int size = 14;
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            height = size;
            width = height * 10;
        } else {
            width = size;
            height = width * 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        NSProgressIndicator widget = (NSProgressIndicator)new SWTProgressIndicator().alloc();
        widget.init();
        widget.setUsesThreadedAnimation(false);
        if ((this.style & 0x200) != 0) {
            widget.setBoundsRotation(-90.0);
        }
        widget.setIndeterminate((this.style & 2) != 0);
        this.view = widget;
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.progressIndicatorFont;
    }

    @Override
    void _drawThemeProgressArea(long id2, long sel, long arg0) {
        NSRect frame = this.view.frame();
        if (frame.width == 0.0 || frame.height == 0.0) {
            return;
        }
        if (this.visiblePath == null) {
            long visibleRegion = this.getVisibleRegion();
            this.visiblePath = this.getPath(visibleRegion);
            OS.DisposeRgn(visibleRegion);
        }
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        context.saveGraphicsState();
        this.visiblePath.setClip();
        super._drawThemeProgressArea(id2, sel, arg0);
        context.restoreGraphicsState();
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).minValue();
    }

    public int getSelection() {
        this.checkWidget();
        return (int)((NSProgressIndicator)this.view).doubleValue();
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = (int)((NSProgressIndicator)this.view).minValue();
        if (value <= minimum) {
            return;
        }
        ((NSProgressIndicator)this.view).setMaxValue(value);
        int selection = (int)((NSProgressIndicator)this.view).doubleValue();
        int newSelection = Math.min(selection, value);
        if (selection != newSelection) {
            ((NSProgressIndicator)this.view).setDoubleValue(newSelection);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = (int)((NSProgressIndicator)this.view).maxValue();
        if (0 > value || value >= maximum) {
            return;
        }
        ((NSProgressIndicator)this.view).setMinValue(value);
        int selection = (int)((NSProgressIndicator)this.view).doubleValue();
        int newSelection = Math.max(selection, value);
        if (selection != newSelection) {
            ((NSProgressIndicator)this.view).setDoubleValue(newSelection);
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        ((NSProgressIndicator)this.view).setDoubleValue(value);
        this.update(false);
    }

    public void setState(int state) {
        this.checkWidget();
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    @Override
    void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    @Override
    void viewDidMoveToWindow(long id2, long sel) {
        if (this.view.window() != null && (this.style & 2) != 0) {
            ((NSProgressIndicator)this.view).startAnimation(null);
        }
    }
}

