# Contributing to Rust Decimal

Rust Decimal welcomes contributions from everyone. Here are the guidelines if you are
thinking of helping us:

## Contributions

Contributions to Rust Decimal or its dependencies should be made in the form of GitHub
pull requests. Each pull request will be reviewed by a core contributor
(someone with permission to land patches) and either landed in the main tree or
given feedback for changes that would be required. All contributions should
follow this format, even those from core contributors.

Should you wish to work on an issue, please claim it first by commenting on
the GitHub issue that you want to work on it. This is to prevent duplicated
efforts from contributors on the same issue.

## Pull Request Checklist

- Branch from the master branch and, if needed, rebase to the current master
  branch before submitting your pull request. If it doesn't merge cleanly with
  master you may be asked to rebase your changes.

- If your patch is not getting reviewed or you need a specific person to review
  it, you can @-reply a reviewer asking for a review in the pull request or inside a
  comment.

- Add tests relevant to the fixed bug or new feature. If your addition is feature gated,
  please make sure the tests are run by the makefile and if necessary, GitHub actions.

- If necessary, add documentation for the new feature to the readme and/or to the public 
  functions. 

## Conduct

In all Rust Decimal related forums, we follow the [Rust Code of
Conduct](https://www.rust-lang.org/conduct.html).  For escalation or moderation of
issues, please contact Paul (paul@form1.co.nz) instead of the Rust
moderation team.

## Communication

Opening tickets on the
[paupino/rust-decimal](https://github.com/paupino/rust-decimal) project is the preferred method of communication. 