<!--

Guidelines for pull requests:

* Use a separate branch (instead of "master"). This will save you a lot of headaches: https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests
* Only one feature/fix per pull request (unless they're connected).
* Try to follow our coding conventions: https://www.ufopaedia.org/index.php/Coding_Style_(OpenXcom)
* Explain in detail what your pull request is changing and why we want it.

We're very conservative about adding new features to OpenXcom. The bigger the change, the more it's gonna cost us in complexity and maintenance. Gameplay-critical code is very sensitive to changes and prone to bugs. Once it's merged it's our responsibility. So it's not enough that "it works", it needs to justify its cost. Is it a highly-demanded must-have feature? Has it been throughly tested? Will we regret merging it? Etc.

GitHub isn't a good discussion board, only developers look at this, so it's better to post in the forums first to gauge interest before doing any major changes: https://openxcom.org/forum/

-->