SYD-FD(1)

# NAME

*syd-fd* - Interact with remote file descriptors

# SYNOPSIS

*syd-fd* _[-h]_ _[-p pid]_ _[-f remote_fd[:local_fd]]_... _{command [args...]}_

# DESCRIPTION

The *syd-fd* utility can be used to interact with remote file
descriptors on Linux systems. Given only a PID argument with *-p*, it
lists the open files of the process with the given PID in line-oriented
compact JSON format. Given no PID argument it lists the open files of
the current process. The *-f* argument can be used to transfer remote
file descriptors using _pidfd_getfd_(2) which requires Linux>=5.6.
Optionally a colon-delimited local file descriptor may be specified as
target fd. Specify *rand* as target to duplicate the file descriptor to
a random available file descriptor slot. If a command is given it is
executed and the file descriptors are transferred to the process. If no
command is given "/bin/sh" is executed.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-p* _pid_
:< Specify process ID. If not given, list fds of current process.
|[ *-f* _remote_fd[:local_fd]_
:< Specify remote fd to transfer. Optionally specify colon-separated local fd as target, or *rand* for random target.

# EXIT CODES

*syd-fd* exits with the same exit code as the command.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-lock_(1), _syd-pds_(1), _pidfd_getfd_(1)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
