/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import jdk.internal.misc.Unsafe;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicLongFieldUpdater<T> {
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        return null;
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract void lazySet(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T t, long l) {
        return 0L;
    }

    public long getAndIncrement(T t) {
        return 0L;
    }

    public long getAndDecrement(T t) {
        return 0L;
    }

    public long getAndAdd(T t, long l) {
        return 0L;
    }

    public long incrementAndGet(T t) {
        return 0L;
    }

    public long decrementAndGet(T t) {
        return 0L;
    }

    public long addAndGet(T t, long l) {
        return 0L;
    }

    public final long getAndUpdate(T t, LongUnaryOperator longUnaryOperator) {
        return 0L;
    }

    public final long updateAndGet(T t, LongUnaryOperator longUnaryOperator) {
        return 0L;
    }

    public final long getAndAccumulate(T t, long l, LongBinaryOperator longBinaryOperator) {
        return 0L;
    }

    public final long accumulateAndGet(T t, long l, LongBinaryOperator longBinaryOperator) {
        return 0L;
    }

    private static final class LockedUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<?> cclass;
        private final Class<T> tclass;

        LockedUpdater(final Class<T> tclass, final String fieldName, Class<?> caller) {
            int modifiers;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return tclass.getDeclaredField(fieldName);
                    }
                });
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ClassLoader cl = tclass.getClassLoader();
                ClassLoader ccl = caller.getClassLoader();
                if (!(ccl == null || ccl == cl || cl != null && LockedUpdater.isAncestor((ClassLoader)cl, (ClassLoader)ccl))) {
                    ReflectUtil.checkPackageAccess(tclass);
                }
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && tclass.isAssignableFrom(caller) && !LockedUpdater.isSamePackage(tclass, caller) ? caller : tclass;
            this.tclass = tclass;
            this.offset = U.objectFieldOffset(field);
        }

        private final void accessCheck(T obj) {
            if (!this.cclass.isInstance(obj)) {
                throw this.accessCheckException(obj);
            }
        }

        private final RuntimeException accessCheckException(T obj) {
            if (this.cclass == this.tclass) {
                return new ClassCastException();
            }
            return new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean compareAndSet(T obj, long expect, long update) {
            this.accessCheck(obj);
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                long v = U.getLong(obj, this.offset);
                if (v != expect) {
                    return false;
                }
                U.putLong(obj, this.offset, update);
                return true;
            }
        }

        @Override
        public final boolean weakCompareAndSet(T obj, long expect, long update) {
            return this.compareAndSet(obj, expect, update);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void set(T obj, long newValue) {
            this.accessCheck(obj);
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                U.putLong(obj, this.offset, newValue);
            }
        }

        @Override
        public final void lazySet(T obj, long newValue) {
            this.set(obj, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long get(T obj) {
            this.accessCheck(obj);
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                return U.getLong(obj, this.offset);
            }
        }
    }

    private static final class CASUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<?> cclass;
        private final Class<T> tclass;

        CASUpdater(final Class<T> tclass, final String fieldName, Class<?> caller) {
            int modifiers;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return tclass.getDeclaredField(fieldName);
                    }
                });
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ClassLoader cl = tclass.getClassLoader();
                ClassLoader ccl = caller.getClassLoader();
                if (!(ccl == null || ccl == cl || cl != null && CASUpdater.isAncestor((ClassLoader)cl, (ClassLoader)ccl))) {
                    ReflectUtil.checkPackageAccess(tclass);
                }
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && tclass.isAssignableFrom(caller) && !CASUpdater.isSamePackage(tclass, caller) ? caller : tclass;
            this.tclass = tclass;
            this.offset = U.objectFieldOffset(field);
        }

        private final void accessCheck(T obj) {
            if (!this.cclass.isInstance(obj)) {
                this.throwAccessCheckException(obj);
            }
        }

        private final void throwAccessCheckException(T obj) {
            if (this.cclass == this.tclass) {
                throw new ClassCastException();
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }

        @Override
        public final boolean compareAndSet(T obj, long expect, long update) {
            this.accessCheck(obj);
            return U.compareAndSetLong(obj, this.offset, expect, update);
        }

        @Override
        public final boolean weakCompareAndSet(T obj, long expect, long update) {
            this.accessCheck(obj);
            return U.compareAndSetLong(obj, this.offset, expect, update);
        }

        @Override
        public final void set(T obj, long newValue) {
            this.accessCheck(obj);
            U.putLongVolatile(obj, this.offset, newValue);
        }

        @Override
        public final void lazySet(T obj, long newValue) {
            this.accessCheck(obj);
            U.putLongRelease(obj, this.offset, newValue);
        }

        @Override
        public final long get(T obj) {
            this.accessCheck(obj);
            return U.getLongVolatile(obj, this.offset);
        }

        @Override
        public final long getAndSet(T obj, long newValue) {
            this.accessCheck(obj);
            return U.getAndSetLong(obj, this.offset, newValue);
        }

        @Override
        public final long getAndAdd(T obj, long delta) {
            this.accessCheck(obj);
            return U.getAndAddLong(obj, this.offset, delta);
        }

        @Override
        public final long getAndIncrement(T obj) {
            return this.getAndAdd(obj, 1L);
        }

        @Override
        public final long getAndDecrement(T obj) {
            return this.getAndAdd(obj, -1L);
        }

        @Override
        public final long incrementAndGet(T obj) {
            return this.getAndAdd(obj, 1L) + 1L;
        }

        @Override
        public final long decrementAndGet(T obj) {
            return this.getAndAdd(obj, -1L) - 1L;
        }

        @Override
        public final long addAndGet(T obj, long delta) {
            return this.getAndAdd(obj, delta) + delta;
        }
    }
}

