/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public final class Verifier {
    private static final byte[] VALCONST = new byte[]{0, 1, 0, 1, 0, 1, 65, 1, 65, 73, 65, 89, 65, 1, 65, 1, 65, 79, 1, 77, 1, 79, 1, 65, 1, 9, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 9, 1, 41, 1, 41, 1, 15, 9, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 15, 1, 9, 15, 41, 1, 25, 1, 41, 15, 1, 15, 1, 15, 1, 15, 1, 15, 41, 15, 41, 1, 41, 1, 25, 1, 41, 1, 15, 1, 41, 15, 41, 1, 41, 1, 15, 41, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 41, 1, 25, 15, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 25, 41, 15, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 15, 41, 1, 41, 1, 41, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 15, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 25, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 25, 1, 15, 1, 15, 41, 15, 41, 1, 15, 9, 41, 1, 25, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 41, 15, 41, 1, 41, 15, 1, 15, 1, 9, 1, 41, 1, 25, 1, 41, 1, 25, 1, 41, 1, 41, 1, 41, 1, 41, 15, 1, 15, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 41, 1, 41, 1, 15, 1, 15, 1, 15, 1, 15, 1, 9, 1, 15, 1, 15, 41, 1, 9, 1, 15, 1, 41, 1, 9, 1, 15, 1, 9, 1, 15, 1, 15, 1, 15, 1, 0, 1, 0};
    private static final int[] LENCONST = new int[]{9, 2, 2, 1, 18, 1, 1, 2, 9, 2, 1, 10, 1, 2, 1, 1, 2, 26, 4, 1, 1, 26, 3, 1, 56, 1, 8, 23, 1, 31, 1, 58, 2, 11, 2, 8, 1, 53, 1, 68, 9, 36, 3, 2, 4, 30, 56, 89, 18, 7, 14, 2, 46, 70, 26, 2, 36, 1, 1, 3, 1, 1, 1, 20, 1, 44, 1, 7, 3, 1, 1, 1, 1, 1, 1, 1, 1, 18, 13, 12, 1, 66, 1, 12, 1, 36, 1, 4, 9, 53, 2, 2, 2, 2, 3, 28, 2, 8, 2, 2, 55, 38, 2, 1, 7, 38, 10, 17, 1, 23, 1, 3, 1, 1, 1, 2, 1, 1, 11, 27, 5, 3, 46, 26, 5, 1, 10, 8, 13, 10, 6, 1, 71, 2, 5, 1, 15, 1, 4, 1, 1, 15, 2, 2, 1, 4, 2, 10, 519, 3, 1, 53, 2, 1, 1, 16, 3, 4, 3, 10, 2, 2, 10, 17, 3, 1, 8, 2, 2, 2, 22, 1, 7, 1, 1, 3, 4, 2, 1, 1, 7, 2, 2, 2, 3, 9, 1, 4, 2, 1, 3, 2, 2, 10, 2, 16, 1, 2, 6, 4, 2, 2, 22, 1, 7, 1, 2, 1, 2, 1, 2, 2, 1, 1, 5, 4, 2, 2, 3, 11, 4, 1, 1, 7, 10, 2, 3, 12, 3, 1, 7, 1, 1, 1, 3, 1, 22, 1, 7, 1, 2, 1, 5, 2, 1, 1, 8, 1, 3, 1, 3, 18, 1, 5, 10, 17, 3, 1, 8, 2, 2, 2, 22, 1, 7, 1, 2, 2, 4, 2, 1, 1, 6, 3, 2, 2, 3, 8, 2, 4, 2, 1, 3, 4, 10, 18, 2, 1, 6, 3, 3, 1, 4, 3, 2, 1, 1, 1, 2, 3, 2, 3, 3, 3, 8, 1, 3, 4, 5, 3, 3, 1, 4, 9, 1, 15, 9, 17, 3, 1, 8, 1, 3, 1, 23, 1, 10, 1, 5, 4, 7, 1, 3, 1, 4, 7, 2, 9, 2, 4, 10, 18, 2, 1, 8, 1, 3, 1, 23, 1, 10, 1, 5, 4, 7, 1, 3, 1, 4, 7, 2, 7, 1, 1, 2, 4, 10, 18, 2, 1, 8, 1, 3, 1, 23, 1, 16, 4, 6, 2, 3, 1, 4, 9, 1, 8, 2, 4, 10, 145, 46, 1, 1, 1, 2, 7, 5, 6, 1, 8, 1, 10, 39, 2, 1, 1, 2, 2, 1, 1, 2, 1, 6, 4, 1, 7, 1, 3, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 2, 6, 1, 2, 1, 2, 5, 1, 1, 1, 6, 2, 10, 62, 2, 6, 10, 11, 1, 1, 1, 1, 1, 4, 2, 8, 1, 33, 7, 20, 1, 6, 4, 6, 1, 1, 1, 21, 3, 7, 1, 1, 230, 38, 10, 39, 9, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 5, 41, 1, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 3, 2, 3, 1, 5, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 3, 2, 1, 1, 40, 1, 9, 1, 2, 1, 2, 2, 7, 2, 1, 1, 1, 7, 40, 1, 4, 1, 8, 1, 3078, 156, 4, 90, 6, 22, 2, 6, 2, 38, 2, 6, 2, 8, 1, 1, 1, 1, 1, 1, 1, 31, 2, 53, 1, 7, 1, 1, 3, 3, 1, 7, 3, 4, 2, 6, 4, 13, 5, 3, 1, 7, 211, 13, 4, 1, 68, 1, 3, 2, 2, 1, 81, 3, 3714, 1, 1, 1, 25, 9, 6, 1, 5, 11, 84, 4, 2, 2, 2, 2, 90, 1, 3, 6, 40, 7379, 20902, 3162, 11172, 92, 2048, 8190, 2};
    private static final byte[] CHARFLAGS = Verifier.buildBitFlags();

    private static byte[] buildBitFlags() {
        byte[] ret = new byte[65536];
        int index = 0;
        for (int i2 = 0; i2 < VALCONST.length; ++i2) {
            byte v2 = VALCONST[i2];
            int l2 = LENCONST[i2];
            while (--l2 >= 0) {
                ret[index++] = v2;
            }
        }
        return ret;
    }

    private static String checkJDOMName(String name2) {
        if (name2 == null) {
            return "XML names cannot be null";
        }
        if (name2.isEmpty()) {
            return "XML names cannot be empty";
        }
        if (0 == (CHARFLAGS[name2.charAt(0)] & 4)) {
            return "XML name '" + name2 + "' cannot begin with the character \"" + name2.charAt(0) + "\"";
        }
        for (int i2 = name2.length() - 1; i2 >= 1; --i2) {
            if (0 != (byte)(CHARFLAGS[name2.charAt(i2)] & 8)) continue;
            return "XML name '" + name2 + "' cannot contain the character \"" + name2.charAt(i2) + "\"";
        }
        return null;
    }

    public static String checkNamespacePrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        if (Verifier.checkJDOMName(prefix) != null) {
            return Verifier.checkJDOMName(prefix);
        }
        return null;
    }

    static String checkNamespaceURI(String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        char first = uri.charAt(0);
        if (Character.isDigit(first)) {
            return "Namespace URIs cannot begin with a number";
        }
        if (first == '$') {
            return "Namespace URIs cannot begin with a dollar sign ($)";
        }
        if (first == '-') {
            return "Namespace URIs cannot begin with a hyphen (-)";
        }
        if (Verifier.isXMLWhitespace(first)) {
            return "Namespace URIs cannot begin with white-space";
        }
        return null;
    }

    private static String checkNamespaceCollision(Namespace namespace, Namespace other) {
        String reason = null;
        String p1 = namespace.getPrefix();
        String u1 = namespace.getURI();
        String p2 = other.getPrefix();
        String u2 = other.getURI();
        if (p1.equals(p2) && !u1.equals(u2)) {
            reason = "The namespace prefix \"" + p1 + "\" collides";
        }
        return reason;
    }

    static String checkNamespaceCollision(Attribute attribute, Element element) {
        return Verifier.checkNamespaceCollision(attribute, element, -1);
    }

    static String checkNamespaceCollision(Attribute attribute, Element element, int ignoreAtt) {
        Namespace namespace = attribute.getNamespace();
        String prefix = namespace.getPrefix();
        if ("".equals(prefix)) {
            return null;
        }
        return Verifier.checkNamespaceCollision(namespace, element, ignoreAtt);
    }

    static String checkNamespaceCollision(Namespace namespace, Element element) {
        return Verifier.checkNamespaceCollision(namespace, element, -1);
    }

    private static String checkNamespaceCollision(Namespace namespace, Element element, int ignoreAtt) {
        String reason = Verifier.checkNamespaceCollision(namespace, element.getNamespace());
        if (reason != null) {
            return reason + " with the element namespace prefix";
        }
        if (element.hasAdditionalNamespaces() && (reason = Verifier.checkNamespaceCollision(namespace, element.getAdditionalNamespaces())) != null) {
            return reason;
        }
        if (element.hasAttributes() && (reason = Verifier.checkNamespaceCollision(namespace, element.getAttributes(), ignoreAtt)) != null) {
            return reason;
        }
        return null;
    }

    static String checkNamespaceCollision(Namespace namespace, Attribute attribute) {
        String reason = null;
        if (!attribute.getNamespace().equals(Namespace.NO_NAMESPACE) && (reason = Verifier.checkNamespaceCollision(namespace, attribute.getNamespace())) != null) {
            reason = reason + " with an attribute namespace prefix on the element";
        }
        return reason;
    }

    static String checkNamespaceCollision(Namespace namespace, List<?> list) {
        return Verifier.checkNamespaceCollision(namespace, list, -1);
    }

    private static String checkNamespaceCollision(Namespace namespace, List<?> list, int ignoreAtt) {
        if (list == null) {
            return null;
        }
        String reason = null;
        Iterator<?> i2 = list.iterator();
        int cnt = -1;
        while (reason == null && i2.hasNext()) {
            Object obj = i2.next();
            ++cnt;
            if (obj instanceof Attribute) {
                if (cnt == ignoreAtt) continue;
                reason = Verifier.checkNamespaceCollision(namespace, (Attribute)obj);
                continue;
            }
            if (obj instanceof Element) {
                reason = Verifier.checkNamespaceCollision(namespace, (Element)obj);
                continue;
            }
            if (!(obj instanceof Namespace) || (reason = Verifier.checkNamespaceCollision(namespace, (Namespace)obj)) == null) continue;
            reason = reason + " with an additional namespace declared by the element";
        }
        return reason;
    }

    public static int decodeSurrogatePair(char high, char low) {
        return 65536 + (high - 55296) * 1024 + (low - 56320);
    }

    public static boolean isHighSurrogate(char ch) {
        return 54 == ch >>> 10;
    }

    public static boolean isLowSurrogate(char ch) {
        return 55 == ch >>> 10;
    }

    public static boolean isXMLWhitespace(char c2) {
        return c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r';
    }

    public static boolean isAllXMLWhitespace(String value2) {
        int i2 = value2.length();
        while (--i2 >= 0) {
            if (Verifier.isXMLWhitespace(value2.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

