/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.BitMappedTrie;
import io.vavr.collection.Collections;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Iterator;
import io.vavr.collection.JavaConverters;
import io.vavr.collection.List;
import io.vavr.collection.Traversable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class Vector<T>
implements IndexedSeq<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Vector<?> EMPTY = new Vector(BitMappedTrie.empty());
    final BitMappedTrie<T> trie;

    private Vector(BitMappedTrie<T> trie) {
        this.trie = trie;
    }

    private Vector<T> wrap(BitMappedTrie<T> trie) {
        return trie == this.trie ? this : Vector.ofAll(trie);
    }

    private static <T> Vector<T> ofAll(BitMappedTrie<T> trie) {
        return trie.length() == 0 ? Vector.empty() : new Vector<T>(trie);
    }

    public static <T> Vector<T> empty() {
        return EMPTY;
    }

    public static <T> Collector<T, ArrayList<T>, Vector<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Vector> finisher = Vector::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Vector<T> ofAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (iterable instanceof Traversable && Collections.isEmpty(iterable)) {
            return Vector.empty();
        }
        if (iterable instanceof Vector) {
            return (Vector)iterable;
        }
        if (iterable instanceof JavaConverters.ListView && ((JavaConverters.ListView)iterable).getDelegate() instanceof Vector) {
            return (Vector)((JavaConverters.ListView)iterable).getDelegate();
        }
        Object[] values2 = Collections.withSize(iterable).toArray();
        return Vector.ofAll(BitMappedTrie.ofAll(values2));
    }

    @Override
    public Vector<T> append(T element) {
        return this.appendAll(List.of(element));
    }

    @Override
    public Vector<T> appendAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (this.isEmpty()) {
            return Vector.ofAll(iterable);
        }
        if (Collections.isEmpty(iterable)) {
            return this;
        }
        return new Vector<T>(this.trie.appendAll(iterable));
    }

    public Vector<T> drop(int n2) {
        return this.wrap(this.trie.drop(n2));
    }

    @Override
    public Vector<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.wrap(this.trie.filter(predicate));
    }

    @Override
    public T get(int index) {
        if (this.isValid(index)) {
            return this.trie.get(index);
        }
        throw new IndexOutOfBoundsException("get(" + index + ")");
    }

    private boolean isValid(int index) {
        return index >= 0 && index < this.length();
    }

    @Override
    public T head() {
        if (this.nonEmpty()) {
            return this.get(0);
        }
        throw new NoSuchElementException("head of empty Vector");
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public int indexOf(T element, int from2) {
        for (int i2 = from2; i2 < this.length(); ++i2) {
            if (!Objects.equals(this.get(i2), element)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public Vector<T> insert(int index, T element) {
        return this.insertAll(index, Iterator.of(element));
    }

    @Override
    public Vector<T> insertAll(int index, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index >= 0 && index <= this.length()) {
            IndexedSeq begin = ((Vector)this.take(index)).appendAll((Iterable)elements);
            Vector<T> end = this.drop(index);
            return begin.size() > end.size() ? ((Vector)begin).appendAll(end) : end.prependAll(begin);
        }
        throw new IndexOutOfBoundsException("insert(" + index + ", e) on Vector of length " + this.length());
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : this.trie.iterator();
    }

    @Override
    public int lastIndexOf(T element, int end) {
        for (int i2 = Math.min(end, this.length() - 1); i2 >= 0; --i2) {
            if (!Objects.equals(this.get(i2), element)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.trie.length();
    }

    @Override
    public <U> Vector<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return Vector.ofAll(this.trie.map(mapper));
    }

    public Vector<T> prependAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (this.isEmpty()) {
            return Vector.ofAll(iterable);
        }
        if (Collections.isEmpty(iterable)) {
            return this;
        }
        return new Vector<T>(this.trie.prependAll(iterable));
    }

    @Override
    public Vector<T> remove(T element) {
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (!Objects.equals(this.get(i2), element)) continue;
            return this.removeAt(i2);
        }
        return this;
    }

    @Override
    public Vector<T> removeAt(int index) {
        if (this.isValid(index)) {
            IndexedSeq begin = this.take(index);
            Vector<T> end = this.drop(index + 1);
            return begin.size() > end.size() ? ((Vector)begin).appendAll(end) : end.prependAll(begin);
        }
        throw new IndexOutOfBoundsException("removeAt(" + index + ")");
    }

    @Override
    public Vector<T> removeAll(Iterable<? extends T> elements) {
        return Collections.removeAll(this, elements);
    }

    @Override
    public Vector<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public Vector<T> reverse() {
        return this.length() <= 1 ? this : Vector.ofAll(this.reverseIterator());
    }

    public Vector<T> slice(int beginIndex, int endIndex) {
        if (beginIndex >= endIndex || beginIndex >= this.size() || this.isEmpty()) {
            return Vector.empty();
        }
        if (beginIndex <= 0 && endIndex >= this.length()) {
            return this;
        }
        return ((Vector)this.take(endIndex)).drop(beginIndex);
    }

    @Override
    public Vector<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(Vector.collector());
    }

    @Override
    public Vector<T> subSequence(int beginIndex, int endIndex) {
        Collections.subSequenceRangeCheck(beginIndex, endIndex, this.length());
        return this.slice(beginIndex, endIndex);
    }

    @Override
    public Vector<T> tail() {
        if (this.nonEmpty()) {
            return this.drop(1);
        }
        throw new UnsupportedOperationException("tail of empty Vector");
    }

    @Override
    public Vector<T> take(int n2) {
        return this.wrap(this.trie.take(n2));
    }

    @Override
    public Vector<T> update(int index, T element) {
        if (this.isValid(index)) {
            return this.wrap(this.trie.update(index, element));
        }
        throw new IndexOutOfBoundsException("update(" + index + ")");
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    public boolean equals(Object o2) {
        return Collections.equals(this, o2);
    }

    public int hashCode() {
        return Collections.hashOrdered(this);
    }

    @Override
    public String stringPrefix() {
        return "Vector";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

