/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is used to temporarily disable newly added stylelint rules for existing files.
 * This allows us to enable new stylelint rules immediately for newly added files,
 * without having to fix errors in existing files.
 *
 * Newly added style files should NOT be added to this list,
 * and existing files should be removed from this list as they are fixed.
 */
module.exports = [
  {
    name: "rollout-use-border-radius-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-border-radius-tokens": null,
    },
    files: [
      "browser/base/content/sanitizeDialog.css",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/contextualidentity/content/usercontext.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/preferences/dialogs/clearSiteData.css",
      "browser/components/profiles/content/profile-card.css",
      "browser/components/profiles/content/profiles-theme-card.css",
      "browser/components/protections/content/protections.css",
      "browser/components/screenshots/overlay/overlay.css",
      "browser/components/screenshots/screenshots-buttons.css",
      "browser/components/search/test/browser/telemetry/serp.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/components/urlbar/tests/browser/dynamicResult0.css",
      "browser/components/urlbar/tests/browser/dynamicResult1.css",
      "browser/extensions/formautofill/content/manageDialog.css",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicSelection/_TopicSelection.scss",
      "browser/themes/linux/browser.css",
      "browser/themes/shared/addons/unified-extensions.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/identity-block/identity-block.css",
      "browser/themes/shared/notification-icons.css",
      "browser/themes/shared/search/searchbar.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/tabbrowser/content-area.css",
      "browser/themes/shared/tabbrowser/ctrlTab.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/toolbarbuttons.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/windows/downloads/allDownloadsView.css",
      "layout/style/res/forms.css",
      "security/manager/pki/resources/content/clientauthask.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/components/printing/content/printPagination.css",
      "toolkit/components/satchel/megalist/content/components/login-line/login-line.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/widgets/moz-visual-picker/moz-visual-picker-item.css",
      "toolkit/content/xul.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/mozapps/extensions/content/shortcuts.css",
      "toolkit/themes/mobile/global/aboutMemory.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/design-system/tokens-table.css",
      "toolkit/themes/shared/menu.css",
      "toolkit/themes/shared/popup.css",
      "toolkit/components/certviewer/content/components/certificate-section.css",
      "toolkit/content/widgets/infobar.css",
      "toolkit/content/widgets/moz-box-common.css",
      "toolkit/themes/shared/in-content/common-shared.css",
    ],
  },
  {
    name: "rollout-use-border-color-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-border-color-tokens": null,
    },
    files: [
      "browser/base/content/sanitizeDialog.css",
      "browser/branding/aurora/stubinstaller/installing_page.css",
      "browser/branding/nightly/stubinstaller/installing_page.css",
      "browser/branding/official/stubinstaller/installing_page.css",
      "browser/branding/official/stubinstaller/profile_cleanup_page.css",
      "browser/branding/unofficial/stubinstaller/installing_page.css",
      "browser/components/aboutlogins/content/aboutLoginsImportReport.css",
      "browser/components/aboutlogins/content/components/confirmation-dialog.css",
      "browser/components/aboutlogins/content/components/generic-dialog.css",
      "browser/components/aboutlogins/content/components/login-alert.css",
      "browser/components/aboutlogins/content/components/login-list-lit-item.css",
      "browser/components/aboutlogins/content/components/login-list.css",
      "browser/components/aboutlogins/content/components/login-message-popup.css",
      "browser/components/aboutlogins/content/components/menu-button.css",
      "browser/components/aboutlogins/content/components/remove-logins-dialog.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/backup/content/archive.css",
      "browser/components/backup/content/restore-from-backup.css",
      "browser/components/backup/content/turn-on-scheduled-backups.css",
      "browser/components/enterprisepolicies/content/aboutPolicies.css",
      "browser/components/firefoxview/card-container.css",
      "browser/components/firefoxview/fxview-tab-row.css",
      "browser/components/firefoxview/opentabs-tab-row.css",
      "browser/components/firefoxview/view-syncedtabs.css",
      "browser/components/genai/chat.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/genai/content/model-optin.css",
      "browser/components/ipprotection/content/ipprotection-content.css",
      "browser/components/places/content/places.css",
      "browser/components/preferences/dialogs/clearSiteData.css",
      "browser/components/profiles/content/avatar.css",
      "browser/components/profiles/content/profile-avatar-selector.css",
      "browser/components/profiles/content/profile-card.css",
      "browser/components/profiles/content/profiles-pages.css",
      "browser/components/profiles/content/profiles-theme-card.css",
      "browser/components/protections/content/protections.css",
      "browser/components/screenshots/overlay/overlay.css",
      "browser/components/search/content/contentSearchUI.css",
      "browser/components/search/test/browser/telemetry/serp.css",
      "browser/components/security/unexpectedScriptLoad.css",
      "browser/components/sidebar/sidebar-customize.css",
      "browser/components/sidebar/sidebar-history.css",
      "browser/components/sidebar/sidebar-main.css",
      "browser/components/sidebar/sidebar-pins-promo.css",
      "browser/components/sidebar/sidebar.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/components/urlbar/tests/browser/dynamicResult0.css",
      "browser/components/urlbar/tests/browser/dynamicResult1.css",
      "browser/extensions/formautofill/content/manageDialog.css",
      "browser/extensions/newtab/content-src/components/A11yLinkButton/_A11yLinkButton.scss",
      "browser/extensions/newtab/content-src/components/Base/_Base.scss",
      "browser/extensions/newtab/content-src/components/Card/_Card.scss",
      "browser/extensions/newtab/content-src/components/ConfirmDialog/_ConfirmDialog.scss",
      "browser/extensions/newtab/content-src/components/ContextMenu/_ContextMenu.scss",
      "browser/extensions/newtab/content-src/components/CustomizeMenu/_CustomizeMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamAdmin/DiscoveryStreamAdmin.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSCard/_DSCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSEmptyState/_DSEmptyState.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSLinkMenu/_DSLinkMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSTextPromo/_DSTextPromo.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSThumbsUpDownButtons/_DSThumbsUpDownButtons.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/FeatureHighlight/_FeatureHighlight.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/HorizontalRule/_HorizontalRule.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/InterestPicker/_InterestPicker.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/ListFeed/_ListFeed.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/Navigation/_Navigation.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/ReportContent/ReportContent.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicSelection/_TopicSelection.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TopicsWidget/_TopicsWidget.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/TrendingSearches/_TrendingSearches.scss",
      "browser/extensions/newtab/content-src/components/DownloadModalToggle/_DownloadModalToggle.scss",
      "browser/extensions/newtab/content-src/components/ModalOverlay/_ModalOverlay.scss",
      "browser/extensions/newtab/content-src/components/Search/_Search.scss",
      "browser/extensions/newtab/content-src/components/Sections/_Sections.scss",
      "browser/extensions/newtab/content-src/components/TopSites/_TopSites.scss",
      "browser/extensions/newtab/content-src/components/WallpaperCategories/_WallpaperCategories.scss",
      "browser/extensions/newtab/content-src/components/Weather/_Weather.scss",
      "browser/extensions/newtab/content-src/components/Widgets/Lists/_Lists.scss",
      "browser/extensions/newtab/content-src/styles/_icons.scss",
      "browser/extensions/newtab/content-src/styles/_mixins.scss",
      "browser/extensions/newtab/content-src/styles/_variables.scss",
      "browser/extensions/newtab/content-src/styles/activity-stream.scss",
      "browser/extensions/webcompat/about-compat/aboutCompat.css",
      "browser/fxr/content/fxrui_blue.css",
      "browser/fxr/content/fxrui.css",
      "browser/fxr/content/prefs.css",
      "browser/installer/windows/nsis/content/stub_common.css",
      "browser/themes/linux/browser.css",
      "browser/themes/osx/browser.css",
      "browser/themes/osx/places/organizer.css",
      "browser/themes/shared/aboutSessionRestore.css",
      "browser/themes/shared/aboutTabCrashed.css",
      "browser/themes/shared/addons/unified-extensions.css",
      "browser/themes/shared/autocomplete.css",
      "browser/themes/shared/blockedSite.css",
      "browser/themes/shared/browser-shared.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/downloads/allDownloadsView.inc.css",
      "browser/themes/shared/downloads/contentAreaDownloadsView.css",
      "browser/themes/shared/downloads/downloads.inc.css",
      "browser/themes/shared/downloads/progressmeter.css",
      "browser/themes/shared/formautofill-notification.css",
      "browser/themes/shared/identity-block/identity-block.css",
      "browser/themes/shared/identity-credential-notification.css",
      "browser/themes/shared/migration/migration-wizard.css",
      "browser/themes/shared/pageInfo.css",
      "browser/themes/shared/places/editBookmark.css",
      "browser/themes/shared/places/editBookmarkPanel.css",
      "browser/themes/shared/places/sidebar.css",
      "browser/themes/shared/preferences/containers-dialog.css",
      "browser/themes/shared/preferences/containers.css",
      "browser/themes/shared/preferences/preferences.css",
      "browser/themes/shared/preferences/privacy.css",
      "browser/themes/shared/preferences/translations.css",
      "browser/themes/shared/privatebrowsing/aboutPrivateBrowsing.css",
      "browser/themes/shared/sanitizeDialog_v2.css",
      "browser/themes/shared/search/searchbar.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/syncedtabs/sidebar.css",
      "browser/themes/shared/tabbrowser/content-area.css",
      "browser/themes/shared/tabbrowser/ctrlTab.css",
      "browser/themes/shared/tabbrowser/tab-hover-preview.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/toolbarbuttons.css",
      "browser/themes/shared/UITour.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/shared/webRTC-indicator.css",
      "browser/themes/windows/browser.css",
      "browser/themes/windows/downloads/allDownloadsView.css",
      "browser/themes/windows/downloads/downloads.css",
      "browser/themes/windows/places/organizer.css",
      "browser/tools/mozscreenshots/mozscreenshots/extension/lib/mozscreenshots-style.css",
      "docs/_static/custom_theme.css",
      "dom/canvas/test/webgl-conf/iframe-passthrough.css",
      "dom/crypto/test/test_WebCrypto.css",
      "dom/events/test/pointerevents/wpt/pointerevent_styles.css",
      "dom/xml/resources/XMLPrettyPrint.css",
      "dom/xml/test/old/books/classic.css",
      "dom/xml/test/old/books/common.css",
      "dom/xml/test/old/books/list.css",
      "gfx/layers/layerviewer/tree.css",
      "layout/mathml/mathml.css",
      "layout/style/res/forms.css",
      "layout/style/res/html.css",
      "layout/style/res/ua.css",
      "mobile/android/android-components/components/browser/errorpages/src/main/assets/error_style.css",
      "mobile/android/fenix/app/src/main/assets/shared_error_style.css",
      "mobile/android/focus-android/app/src/main/assets/error_style.css",
      "mobile/android/themes/geckoview/config.css",
      "testing/mochitest/static/harness.css",
      "testing/mochitest/tests/SimpleTest/test.css",
      "testing/mozbase/mozlog/mozlog/formatters/html/style.css",
      "testing/talos/talos/tests/scroll/reader.css",
      "toolkit/components/aboutcheckerboard/content/aboutCheckerboard.css",
      "toolkit/components/aboutconfig/content/aboutconfig.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/aboutinference/content/model-files-view.css",
      "toolkit/components/aboutmemory/content/aboutMemory.css",
      "toolkit/components/aboutprocesses/content/aboutProcesses.css",
      "toolkit/components/certviewer/content/components/certificate-section.css",
      "toolkit/components/certviewer/content/components/info-group.css",
      "toolkit/components/certviewer/content/components/info-item.css",
      "toolkit/components/certviewer/content/components/list-item.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/components/printing/content/printPagination.css",
      "toolkit/components/resistfingerprinting/content/usercharacteristics.css",
      "toolkit/components/satchel/megalist/content/components/login-form/login-form.css",
      "toolkit/components/satchel/megalist/content/components/password-card/password-card.css",
      "toolkit/components/satchel/megalist/content/megalist.css",
      "toolkit/components/translations/content/about-translations.css",
      "toolkit/content/aboutLogging/aboutLogging.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/widgets/datetimebox.css",
      "toolkit/content/widgets/moz-box-common.css",
      "toolkit/content/widgets/moz-button/moz-button.css",
      "toolkit/content/widgets/moz-card/moz-card.css",
      "toolkit/content/widgets/moz-input-color/moz-input-color.css",
      "toolkit/content/widgets/moz-input-text/moz-input-text.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav-button.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav.css",
      "toolkit/content/widgets/moz-promo/moz-promo.css",
      "toolkit/content/widgets/moz-select/moz-select.css",
      "toolkit/content/widgets/moz-toggle/moz-toggle.css",
      "toolkit/content/widgets/moz-visual-picker/moz-visual-picker-item.css",
      "toolkit/content/widgets/panel-list/panel-item.css",
      "toolkit/content/widgets/panel-list/panel-list.css",
      "toolkit/content/xul.css",
      "toolkit/crashreporter/content/crashes.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/mozapps/extensions/content/shortcuts.css",
      "toolkit/themes/linux/global/autocomplete.css",
      "toolkit/themes/linux/global/global.css",
      "toolkit/themes/linux/global/richlistbox.css",
      "toolkit/themes/linux/mozapps/update/updates.css",
      "toolkit/themes/mobile/global/aboutMemory.css",
      "toolkit/themes/mobile/global/aboutNetworking.css",
      "toolkit/themes/mobile/global/aboutSupport.css",
      "toolkit/themes/osx/global/autocomplete.css",
      "toolkit/themes/osx/global/global.css",
      "toolkit/themes/osx/global/richlistbox.css",
      "toolkit/themes/osx/global/wizard.css",
      "toolkit/themes/osx/mozapps/update/updates.css",
      "toolkit/themes/shared/aboutNetError.css",
      "toolkit/themes/shared/aboutNetworking.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/aboutServiceWorkers.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/close-icon.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/design-system/tokens-table.css",
      "toolkit/themes/shared/dirListing/dirListing.css",
      "toolkit/themes/shared/error-pages.css",
      "toolkit/themes/shared/findbar.css",
      "toolkit/themes/shared/global-shared.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/in-content/info-pages.css",
      "toolkit/themes/shared/media/pipToggle.css",
      "toolkit/themes/shared/media/videocontrols.css",
      "toolkit/themes/shared/menu.css",
      "toolkit/themes/shared/menulist.css",
      "toolkit/themes/shared/narrate.css",
      "toolkit/themes/shared/pictureinpicture/player.css",
      "toolkit/themes/shared/popup.css",
      "toolkit/themes/shared/splitter.css",
      "toolkit/themes/shared/tabbox.css",
      "toolkit/themes/shared/toolbar.css",
      "toolkit/themes/shared/toolbarbutton.css",
      "toolkit/themes/shared/tree/tree.css",
      "toolkit/themes/windows/global/autocomplete.css",
      "toolkit/themes/windows/global/button.css",
      "toolkit/themes/windows/global/global.css",
      "toolkit/themes/windows/global/printPageSetup.css",
      "toolkit/themes/windows/global/richlistbox.css",
      "toolkit/themes/windows/global/wizard.css",
      "toolkit/themes/windows/mozapps/update/updates.css",
    ],
  },
  {
    // stylelint fixes for this rule will be addressed in Bug 1992411
    name: "rollout-use-font-size-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-font-size-tokens": null,
    },
    files: [
      "browser/base/content/aboutDialog.css",
      "browser/branding/aurora/stubinstaller/installing_page.css",
      "browser/branding/aurora/stubinstaller/profile_cleanup_page.css",
      "browser/branding/nightly/stubinstaller/installing_page.css",
      "browser/branding/nightly/stubinstaller/profile_cleanup_page.css",
      "browser/branding/official/stubinstaller/installing_page.css",
      "browser/branding/official/stubinstaller/profile_cleanup_page.css",
      "browser/branding/unofficial/stubinstaller/installing_page.css",
      "browser/branding/unofficial/stubinstaller/profile_cleanup_page.css",
      "browser/components/aboutlogins/content/aboutLoginsImportReport.css",
      "browser/components/aboutlogins/content/components/confirmation-dialog.css",
      "browser/components/aboutlogins/content/components/generic-dialog.css",
      "browser/components/aboutlogins/content/components/login-alert.css",
      "browser/components/aboutlogins/content/components/login-item.css",
      "browser/components/aboutlogins/content/components/login-list-lit-item.css",
      "browser/components/aboutlogins/content/components/login-list.css",
      "browser/components/aboutlogins/content/components/login-message-popup.css",
      "browser/components/aboutlogins/content/components/remove-logins-dialog.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/backup/content/password-rules-tooltip.css",
      "browser/components/backup/content/password-validation-inputs.css",
      "browser/components/backup/content/turn-on-scheduled-backups.css",
      "browser/components/firefoxview/card-container.css",
      "browser/components/firefoxview/history.css",
      "browser/components/firefoxview/view-syncedtabs.css",
      "browser/components/genai/chat.css",
      "browser/components/genai/content/link-preview-card.css",
      "browser/components/genai/content/smart-assist.css",
      "browser/components/messagepreview/messagepreview.css",
      "browser/components/protections/content/protections.css",
      "browser/components/screenshots/overlay/overlay.css",
      "browser/components/search/content/contentSearchUI.css",
      "browser/components/search/test/browser/telemetry/serp.css",
      "browser/components/sidebar/sidebar-panel-header.css",
      "browser/components/urlbar/tests/browser/dynamicResult0.css",
      "browser/components/urlbar/tests/browser/dynamicResult1.css",
      "browser/extensions/formautofill/skin/shared/editAddress.css",
      "browser/extensions/formautofill/skin/shared/editDialog-shared.css",
      "browser/extensions/newtab/content-src/components/Card/_Card.scss",
      "browser/extensions/newtab/content-src/components/CollapsibleSection/_CollapsibleSection.scss",
      "browser/extensions/newtab/content-src/components/ContextMenu/_ContextMenu.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamBase/_DiscoveryStreamBase.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSCard/_DSCard.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/DSMessage/_DSMessage.scss",
      "browser/extensions/newtab/content-src/components/DiscoveryStreamComponents/PromoCard/_PromoCard.scss",
      "browser/extensions/newtab/content-src/components/ErrorBoundary/_ErrorBoundary.scss",
      "browser/extensions/newtab/content-src/components/TopSites/_TopSites.scss",
      "browser/extensions/newtab/content-src/components/Weather/_Weather.scss",
      "browser/extensions/newtab/content-src/components/Widgets/FocusTimer/_FocusTimer.scss",
      "browser/extensions/newtab/content-src/styles/_mixins.scss",
      "browser/extensions/webcompat/about-compat/aboutCompat.css",
      "browser/themes/linux/browser.css",
      "browser/themes/osx/browser.css",
      "browser/themes/osx/customizableui/panelUI.css",
      "browser/themes/shared/UITour.css",
      "browser/themes/shared/autocomplete.css",
      "browser/themes/shared/browser-shared.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/downloads/allDownloadsView.inc.css",
      "browser/themes/shared/downloads/downloads.inc.css",
      "browser/themes/shared/formautofill-notification.css",
      "browser/themes/shared/identity-credential-notification.css",
      "browser/themes/shared/migration/migration-wizard.css",
      "browser/themes/shared/notification-icons.css",
      "browser/themes/shared/places/editBookmark.css",
      "browser/themes/shared/places/editBookmarkPanel.css",
      "browser/themes/shared/places/sidebar.css",
      "browser/themes/shared/preferences/fxaPairDevice.css",
      "browser/themes/shared/preferences/preferences.css",
      "browser/themes/shared/preferences/privacy.css",
      "browser/themes/shared/preferences/siteDataSettings.css",
      "browser/themes/shared/privatebrowsing/aboutPrivateBrowsing.css",
      "browser/themes/shared/sidebar.css",
      "browser/themes/shared/syncedtabs/sidebar.css",
      "browser/themes/shared/tabbrowser/fullscreen-and-pointerlock.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/translations/panel.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/shared/urlbarView.css",
      "browser/themes/windows/browser.css",
      "dom/crypto/test/test_WebCrypto.css",
      "dom/xml/test/old/books/classic.css",
      "dom/xml/test/old/books/common.css",
      "dom/xml/test/old/books/list.css",
      "layout/generic/test/frame_selection_underline.css",
      "layout/mathml/mathml.css",
      "layout/style/res/html.css",
      "layout/style/res/ua.css",
      "testing/mochitest/static/harness.css",
      "testing/mozbase/mozlog/mozlog/formatters/html/style.css",
      "testing/talos/talos/tests/scroll/reader.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/aboutmemory/content/aboutMemory.css",
      "toolkit/components/aboutprocesses/content/aboutProcesses.css",
      "toolkit/components/aboutthirdparty/content/aboutThirdParty.css",
      "toolkit/components/aboutwebauthn/content/aboutWebauthn.css",
      "toolkit/components/certviewer/content/components/certificate-section.css",
      "toolkit/components/certviewer/content/components/info-group.css",
      "toolkit/components/certviewer/content/components/info-item.css",
      "toolkit/components/certviewer/content/components/list-item.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/components/printing/content/simplifyMode.css",
      "toolkit/components/satchel/megalist/content/components/login-line/login-line.css",
      "toolkit/content/aboutLogging/aboutLogging.css",
      "toolkit/content/aboutMozilla.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/widgets/moz-input-text/moz-input-text.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/themes/mobile/global/aboutMemory.css",
      "toolkit/themes/shared/aboutHttpsOnlyError.css",
      "toolkit/themes/shared/aboutNetError.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/dirListing/dirListing.css",
      "toolkit/themes/shared/error-pages.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/narrate.css",
      "toolkit/themes/shared/offlineSupportPages.css",
      "toolkit/themes/shared/pictureinpicture/player.css",
      "toolkit/themes/shared/pictureinpicture/texttracks.css",
      "toolkit/themes/shared/toolbarbutton.css",
      "tools/tryselect/selectors/chooser/static/style.css",
    ],
  },
  {
    // stylelint fixes for this rule will be addressed in Bug 1992736
    name: "rollout-use-font-weight-tokens",
    rules: {
      "stylelint-plugin-mozilla/use-font-weight-tokens": null,
    },
    files: [
      "browser/base/content/aboutDialog.css",
      "browser/base/content/safeMode.css",
      "browser/branding/aurora/stubinstaller/profile_cleanup_page.css",
      "browser/branding/nightly/stubinstaller/profile_cleanup_page.css",
      "browser/branding/official/stubinstaller/installing_page.css",
      "browser/branding/official/stubinstaller/profile_cleanup_page.css",
      "browser/branding/unofficial/stubinstaller/profile_cleanup_page.css",
      "browser/components/aboutlogins/content/aboutLogins.css",
      "browser/components/aboutlogins/content/aboutLoginsImportReport.css",
      "browser/components/aboutlogins/content/components/confirmation-dialog.css",
      "browser/components/aboutlogins/content/components/import-error-dialog.css",
      "browser/components/aboutlogins/content/components/import-summary-dialog.css",
      "browser/components/aboutlogins/content/components/login-alert.css",
      "browser/components/aboutlogins/content/components/login-list-lit-item.css",
      "browser/components/aboutlogins/content/components/remove-logins-dialog.css",
      "browser/components/aboutwelcome/content-src/aboutwelcome.scss",
      "browser/components/asrouter/content-src/components/ASRouterAdmin/ASRouterAdmin.scss",
      "browser/components/asrouter/content-src/styles/_feature-callout.scss",
      "browser/components/backup/content/password-rules-tooltip.css",
      "browser/components/backup/content/password-validation-inputs.css",
      "browser/components/backup/content/restore-from-backup.css",
      "browser/components/backup/content/turn-on-scheduled-backups.css",
      "browser/components/firefoxview/card-container.css",
      "browser/components/firefoxview/fxview-tab-row.css",
      "browser/components/firefoxview/history.css",
      "browser/components/firefoxview/view-syncedtabs.css",
      "browser/components/genai/content/smart-assist.css",
      "browser/components/protections/content/protections.css",
      "browser/components/search/content/contentSearchUI.css",
      "browser/components/tabunloader/content/aboutUnloads.css",
      "browser/components/textrecognition/textrecognition.css",
      "browser/extensions/webcompat/about-compat/aboutCompat.css",
      "browser/themes/linux/browser.css",
      "browser/themes/shared/UITour.css",
      "browser/themes/shared/aboutTabCrashed.css",
      "browser/themes/shared/addon-notification.css",
      "browser/themes/shared/addons/extension-controlled.css",
      "browser/themes/shared/autocomplete.css",
      "browser/themes/shared/blockedSite.css",
      "browser/themes/shared/browser-shared.css",
      "browser/themes/shared/controlcenter/panel.css",
      "browser/themes/shared/customizableui/customizeMode.css",
      "browser/themes/shared/customizableui/panelUI-shared.css",
      "browser/themes/shared/identity-credential-notification.css",
      "browser/themes/shared/migration/migration-wizard.css",
      "browser/themes/shared/pageInfo.css",
      "browser/themes/shared/places/editBookmarkPanel.css",
      "browser/themes/shared/preferences/fxaPairDevice.css",
      "browser/themes/shared/preferences/preferences.css",
      "browser/themes/shared/preferences/privacy.css",
      "browser/themes/shared/preferences/siteDataSettings.css",
      "browser/themes/shared/privatebrowsing/aboutPrivateBrowsing.css",
      "browser/themes/shared/search/searchbar.css",
      "browser/themes/shared/setDesktopBackground.css",
      "browser/themes/shared/tabbrowser/ctrlTab.css",
      "browser/themes/shared/tabbrowser/fullscreen-and-pointerlock.css",
      "browser/themes/shared/tabbrowser/tabs.css",
      "browser/themes/shared/translations/panel.css",
      "browser/themes/shared/urlbar-dynamic-results.css",
      "browser/themes/shared/urlbar-searchbar.css",
      "browser/themes/windows/browser.css",
      "dom/crypto/test/test_WebCrypto.css",
      "dom/events/test/pointerevents/wpt/pointerevent_styles.css",
      "dom/xml/test/old/books/classic.css",
      "dom/xml/test/old/books/common.css",
      "dom/xml/test/old/books/list.css",
      "dom/xml/test/old/xmlbase/xmlbase.css",
      "layout/mathml/mathml.css",
      "layout/style/res/forms.css",
      "layout/style/res/html.css",
      "layout/style/res/ua.css",
      "layout/style/res/viewsource.css",
      "security/manager/pki/resources/content/clientauthask.css",
      "security/manager/pki/resources/content/exceptionDialog.css",
      "testing/mozbase/mozlog/mozlog/formatters/html/style.css",
      "toolkit/components/aboutconfig/content/aboutconfig.css",
      "toolkit/components/aboutinference/content/aboutInference.css",
      "toolkit/components/aboutmemory/content/aboutMemory.css",
      "toolkit/components/aboutprocesses/content/aboutProcesses.css",
      "toolkit/components/aboutwebauthn/content/aboutWebauthn.css",
      "toolkit/components/aboutwindowsmessages/content/aboutWindowsMessages.css",
      "toolkit/components/certviewer/content/components/info-group.css",
      "toolkit/components/certviewer/content/components/info-item.css",
      "toolkit/components/normandy/content/about-studies/about-studies.css",
      "toolkit/content/aboutLogging/aboutLogging.css",
      "toolkit/content/aboutTelemetry.css",
      "toolkit/content/aboutUrlClassifier.css",
      "toolkit/content/aboutwebrtc/aboutWebrtc.css",
      "toolkit/content/resetProfile.css",
      "toolkit/content/widgets/moz-box-common.css",
      "toolkit/content/widgets/moz-message-bar/moz-message-bar.css",
      "toolkit/content/widgets/moz-page-nav/moz-page-nav-button.css",
      "toolkit/mozapps/extensions/content/aboutaddons.css",
      "toolkit/mozapps/extensions/content/shortcuts.css",
      "toolkit/mozapps/handling/content/handler.css",
      "toolkit/themes/linux/mozapps/update/updates.css",
      "toolkit/themes/mobile/global/aboutMemory.css",
      "toolkit/themes/mobile/global/aboutNetworking.css",
      "toolkit/themes/mobile/global/aboutSupport.css",
      "toolkit/themes/osx/global/wizard.css",
      "toolkit/themes/osx/mozapps/handling/handling.css",
      "toolkit/themes/osx/mozapps/update/updates.css",
      "toolkit/themes/shared/aboutHttpsOnlyError.css",
      "toolkit/themes/shared/aboutNetError.css",
      "toolkit/themes/shared/aboutReader.css",
      "toolkit/themes/shared/aboutSupport.css",
      "toolkit/themes/shared/alert.css",
      "toolkit/themes/shared/appPicker.css",
      "toolkit/themes/shared/commonDialog.css",
      "toolkit/themes/shared/datetimeinputpickers.css",
      "toolkit/themes/shared/dirListing/dirListing.css",
      "toolkit/themes/shared/downloads/unknownContentType.css",
      "toolkit/themes/shared/findbar.css",
      "toolkit/themes/shared/global-shared.css",
      "toolkit/themes/shared/in-content/common-shared.css",
      "toolkit/themes/shared/in-content/info-pages.css",
      "toolkit/themes/shared/menu.css",
      "toolkit/themes/shared/menulist.css",
      "toolkit/themes/shared/toolbarbutton.css",
      "toolkit/themes/windows/global/global.css",
      "toolkit/themes/windows/global/wizard.css",
      "toolkit/themes/windows/mozapps/handling/handling.css",
      "toolkit/themes/windows/mozapps/update/updates.css",
    ],
  },
];
