/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.java.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.java.AccessModifier;
import com.intellij.util.io.java.ClassFileBuilder;
import com.intellij.util.io.java.impl.ClassFileBuilderImplKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J-\u0010\u0013\u001a\u00020\t*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0002\b\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/io/java/impl/ClassFileBuilderImpl;", "Lcom/intellij/util/io/java/ClassFileBuilder;", "name", "", "<init>", "(Ljava/lang/String;)V", "writer", "Lorg/jetbrains/org/objectweb/asm/ClassWriter;", "field", "", "type", "access", "Lcom/intellij/util/io/java/AccessModifier;", "Lkotlin/reflect/KClass;", "addField", "typeDescriptor", "generate", "targetRoot", "Lcom/intellij/util/io/DirectoryContentBuilder;", "directories", "relativePath", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "intellij.platform.testFramework.impl"})
@SourceDebugExtension(value={"SMAP\nClassFileBuilderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassFileBuilderImpl.kt\ncom/intellij/util/io/java/impl/ClassFileBuilderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 DirectoryContentSpec.kt\ncom/intellij/util/io/DirectoryContentBuilder\n*L\n1#1,75:1\n1557#2:76\n1628#2,3:77\n37#3,2:80\n67#4,4:82\n*S KotlinDebug\n*F\n+ 1 ClassFileBuilderImpl.kt\ncom/intellij/util/io/java/impl/ClassFileBuilderImpl\n*L\n35#1:76\n35#1:77,3\n35#1:80,2\n49#1:82,4\n*E\n"})
public final class ClassFileBuilderImpl
extends ClassFileBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final ClassWriter writer;

    public ClassFileBuilderImpl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.writer = new ClassWriter(2);
    }

    @Override
    public void field(@NotNull String name, @NotNull String type, @NotNull AccessModifier access) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        this.addField(name, "L" + ClassFileBuilderImplKt.access$toJvmName(type) + ";", access);
    }

    @Override
    public void field(@NotNull String name, @NotNull KClass<?> type, @NotNull AccessModifier access) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        String string = Type.getDescriptor((Class)JvmClassMappingKt.getJavaClass(type));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptor(...)");
        this.addField(name, string, access);
    }

    private final void addField(String name, String typeDescriptor, AccessModifier access) {
        this.writer.visitField(ClassFileBuilderImplKt.access$toAsmCode(access), name, typeDescriptor, null, null).visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull DirectoryContentBuilder targetRoot) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
        Iterable iterable = this.getInterfaces();
        String string = StringsKt.replace$default((String)this.getSuperclass(), (char)'.', (char)'/', (boolean)false, (int)4, null);
        String string2 = null;
        String string3 = ClassFileBuilderImplKt.access$toJvmName(this.name);
        int n = ClassFileBuilderImplKt.access$toAsmCode(this.getAccess());
        int n2 = ClassFileBuilderImplKt.access$toAsmCode(this.getJavaVersion());
        ClassWriter classWriter = this.writer;
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string4 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$generate$stub_for_inlining = false;
            boolean bl = false;
            collection.add(ClassFileBuilderImplKt.access$toJvmName((String)p0));
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        classWriter.visit(n2, n, string3, string2, string, thisCollection$iv.toArray(new String[0]));
        this.writer.visitEnd();
        String string5 = StringUtil.getPackageName((String)this.name);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPackageName(...)");
        this.directories(targetRoot, StringsKt.replace$default((String)string5, (char)'.', (char)'/', (boolean)false, (int)4, null), (Function1<? super DirectoryContentBuilder, Unit>)((Function1)arg_0 -> ClassFileBuilderImpl.generate$lambda$0(this, arg_0)));
    }

    private final void directories(DirectoryContentBuilder $this$directories, String relativePath, Function1<? super DirectoryContentBuilder, Unit> content) {
        if (((CharSequence)relativePath).length() == 0) {
            content.invoke((Object)$this$directories);
        } else {
            String string = PathUtil.getParentPath((String)relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            this.directories($this$directories, string, (Function1<? super DirectoryContentBuilder, Unit>)((Function1)arg_0 -> ClassFileBuilderImpl.directories$lambda$2(relativePath, content, arg_0)));
        }
    }

    private static final Unit generate$lambda$0(ClassFileBuilderImpl this$0, DirectoryContentBuilder $this$directories) {
        Intrinsics.checkNotNullParameter((Object)$this$directories, (String)"$this$directories");
        String string = StringUtil.getShortName((String)this$0.name) + ".class";
        byte[] byArray = this$0.writer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        $this$directories.file(string, byArray);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit directories$lambda$2(String $relativePath, Function1 $content, DirectoryContentBuilder $this$directories) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$directories, (String)"$this$directories");
        DirectoryContentBuilder directoryContentBuilder = $this$directories;
        String string = PathUtil.getFileName((String)$relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String name$iv = string;
        boolean $i$f$dir = false;
        DirectorySpec dirDefinition$iv = new DirectorySpec(null, 1, null);
        DirectoryContentBuilder $this$directories_u24lambda_u242_u24lambda_u241 = new DirectoryContentBuilderImpl(dirDefinition$iv);
        boolean bl = false;
        $content.invoke((Object)$this$directories_u24lambda_u242_u24lambda_u241);
        this_$iv.addChild(name$iv, dirDefinition$iv);
        return Unit.INSTANCE;
    }
}

