/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;

public class FlexibleSemaphore {
    private final Object LOCK = new Object();
    private static final int TIMEOUT = 250;
    private int myAvailable;
    private int myTaken;

    public FlexibleSemaphore(int available) {
        if (available < 1) {
            throw new IllegalArgumentException();
        }
        this.myAvailable = available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take() {
        Object object = this.LOCK;
        synchronized (object) {
            while (this.myTaken >= this.myAvailable) {
                ProgressManager.checkCanceled();
                try {
                    this.LOCK.wait(250L);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }
            ++this.myTaken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myTaken == 0) {
                throw new IllegalStateException();
            }
            --this.myTaken;
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable(int newAvailable) {
        if (newAvailable < 1) {
            throw new IllegalArgumentException();
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean notify = newAvailable > this.myAvailable;
            this.myAvailable = newAvailable;
            if (notify) {
                this.LOCK.notifyAll();
            }
        }
    }
}

