/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u000e\b\u0006\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0086\b\u00f8\u0001\u0000J>\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookUtil;", "", "<init>", "()V", "notebookAppearance", "Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "Lcom/intellij/openapi/editor/Editor;", "getNotebookAppearance", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "paintNotebookCellBackgroundGutter", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "lines", "Lkotlin/ranges/IntRange;", "top", "", "height", "presentationModeMasking", "", "actionBetweenBackgroundAndStripe", "Lkotlin/Function0;", "paintCellStripe", "appearance", "stripe", "Ljava/awt/Color;", "paintCaretRow", "intellij.notebooks.ui"})
public final class NotebookUtil {
    @NotNull
    public static final NotebookUtil INSTANCE = new NotebookUtil();

    private NotebookUtil() {
    }

    @NotNull
    public final NotebookEditorAppearance getNotebookAppearance(@NotNull Editor $this$notebookAppearance) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookAppearance, (String)"<this>");
        Object object = NotebookEditorAppearance.Companion.getNOTEBOOK_APPEARANCE_KEY().get((UserDataHolder)$this$notebookAppearance);
        Intrinsics.checkNotNull((Object)object);
        return (NotebookEditorAppearance)object;
    }

    public final void paintNotebookCellBackgroundGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull IntRange lines, int top, int height, boolean presentationModeMasking, @NotNull Function0<Unit> actionBetweenBackgroundAndStripe) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter(actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        int diffViewOffset = 6;
        NotebookEditorAppearance appearance = this.getNotebookAppearance((Editor)editor);
        Color stripe = appearance.getCellStripeColor(editor, lines);
        Color stripeHover = appearance.getCellStripeHoverColor(editor, lines);
        int borderWidth = appearance.getLeftBorderWidth();
        int gutterWidth = editor.getGutterComponentEx().getWidth();
        if (presentationModeMasking) {
            triple = new Triple((Object)(r.width - borderWidth - gutterWidth), (Object)gutterWidth, (Object)editor.getColorsScheme().getDefaultBackground());
        } else {
            Integer n = r.width - borderWidth;
            Integer n2 = borderWidth;
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            triple = new Triple((Object)n, (Object)n2, (Object)appearance.getCodeCellBackground(editorColorsScheme));
        }
        Triple triple2 = triple;
        int fillX = ((Number)triple2.component1()).intValue();
        int fillWidth = ((Number)triple2.component2()).intValue();
        Color fillColor = (Color)triple2.component3();
        g.setColor(fillColor);
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX + diffViewOffset, top, fillWidth - diffViewOffset, height);
        } else {
            g.fillRect(fillX, top, fillWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
        if (!Intrinsics.areEqual((Object)editor.getUserData(NotebookEditorUiUtilKt.isFoldingEnabledKey()), (Object)true)) {
            if (editor.getEditorKind() == EditorKind.DIFF) {
                return;
            }
            if (stripe != null) {
                this.paintCellStripe(appearance, g, r, stripe, top, height, (Editor)editor);
            }
            if (stripeHover != null) {
                g.setColor(stripeHover);
                g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineHoverWidth(), height);
            }
        }
    }

    public static /* synthetic */ void paintNotebookCellBackgroundGutter$default(NotebookUtil $this, EditorImpl editor, Graphics g, Rectangle r, IntRange lines, int top, int height, boolean presentationModeMasking, Function0 actionBetweenBackgroundAndStripe, int n, Object object) {
        Triple triple;
        if ((n & 0x40) != 0) {
            presentationModeMasking = false;
        }
        if ((n & 0x80) != 0) {
            actionBetweenBackgroundAndStripe = paintNotebookCellBackgroundGutter.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        int diffViewOffset = 6;
        NotebookEditorAppearance appearance = $this.getNotebookAppearance((Editor)editor);
        Color stripe = appearance.getCellStripeColor(editor, lines);
        Color stripeHover = appearance.getCellStripeHoverColor(editor, lines);
        int borderWidth = appearance.getLeftBorderWidth();
        int gutterWidth = editor.getGutterComponentEx().getWidth();
        if (presentationModeMasking) {
            triple = new Triple((Object)(r.width - borderWidth - gutterWidth), (Object)gutterWidth, (Object)editor.getColorsScheme().getDefaultBackground());
        } else {
            Integer n2 = r.width - borderWidth;
            Integer n3 = borderWidth;
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            triple = new Triple((Object)n2, (Object)n3, (Object)appearance.getCodeCellBackground(editorColorsScheme));
        }
        Triple triple2 = triple;
        int fillX = ((Number)triple2.component1()).intValue();
        int fillWidth = ((Number)triple2.component2()).intValue();
        Color fillColor = (Color)triple2.component3();
        g.setColor(fillColor);
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX + diffViewOffset, top, fillWidth - diffViewOffset, height);
        } else {
            g.fillRect(fillX, top, fillWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
        if (!Intrinsics.areEqual((Object)editor.getUserData(NotebookEditorUiUtilKt.isFoldingEnabledKey()), (Object)true)) {
            if (editor.getEditorKind() == EditorKind.DIFF) {
                return;
            }
            if (stripe != null) {
                $this.paintCellStripe(appearance, g, r, stripe, top, height, (Editor)editor);
            }
            if (stripeHover != null) {
                g.setColor(stripeHover);
                g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineHoverWidth(), height);
            }
        }
    }

    public final void paintCellStripe(@NotNull NotebookEditorAppearance appearance, @NotNull Graphics g, @NotNull Rectangle r, @NotNull Color stripe, int top, int height, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)stripe, (String)"stripe");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        g.setColor(stripe);
        g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineWidth(editor), height);
    }

    public final void paintCaretRow(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        if (editor.getSettings().isCaretRowShown()) {
            CaretModelImpl caretModelImpl = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModelImpl, (String)"getCaretModel(...)");
            CaretModelImpl caretModel = caretModelImpl;
            int caretLine = caretModel.getLogicalPosition().line;
            int n = lines.getFirst();
            boolean bl = caretLine <= lines.getLast() ? n <= caretLine : false;
            if (bl) {
                g.setColor(editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
                g.fillRect(0, editor.visualLineToY(caretModel.getVisualPosition().line), g.getClipBounds().width, editor.getLineHeight());
            }
        }
    }
}

