/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.protocol.runtime.CallArgument;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a8\u0006\u0007"}, d2={"createCallArgument", "Lorg/jetbrains/wip/protocol/runtime/CallArgument;", "value", "Lorg/jetbrains/debugger/values/Value;", "wrapObjectExpression", "", "rawValue", "intellij.javascript.wip.backend"})
public final class EvaluateSessionKt {
    @NotNull
    public static final CallArgument createCallArgument(@NotNull Value value) {
        CallArgument callArgument;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof SerializableValue) {
            return ((SerializableValue)value).createCallArgumentParam();
        }
        if (value.getType() == ValueType.UNDEFINED) {
            callArgument = new CallArgument(null, null, null, 7, null);
        } else if (value.getType() == ValueType.NULL) {
            callArgument = new CallArgument(null, null, null, 6, null);
        } else if (value instanceof PrimitiveValue) {
            callArgument = new CallArgument(((PrimitiveValue)value).getValueString(), null, null, 6, null);
        } else {
            throw new IllegalArgumentException("Cannot serialize additional context property " + value);
        }
        return callArgument;
    }

    @NotNull
    public static final String wrapObjectExpression(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Regex objectRegex = new Regex("^\\s*\\{\\s*(.*)\\s*}[\\s;]*$");
        MatchResult matchResult = objectRegex.matchEntire((CharSequence)((Object)StringsKt.trim((CharSequence)rawValue)).toString());
        if (matchResult == null) {
            return rawValue;
        }
        MatchResult matchResult2 = matchResult;
        String body = (String)matchResult2.getGroupValues().get(1);
        int level = 0;
        int n = body.length();
        for (int i = 0; i < n; ++i) {
            char c = body.charAt(i);
            if (c == '{') {
                ++level;
                continue;
            }
            if (c != '}' || --level >= 0) continue;
            return rawValue;
        }
        return "({" + body + "})";
    }
}

