/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebugUtilsKt;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.scripts.RootsDirectoryInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfo;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.SourceTabManagerKt;
import com.intellij.javascript.debugger.scripts.SourcesTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.platform.util.coroutines.flow.FlowKt;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u001a\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lkotlinx/coroutines/CoroutineScope;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "root", "Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "getRoot", "()Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "updateScriptsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "addScript", "script", "Lorg/jetbrains/debugger/Script;", "doAddScript", "url", "Lcom/intellij/util/Url;", "suggestRootNode", "removeScript", "doRemoveScript", "setTreeModel", "treeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "treeStructure", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeStructure;", "clear", "intellij.javascript.debugger"})
public final class SourceTabManager {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ScriptDirectoryInfo root;
    @NotNull
    private final MutableSharedFlow<Unit> updateScriptsFlow;

    public SourceTabManager(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.debugProcess = debugProcess;
        this.cs = cs;
        this.root = new ScriptDirectoryInfo("<root>", Urls.newUnparsable((String)""), null, 4, null);
        this.updateScriptsFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final ScriptDirectoryInfo getRoot() {
        return this.root;
    }

    public final void addScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (!ApplicationManager.getApplication().isInternal() && SourceTabManagerKt.isInternalScriptUrl(script.getUrl())) {
            return;
        }
        if (script.getSourceMap() == null) {
            this.doAddScript(script, script.getUrl());
        } else {
            SourceMap sourceMap = script.getSourceMap();
            Intrinsics.checkNotNull((Object)sourceMap);
            for (Url source : sourceMap.getSources()) {
                this.doAddScript(script, source);
            }
        }
        if (!this.updateScriptsFlow.tryEmit((Object)Unit.INSTANCE)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void doAddScript(Script script, Url url) {
        this.suggestRootNode(script, url).addChild(script, url);
    }

    private final ScriptDirectoryInfo suggestRootNode(Script script, Url url) {
        ScriptDirectoryInfo child;
        String rootName = null;
        Icon icon = PlatformIcons.FOLDER_ICON;
        int weight = 5;
        if (url.getScheme() == null && !url.isInLocalFileSystem()) {
            rootName = JSDebuggerBundle.message("js.scripts.nodes.root.no", new Object[0]);
        } else if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            rootName = JSDebuggerBundle.message("js.scripts.nodes.root.evaluated", new Object[0]);
            --weight;
        } else if (!JavaScriptDebugProcessKt.hasWebpackScheme(url) && ScriptsKt.isSpecial(url)) {
            rootName = JSDebuggerBundle.message("js.scripts.nodes.root.lib", new Object[0]);
            icon = PlatformIcons.LIBRARY_ICON;
            ++weight;
        } else {
            return this.root;
        }
        Object object = this.root.getChildNameToInfo().get(rootName);
        ScriptDirectoryInfo scriptDirectoryInfo = child = object instanceof ScriptDirectoryInfo ? (ScriptDirectoryInfo)object : null;
        if (child == null) {
            Url url2 = Urls.newUnparsable((String)rootName);
            object = icon;
            Intrinsics.checkNotNull((Object)object);
            child = new RootsDirectoryInfo(rootName, url2, (Icon)object, this.debugProcess, weight);
            this.root.getChildNameToInfo().put(rootName, child);
        }
        return child;
    }

    public final void removeScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (JSDebugUtilsKt.isEvaluatedOneLineScript(script)) {
            return;
        }
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap != null) {
            SourceMap it = sourceMap;
            boolean bl = false;
            for (Url source : it.getSources()) {
                this.doRemoveScript(script, source);
            }
        }
        this.doRemoveScript(script, script.getUrl());
        if (!this.updateScriptsFlow.tryEmit((Object)Unit.INSTANCE)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void doRemoveScript(Script script, Url url) {
        ScriptDirectoryInfo directory = this.suggestRootNode(script, url);
        directory.removeChild(url);
        if (directory != this.root && !directory.hasChildren()) {
            this.root.getChildNameToInfo().remove(directory.getName());
        }
    }

    public final void setTreeModel(@NotNull StructureTreeModel<?> treeModel, @NotNull SourcesTreeStructure treeStructure) {
        Intrinsics.checkNotNullParameter(treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)((Object)treeStructure), (String)"treeStructure");
        CoroutineScopeKt.cancelOnDispose$default((Job)BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)new CoroutineName("SourceTabManagerScriptUpdater")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, treeStructure, treeModel, null){
            int label;
            final /* synthetic */ SourceTabManager this$0;
            final /* synthetic */ SourcesTreeStructure $treeStructure;
            final /* synthetic */ StructureTreeModel<?> $treeModel;
            {
                this.this$0 = $receiver;
                this.$treeStructure = $treeStructure;
                this.$treeModel = $treeModel;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.throttle((Flow)((Flow)SourceTabManager.access$getUpdateScriptsFlow$p(this.this$0)), (long)300L).collect(new FlowCollector(this.$treeStructure, this.$treeModel){
                            final /* synthetic */ SourcesTreeStructure $treeStructure;
                            final /* synthetic */ StructureTreeModel<?> $treeModel;
                            {
                                this.$treeStructure = $treeStructure;
                                this.$treeModel = $treeModel;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this.$treeStructure.clearCaches();
                                this.$treeModel.invalidateAsync();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null), (Disposable)((Disposable)treeModel), (boolean)false, (int)2, null);
        if (!this.updateScriptsFlow.tryEmit((Object)Unit.INSTANCE)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void clear() {
        this.root.getChildNameToInfo().clear();
        if (!this.updateScriptsFlow.tryEmit((Object)Unit.INSTANCE)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public static final /* synthetic */ MutableSharedFlow access$getUpdateScriptsFlow$p(SourceTabManager $this) {
        return $this.updateScriptsFlow;
    }
}

