/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.dependency;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uml.java.JavaUmlRelationships;
import com.intellij.uml.java.dependency.DependenciesConfiguration;
import com.intellij.uml.java.dependency.RelationshipAnalysisSimpleResult;
import com.intellij.uml.java.dependency.RelationshipAnalyzer;
import com.intellij.uml.java.utils.LightElementFacade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class UastClassDependencyAnalyzer
implements RelationshipAnalyzer<PsiClass, RelationshipAnalysisSimpleResult<PsiClass>> {
    @Override
    @NotNull
    public Collection<RelationshipAnalysisSimpleResult<PsiClass>> compute(@NotNull PsiClass source) {
        if (source == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(0);
        }
        DependenciesConfiguration conf = DependenciesConfiguration.fromUmlConfiguration(DiagramConfiguration.getInstance());
        PsiElement initial = UastClassDependencyAnalyzer.getPhysicalElement(source);
        MyDependencyCollectingVisitor uastVisitor = new MyDependencyCollectingVisitor(source, conf);
        initial.accept(uastVisitor.asPsiVisitor());
        List<RelationshipAnalysisSimpleResult<PsiClass>> list = uastVisitor.getCollectedDependencies();
        if (list == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static PsiElement getPhysicalElement(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(2);
        }
        PsiElement anchor = LightElementFacade.asSourcePsi((PsiElement)psiClass);
        PsiElement source = psiClass.getNavigationElement();
        Object object = source != null ? source : (anchor != null ? anchor : psiClass);
        if (object == null) {
            UastClassDependencyAnalyzer.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyDependencyCollectingVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final List<RelationshipAnalysisSimpleResult<PsiClass>> myDependencies;
        @NotNull
        private final DependenciesConfiguration myConf;
        @NotNull
        private final Set<PsiElement> myAlreadyVisited;
        private static final Class<? extends UElement> @NotNull [] OUR_EXPECTED_UAST_TYPES = new Class[]{UField.class, UCallExpression.class, USimpleNameReferenceExpression.class, UTypeReferenceExpression.class};

        private MyDependencyCollectingVisitor(@NotNull PsiClass psiClass, @NotNull DependenciesConfiguration conf) {
            if (psiClass == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (conf == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(1);
            }
            this.myDependencies = new ArrayList<RelationshipAnalysisSimpleResult<PsiClass>>();
            this.myAlreadyVisited = new HashSet<PsiElement>();
            this.myClass = psiClass;
            this.myConf = conf;
        }

        @NotNull
        public PsiElementVisitor asPsiVisitor() {
            return new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    UElement uElement;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])OUR_EXPECTED_UAST_TYPES)) != null) {
                        uElement.accept((UastVisitor)this);
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyDependencyCollectingVisitor$1", "visitElement"));
                }
            };
        }

        private boolean shouldNotVisit(@NotNull UElement node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(2);
            }
            return this.isAlreadyVisited(node) || this.isInsideInnerClass(node);
        }

        private boolean isAlreadyVisited(@NotNull UElement uElement) {
            PsiElement sourcePsi;
            if (uElement == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(3);
            }
            if (!this.myAlreadyVisited.contains(sourcePsi = uElement.getSourcePsi())) {
                this.myAlreadyVisited.add(sourcePsi);
                return false;
            }
            return true;
        }

        private boolean isInsideInnerClass(@NotNull UElement node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(4);
            }
            return StreamEx.of((Iterator)UElementKt.getWithContainingElements((UElement)node).iterator()).select(UClass.class).findFirst(it -> !(it instanceof UAnonymousClass)).map(it -> !Objects.equals(this.myClass.getQualifiedName(), it.getQualifiedName())).orElse(true);
        }

        private static boolean isInsideDocs(@NotNull UElement node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(5);
            }
            return StreamEx.of((Iterator)UElementKt.getWithContainingElements((UElement)node).iterator()).anyMatch(it -> it instanceof UComment);
        }

        @NotNull
        private static DiagramRelationshipInfo inferDependencyRelationship(@NotNull UElement node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(6);
            }
            DiagramRelationshipInfo diagramRelationshipInfo = MyDependencyCollectingVisitor.isInsideDocs(node) ? JavaUmlRelationships.LINK_IN_DOCS : JavaUmlRelationships.DEPENDENCY;
            if (diagramRelationshipInfo == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(7);
            }
            return diagramRelationshipInfo;
        }

        public boolean visitField(@NotNull UField field) {
            if (field == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(8);
            }
            if (this.shouldNotVisit((UElement)field)) {
                return false;
            }
            String fieldName = field.getName();
            UTypeReferenceExpression typeReference = field.getTypeReference();
            if (typeReference == null) {
                return false;
            }
            HashSet visitedClasses = new HashSet();
            typeReference.getType().accept((PsiTypeVisitor)new MyTypeRecursiveVisitor((psiClass, isInsideCollection) -> {
                if (!visitedClasses.contains(psiClass)) {
                    visitedClasses.add(psiClass);
                    DiagramRelationshipInfoAdapter relationship = new DiagramRelationshipInfoAdapter.Builder(isInsideCollection != false ? JavaUmlRelationships.TO_MANY : JavaUmlRelationships.TO_ONE).setBottomTargetLabel(fieldName != null ? new DiagramRelationshipInfoAdapter.MutableColoredLabel(fieldName) : null).create();
                    this.add((PsiClass)psiClass, relationship, MyDependencyCollectingVisitor.getNavigatable(field.getSourcePsi()));
                }
            }));
            return false;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(9);
            }
            if (this.shouldNotVisit((UElement)node)) {
                return false;
            }
            UReferenceExpression constructingClassReference = node.getClassReference();
            if (constructingClassReference != null) {
                PsiElement resolved = constructingClassReference.resolve();
                PsiClass psiClass = MyDependencyCollectingVisitor.findConcreteClass(resolved instanceof PsiClass ? (PsiClass)resolved : null);
                if (psiClass != null) {
                    this.add(psiClass, JavaUmlRelationships.CREATE, MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
                }
            } else {
                PsiClass psiClass;
                PsiMethod resolvedMethod = node.resolve();
                if (resolvedMethod != null && (psiClass = resolvedMethod.getContainingClass()) != null) {
                    this.add(psiClass, MyDependencyCollectingVisitor.inferDependencyRelationship((UElement)node), MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
                }
            }
            return false;
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(10);
            }
            if (this.shouldNotVisit((UElement)node)) {
                return false;
            }
            PsiElement psiElement = node.resolve();
            if (psiElement instanceof PsiClass) {
                this.add((PsiClass)psiElement, MyDependencyCollectingVisitor.inferDependencyRelationship((UElement)node), MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()));
            }
            return false;
        }

        public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
            if (node == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(11);
            }
            if (this.shouldNotVisit((UElement)node)) {
                return false;
            }
            node.getType().accept((PsiTypeVisitor)new MyTypeRecursiveVisitor((psiClass, isInsideCollection) -> this.add((PsiClass)psiClass, MyDependencyCollectingVisitor.inferDependencyRelationship((UElement)node), MyDependencyCollectingVisitor.getNavigatable(node.getSourcePsi()))));
            return false;
        }

        @NotNull
        private List<RelationshipAnalysisSimpleResult<PsiClass>> getCollectedDependencies() {
            List<RelationshipAnalysisSimpleResult<PsiClass>> list = this.myDependencies;
            if (list == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(12);
            }
            return list;
        }

        private void add(@NotNull PsiClass target, @NotNull DiagramRelationshipInfo relationshipInfo, @Nullable PsiElement navigatableElement) {
            if (target == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(13);
            }
            if (relationshipInfo == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(14);
            }
            if (DiagramRelationshipInfoAdapter.equalsByName(relationshipInfo, JavaUmlRelationships.TO_ONE) && !this.myConf.myShowOneToOne || DiagramRelationshipInfoAdapter.equalsByName(relationshipInfo, JavaUmlRelationships.TO_MANY) && !this.myConf.myShowOneToMany || DiagramRelationshipInfoAdapter.equalsByName(relationshipInfo, JavaUmlRelationships.DEPENDENCY) && !this.myConf.myShowUsagesInCode || DiagramRelationshipInfoAdapter.equalsByName(relationshipInfo, JavaUmlRelationships.LINK_IN_DOCS) && !this.myConf.myShowLinksInDocs || Objects.equals(this.myClass.getQualifiedName(), target.getQualifiedName()) && !this.myConf.myShowCyclic || DiagramRelationshipInfoAdapter.equalsByName(relationshipInfo, JavaUmlRelationships.CREATE) && !this.myConf.myShowNewExpressions) {
                return;
            }
            this.myDependencies.add(new RelationshipAnalysisSimpleResult<PsiClass>(target, relationshipInfo, navigatableElement));
        }

        @Nullable
        private static PsiElement getNavigatable(@Nullable PsiElement psiElement) {
            return psiElement instanceof Navigatable ? psiElement : null;
        }

        @Nullable
        private static PsiClass findConcreteClass(@Nullable PsiClass psiClass) {
            while (psiClass instanceof PsiAnonymousClass) {
                psiClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)psiClass).getBaseClassType());
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conf";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uElement";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyDependencyCollectingVisitor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relationshipInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyDependencyCollectingVisitor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inferDependencyRelationship";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCollectedDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldNotVisit";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAlreadyVisited";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideInnerClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideDocs";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "inferDependencyRelationship";
                    break;
                }
                case 7: 
                case 12: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitField";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCallExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSimpleNameReferenceExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeReferenceExpression";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 12 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyTypeRecursiveVisitor
    extends PsiTypeVisitor<Object> {
        @NotNull
        private final BiConsumer<PsiClass, Boolean> myCallback;
        private boolean myIsInsideCollection;
        @NotNull
        private static final Set<String> OUR_COLLECTION_BASE_TYPES = Set.of("java.lang.Iterable", "java.util.Map", "java.util.Dictionary", "kotlin.collections.Iterable", "kotlin.collections.Map", "com.google.common.collect.Multimap", "com.google.common.collect.RangeMap", "com.google.common.collect.RangeSet", "com.google.common.collect.Table");

        private MyTypeRecursiveVisitor(@NotNull BiConsumer<PsiClass, Boolean> callback) {
            if (callback == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(0);
            }
            this.myCallback = callback;
        }

        public Object visitType(@NotNull PsiType type) {
            PsiClass psiClass;
            if (type == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(1);
            }
            if ((psiClass = MyTypeRecursiveVisitor.typeToClass(type)) instanceof PsiTypeParameter) {
                return null;
            }
            if (psiClass != null) {
                this.myCallback.accept(psiClass, this.myIsInsideCollection);
            }
            if (!this.myIsInsideCollection && MyTypeRecursiveVisitor.isCollection(type)) {
                this.myIsInsideCollection = true;
                this.visitSubComponentsRecursively(type);
                this.myIsInsideCollection = false;
            }
            return null;
        }

        private void visitSubComponentsRecursively(@NotNull PsiType type) {
            if (type == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(2);
            }
            if (type instanceof PsiClassType) {
                for (PsiType typeParameter : ((PsiClassType)type).getParameters()) {
                    typeParameter.accept((PsiTypeVisitor)this);
                }
            } else if (type instanceof PsiArrayType) {
                type.getDeepComponentType().accept((PsiTypeVisitor)this);
            }
        }

        @Nullable
        private static PsiClass typeToClass(@NotNull PsiType psiType) {
            if (psiType == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(3);
            }
            return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
        }

        private static boolean isCollection(@NotNull PsiType type) {
            if (type == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(4);
            }
            if (type instanceof PsiArrayType) {
                return true;
            }
            PsiClass aClass = MyTypeRecursiveVisitor.typeToClass(type);
            if (aClass == null) {
                return false;
            }
            return Stream.concat(Stream.of(aClass), MyTypeRecursiveVisitor.getAllInterfaces(aClass)).map(it -> it.getQualifiedName()).anyMatch(it -> it != null && OUR_COLLECTION_BASE_TYPES.contains(it));
        }

        @NotNull
        private static Stream<PsiClass> getAllInterfaces(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(5);
            }
            Stream<PsiClass> stream = Arrays.stream(psiClass.getInterfaces()).flatMap(it -> Stream.concat(Stream.of(it), MyTypeRecursiveVisitor.getAllInterfaces(it)));
            if (stream == null) {
                MyTypeRecursiveVisitor.$$$reportNull$$$0(6);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyTypeRecursiveVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/dependency/UastClassDependencyAnalyzer$MyTypeRecursiveVisitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllInterfaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSubComponentsRecursively";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "typeToClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isCollection";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllInterfaces";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

