/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions.export.disk;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.util.DiagramExportService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ObjectUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class DiagramExportToFileAction
extends DiagramAction {
    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramExportToFileAction.$$$reportNull$$$0(0);
        }
        if ((builder = DiagramExportToFileAction.getBuilder(e)) == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DiagramExportService.OutputFormat outputFormat = this.getOutputFormat();
        String exportDialogDescription = StringUtil.notNullize((String)e.getPresentation().getDescription());
        String exportDialogTitle = (String)ObjectUtils.notNull((Object)e.getPresentation().getText(), (Object)DiagramBundle.message("group.Diagram.ExportGroup.text", new Object[0]));
        VirtualFile diagramVirtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile dirToSaveIn = diagramVirtualFile != null ? diagramVirtualFile.getParent() : null;
        String targetFileName = diagramVirtualFile != null ? FileUtilRt.getNameWithoutExtension((String)diagramVirtualFile.getPresentableName()) : "diagram";
        VirtualFileWrapper virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(exportDialogTitle, exportDialogDescription, new String[]{outputFormat.getFileExt()}), project).save(dirToSaveIn, targetFileName);
        if (virtualFileWrapper == null) {
            return;
        }
        DiagramExportService.getInstance().runExportAsync(builder, outputFormat, (ThrowableComputable<OutputStream, IOException>)((ThrowableComputable)() -> new FileOutputStream(virtualFileWrapper.getFile())));
    }

    @NotNull
    public abstract DiagramExportService.OutputFormat getOutputFormat();

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramExportToFileAction.$$$reportNull$$$0(1);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/diagram/actions/export/disk/DiagramExportToFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

