/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public class ScriptLog {
    public static final String SCRIPT_LOG_VAR_NAME = "__log__";
    private final Project myProject;

    public ScriptLog(Project project2) {
        this.myProject = project2;
    }

    public void info(Object message) {
        this.log(message, NotificationType.INFORMATION);
    }

    public void warn(Object message) {
        this.log(message, NotificationType.WARNING);
    }

    public void error(Object message) {
        this.log(message, NotificationType.ERROR);
    }

    private void log(Object message, NotificationType type) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        Object location = "";
        for (StackTraceElement e : stackTrace) {
            String methodName = e.getMethodName();
            if (!"run".equals(methodName)) continue;
            String fileName = e.getFileName();
            assert (fileName != null);
            location = "(" + StringUtil.replace((String)fileName, (String)"a3cd264774bf4efb9ab609b250c5165c.groovy", (String)"") + ":" + e.getLineNumber() + ") ";
            break;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Structural Search");
        notificationGroup.createNotification((String)location + message, type).notify(this.myProject);
    }
}

