/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DeleteSelectionAction
extends AbstractGraphAction {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        if (e == null) {
            DeleteSelectionAction.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            DeleteSelectionAction.$$$reportNull$$$0(1);
        }
        DeleteProvider deleteProvider = (DeleteProvider)e.getData(DeleteProvider.DELETE_PROVIDER);
        GraphBuilder<?, ?> graphBuilder = this.getBuilder(e);
        if (deleteProvider == null || graphBuilder == null) {
            return;
        }
        List<Node> nodesToBeDeleted = DeleteSelectionAction.getNodesToBeDeleted(graph, graphBuilder, deleteProvider);
        List<Edge> edgesToBeDeleted = DeleteSelectionAction.getEdgesToBeDeleted(graph, graphBuilder, deleteProvider);
        if (nodesToBeDeleted.size() > 0 || edgesToBeDeleted.size() > 0) {
            String messageCaption;
            String messageText = GraphBundle.message("graph.delete.message", new Object[0]) + "?";
            if (0 == Messages.showOkCancelDialog((String)messageText, (String)(messageCaption = GraphBundle.message("graph.delete.message.caption", new Object[0])), (Icon)Messages.getQuestionIcon())) {
                for (Node node : nodesToBeDeleted) {
                    Object nodeObject = graphBuilder.getNodeObject(node);
                    if (nodeObject == null) continue;
                    deleteProvider.deleteNode(nodeObject);
                }
                for (Edge edge : edgesToBeDeleted) {
                    Object edgeObject = graphBuilder.getEdgeObject(edge);
                    if (edgeObject == null) continue;
                    deleteProvider.deleteEdge(edgeObject);
                }
            }
            graphBuilder.updateGraph();
        }
    }

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        if (e == null) {
            DeleteSelectionAction.$$$reportNull$$$0(2);
        }
        if (graph == null) {
            DeleteSelectionAction.$$$reportNull$$$0(3);
        }
        DeleteProvider deleteProvider = (DeleteProvider)e.getData(DeleteProvider.DELETE_PROVIDER);
        GraphBuilder<?, ?> graphBuilder = this.getBuilder(e);
        boolean enabled = false;
        if (deleteProvider == null || graphBuilder == null) {
            e.getPresentation().setVisible(false);
        } else {
            List<Node> toBeDeleted = DeleteSelectionAction.getNodesToBeDeleted(graph, graphBuilder, deleteProvider);
            List<Edge> edgesToBeDeleted = DeleteSelectionAction.getEdgesToBeDeleted(graph, graphBuilder, deleteProvider);
            enabled = toBeDeleted.size() > 0 || edgesToBeDeleted.size() > 0;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setText(GraphBundle.messagePointer("graph.delete.message", new Object[0]));
        e.getPresentation().setIcon(PlatformIcons.DELETE_ICON);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            DeleteSelectionAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    private static List<Node> getNodesToBeDeleted(Graph2D graph, @NotNull GraphBuilder graphBuilder, @NotNull DeleteProvider deleteProvider) {
        if (graphBuilder == null) {
            DeleteSelectionAction.$$$reportNull$$$0(5);
        }
        if (deleteProvider == null) {
            DeleteSelectionAction.$$$reportNull$$$0(6);
        }
        ArrayList<Node> toBeDeleted = new ArrayList<Node>();
        NodeCursor nc = graph.selectedNodes();
        while (nc.ok()) {
            Node node = nc.node();
            Object nodeObject = graphBuilder.getNodeObject(node);
            if (nodeObject != null && deleteProvider.canDeleteNode(nodeObject)) {
                toBeDeleted.add(node);
            }
            nc.next();
        }
        return toBeDeleted;
    }

    private static List<Edge> getEdgesToBeDeleted(Graph2D graph, GraphBuilder<?, ?> graphBuilder, DeleteProvider deleteProvider) {
        ArrayList<Edge> toBeDeleted = new ArrayList<Edge>();
        EdgeCursor edgeCursor = graph.selectedEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Object edgeObject = graphBuilder.getEdgeObject(edge);
            if (edgeObject != null && deleteProvider.canDeleteEdge(edgeObject)) {
                toBeDeleted.add(edge);
            }
            edgeCursor.next();
        }
        return toBeDeleted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/DeleteSelectionAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/DeleteSelectionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNodesToBeDeleted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

