/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.sdk.GoSdkService;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.workspaceModel.entities.VgoDependencyEntity;
import com.goide.vgo.project.workspaceModel.entities.VgoStandaloneModuleEntity;
import com.goide.vgo.project.workspaceModel.entities.VgoWorkspaceEntity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.go.GoLibraryDependency;
import com.intellij.packageChecker.go.UtilsKt;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002J\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001c*\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\r2\u0006\u0010\u0011\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/packageChecker/go/GoProjectDependenciesModel;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "refreshVulnerableApiService", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "changes", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "Lcom/goide/vgo/project/workspaceModel/entities/VgoDependencyEntity;", "copyModule", "module", "newDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "getAllModules", "supports", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/module/Module;", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "toPackageDeclaration", "Lcom/goide/vgo/mod/psi/VgoModuleSpec;", "libraryDependencies", "Lcom/intellij/packageChecker/model/LibraryDependency;", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nGoProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoProjectDependenciesModel.kt\ncom/intellij/packageChecker/go/GoProjectDependenciesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,142:1\n1611#2,9:143\n1863#2:152\n1864#2:154\n1620#2:155\n1611#2,9:156\n1863#2:165\n1864#2:167\n1620#2:168\n1368#2:169\n1454#2,5:170\n1368#2:176\n1454#2,5:177\n1557#2:182\n1628#2,3:183\n295#2,2:186\n1#3:153\n1#3:166\n1#3:175\n12574#4,2:188\n*S KotlinDebug\n*F\n+ 1 GoProjectDependenciesModel.kt\ncom/intellij/packageChecker/go/GoProjectDependenciesModel\n*L\n127#1:143,9\n127#1:152\n127#1:154\n127#1:155\n131#1:156,9\n131#1:165\n131#1:167\n131#1:168\n132#1:169\n132#1:170,5\n140#1:176\n140#1:177,5\n141#1:182\n141#1:183,3\n98#1:186,2\n127#1:153\n131#1:166\n117#1:188,2\n*E\n"})
public final class GoProjectDependenciesModel
extends ProjectDependenciesModelBase<MutableModuleModel>
implements Disposable {
    @NotNull
    private final Project project;

    public GoProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = GoProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GoProjectDependenciesModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = WorkspaceModel.Companion.getInstance(this.this$0.project).getEventLog().collect(new FlowCollector(){

                            public final Object emit(VersionedStorageChange event, Continuation<? super Unit> $completion) {
                                List changes = event.getChanges(VgoDependencyEntity.class);
                                if (!((Collection)changes).isEmpty()) {
                                    this$0.refresh(this$0.project);
                                    this$0.refreshVulnerableApiService(event, changes);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        this.init();
    }

    private final void refreshVulnerableApiService(VersionedStorageChange event, List<? extends EntityChange<VgoDependencyEntity>> changes) {
        Set moduleIds = new LinkedHashSet();
        for (EntityChange<VgoDependencyEntity> entityChange : changes) {
            VgoDependencyEntity vgoDependencyEntity;
            EntityChange<VgoDependencyEntity> entityChange2 = entityChange;
            if (entityChange2 instanceof EntityChange.Added) {
                vgoDependencyEntity = (VgoDependencyEntity)((EntityChange.Added)entityChange).getNewEntity();
            } else if (entityChange2 instanceof EntityChange.Removed) {
                vgoDependencyEntity = (VgoDependencyEntity)((EntityChange.Removed)entityChange).getOldEntity();
            } else if (entityChange2 instanceof EntityChange.Replaced) {
                vgoDependencyEntity = (VgoDependencyEntity)((EntityChange.Replaced)entityChange).getNewEntity();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            VgoDependencyEntity dependency = vgoDependencyEntity;
            VgoStandaloneModuleEntity vgoStandaloneModuleEntity = dependency.getModule();
            ModuleId standaloneModuleId = vgoStandaloneModuleEntity != null ? vgoStandaloneModuleEntity.getModuleId() : null;
            VgoWorkspaceEntity vgoWorkspaceEntity = dependency.getWorkspace();
            ModuleId workspaceModuleId = vgoWorkspaceEntity != null ? vgoWorkspaceEntity.getModuleId() : null;
            Collection collection = moduleIds;
            ModuleId moduleId = standaloneModuleId;
            if (moduleId == null && (moduleId = workspaceModuleId) == null) continue;
            collection.add(moduleId);
        }
        ImmutableEntityStorage snapshot = event.getStorageAfter();
        for (ModuleId moduleId : moduleIds) {
            ModuleEntity moduleEntity = (ModuleEntity)snapshot.resolve((SymbolicEntityId)moduleId);
            if (moduleEntity == null || (moduleEntity = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)((EntityStorage)snapshot))) == null) continue;
            ModuleEntity module = moduleEntity;
            BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((ModuleBridge)module, null){
                int label;
                final /* synthetic */ ModuleBridge $module;
                {
                    this.$module = $module;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ComponentManager $this$service$iv = (ComponentManager)this.$module;
                            boolean $i$f$service = false;
                            Class<VulnerableApiService> serviceClass$iv = VulnerableApiService.class;
                            Object object3 = $this$service$iv.getService(serviceClass$iv);
                            if (object3 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            this.label = 1;
                            Object object4 = ((VulnerableApiService)object3).refreshLibraries((Continuation<? super Unit>)((Continuation)this));
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    @NotNull
    protected MutableModuleModel copyModule(@NotNull MutableModuleModel module, @NotNull Iterable<Dependency> newDependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(newDependencies, (String)"newDependencies");
        return module.withDependencies(newDependencies);
    }

    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        Module[] modules = ModuleManager.Companion.getInstance(this.project).getModules();
        List result = new ArrayList();
        for (Module module : modules) {
            Collection vgoModules;
            ProgressManager.checkCanceled();
            if (!UtilsKt.isEnabled(module)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)VgoModulesRegistry.getInstance((Project)this.project).getModules(module), (String)"getModules(...)");
            List packageDeclarations = (List)ReadAction.compute(() -> GoProjectDependenciesModel.getAllModules$lambda$0(this, module));
            for (VgoModule vgoModule : vgoModules) {
                ProgressManager.checkCanceled();
                VirtualFile buildFile = vgoModule.getRoot().findChild("go.mod");
                Collection collection = vgoModule.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDependencies(...)");
                Sequence dependencies = SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), GoProjectDependenciesModel::getAllModules$lambda$1), arg_0 -> GoProjectDependenciesModel.getAllModules$lambda$4(this, module, buildFile, packageDeclarations, arg_0));
                String string = vgoModule.getImportPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getImportPath(...)");
                MutableModuleModel moduleModel = new MutableModuleModel(string, module, buildFile, SequencesKt.toSet((Sequence)dependencies), this.project);
                ((Collection)result).add(moduleModel);
            }
        }
        return result;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)() -> GoProjectDependenciesModel.supports$lambda$6(project)));
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return UtilsKt.isEnabled(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ArraysKt.contains((Object[])ModuleManager.Companion.getInstance(this.project).getModules(), (Object)module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Iterable $this$mapNotNull$iv = UtilsKt.getDependencies(psiFile);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PackageDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoModuleSpec it = (VgoModuleSpec)element$iv$iv;
            boolean bl2 = false;
            if (this.toPackageDeclaration(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Collection collection = VgoModulesRegistry.getInstance((Project)module.getProject()).getModules(module);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getModules(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoModule it = (VgoModule)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (UtilsKt.getModuleRoot(this.project, (VgoDependency)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiFile it = (PsiFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.declaredDependencies(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PackageDeclaration toPackageDeclaration(VgoModuleSpec $this$toPackageDeclaration) {
        PackageDeclaration packageDeclaration;
        Package package_ = UtilsKt.toPackage($this$toPackageDeclaration);
        if (package_ != null) {
            Package pkg = package_;
            boolean bl = false;
            packageDeclaration = new PackageDeclaration(pkg, (PsiElement)$this$toPackageDeclaration, null, 4, null);
        } else {
            packageDeclaration = null;
        }
        return packageDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryDependency> libraryDependencies(@NotNull Module module) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        VgoModule it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Collection collection = VgoModulesRegistry.getInstance((Project)this.project).getModules(module);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getModules(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (VgoModule)element$iv$iv;
            boolean bl = false;
            Collection collection2 = it.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDependencies(...)");
            list$iv$iv = collection2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (VgoDependency)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection3.add(new GoLibraryDependency((VgoDependency)it));
        }
        return (List)destination$iv$iv;
    }

    private static final List getAllModules$lambda$0(GoProjectDependenciesModel this$0, Module $module) {
        return this$0.declaredDependencies($module);
    }

    private static final Package getAllModules$lambda$1(VgoDependency it) {
        Intrinsics.checkNotNull((Object)it);
        return UtilsKt.toPackage(it);
    }

    private static final PsiElement getAllModules$lambda$4$lambda$3(List $packageDeclarations, Package $pkg, VirtualFile virtualFile, Module module, Package package_) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)package_, (String)"<unused var>");
            Intrinsics.checkNotNull((Object)$packageDeclarations);
            Iterable $this$firstOrNull$iv = $packageDeclarations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PackageDeclaration it = (PackageDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPkg(), (Object)$pkg)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PackageDeclaration packageDeclaration = v0;
        return packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
    }

    private static final Dependency getAllModules$lambda$4(GoProjectDependenciesModel this$0, Module $module, VirtualFile $buildFile, List $packageDeclarations, Package pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        return new Dependency(pkg, SetsKt.emptySet(), new DependencyContext(this$0.project, $module, $buildFile, null, (arg_0, arg_1, arg_2) -> GoProjectDependenciesModel.getAllModules$lambda$4$lambda$3($packageDeclarations, pkg, arg_0, arg_1, arg_2), 8, null));
    }

    private static final boolean supports$lambda$6(Project $project) {
        boolean bl;
        block1: {
            Module[] $this$any$iv = ModuleManager.Companion.getInstance($project).getModules();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Module element$iv;
                Module it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!GoSdkService.getInstance((Project)$project).isGoModule(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl && VgoProjectSettings.getInstance((Project)$project).isIntegrationEnabled();
    }
}

