/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target.wizard;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentWizardStepKt;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshConfigureCustomToolStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetAuthStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetConnectionStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetIntrospectable;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetIntrospectionStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetLanguageStep;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetStepBase;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetWizardModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001f\u0010\u001f\u001a\u00020\u00112\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\b\b\u0002\u0010 \u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020#H\u0014J\u0012\u0010$\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\b\u0010'\u001a\u00020\u0011H\u0016J\n\u0010(\u001a\u0004\u0018\u00010#H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectionStep;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetStepBase;", "model", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetWizardModel;", "helpId", "", "<init>", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetWizardModel;Ljava/lang/String;)V", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "introspectionFinishedSuccessfully", "", "getStepId", "", "getPreviousStepId", "getNextStepId", "_init", "", "introspect", "textProvider", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "languageRuntimeConfiguration", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "introspectable", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "Lorg/jetbrains/annotations/NotNull;", "getErrorMessage", "err", "", "finalizeIntrospection", "isAuthenticated", "isComplete", "createMainPanel", "Ljavax/swing/JComponent;", "doCommit", "commitType", "Lcom/intellij/ide/wizard/AbstractWizardStepEx$CommitType;", "dispose", "getPreferredFocusedComponent", "Companion", "intellij.remoteRun"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSshTargetIntrospectionStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshTargetIntrospectionStep.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectionStep\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,211:1\n14#2:212\n*S KotlinDebug\n*F\n+ 1 SshTargetIntrospectionStep.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectionStep\n*L\n209#1:212\n*E\n"})
public final class SshTargetIntrospectionStep
extends SshTargetStepBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ConsoleViewImpl console;
    private boolean introspectionFinishedSuccessfully;
    @NotNull
    private static final Object ID = Reflection.getOrCreateKotlinClass(SshTargetIntrospectionStep.class);
    @NotNull
    private static final Logger LOG;

    @JvmOverloads
    public SshTargetIntrospectionStep(@NotNull SshTargetWizardModel model, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        super(model, helpId);
    }

    public /* synthetic */ SshTargetIntrospectionStep(SshTargetWizardModel sshTargetWizardModel, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(sshTargetWizardModel, string);
    }

    @NotNull
    public Object getStepId() {
        return ID;
    }

    @NotNull
    public Object getPreviousStepId() {
        return this.getModel().authStepHappened() ? SshTargetAuthStep.Companion.getID() : SshTargetConnectionStep.Companion.getID();
    }

    @NotNull
    public Object getNextStepId() {
        return this.getModel().isCustomToolConfiguration() ? SshConfigureCustomToolStep.Companion.getID() : SshTargetLanguageStep.Companion.getID();
    }

    public void _init() {
        super._init();
        this.getModel().resetLanguageConfigForIntrospection$intellij_remoteRun();
        int stepNumber = this.getModel().authStepHappened() ? 4 : 3;
        String string = RemoteSdkBundle.message("sst.target.introspection.step.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setStepDescription(TargetEnvironmentWizardStepKt.Companion.formatStepLabel(stepNumber - 1, stepNumber, string));
        ConsoleViewImpl consoleViewImpl = this.console;
        if (consoleViewImpl != null) {
            consoleViewImpl.clear();
        }
        this.introspectionFinishedSuccessfully = false;
        EventDispatcher eventDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        EventDispatcher forceDisconnectDispatcher = eventDispatcher;
        Semaphore done = new Semaphore();
        done.down();
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState modalityState2 = modalityState;
        ApplicationManager.getApplication().executeOnPooledThread(() -> SshTargetIntrospectionStep._init$lambda$2(this, forceDisconnectDispatcher, modalityState2));
    }

    private final void introspect(SshTargetIntrospectable.TextProvider textProvider2, LanguageRuntimeConfiguration languageRuntimeConfiguration, SshTargetIntrospectable introspectable, ModalityState modalityState) {
        if (languageRuntimeConfiguration == null) {
            SshTargetIntrospectionStep.finalizeIntrospection$default(this, modalityState, false, 2, null);
            return;
        }
        LanguageRuntimeType.Introspector introspector = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)languageRuntimeConfiguration).createIntrospector(languageRuntimeConfiguration);
        if (introspector == null) {
            SshTargetIntrospectionStep.finalizeIntrospection$default(this, modalityState, false, 2, null);
            return;
        }
        Object[] objectArray = new Object[]{LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)languageRuntimeConfiguration).getDisplayName()};
        String string = RemoteSdkBundle.message("sst.target.introspection.step.message.starting.introspection.for.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        textProvider2.printlnSystemText(string);
        ((CompletableFuture)introspector.introspect((LanguageRuntimeType.Introspectable)introspectable).thenApply(arg_0 -> SshTargetIntrospectionStep.introspect$lambda$4(arg_0 -> SshTargetIntrospectionStep.introspect$lambda$3(this, arg_0), arg_0))).whenComplete((arg_0, arg_1) -> SshTargetIntrospectionStep.introspect$lambda$6((arg_0, arg_1) -> SshTargetIntrospectionStep.introspect$lambda$5(textProvider2, this, introspectable, modalityState, arg_0, arg_1), arg_0, arg_1));
    }

    private final String getErrorMessage(Throwable err) {
        if (err instanceof CompletionException) {
            Throwable throwable = err.getCause();
            return throwable != null ? throwable.getMessage() : null;
        }
        return err.getMessage();
    }

    private final void finalizeIntrospection(ModalityState modalityState, boolean isAuthenticated) {
        ApplicationManager.getApplication().invokeLater(() -> SshTargetIntrospectionStep.finalizeIntrospection$lambda$7(this, isAuthenticated), modalityState);
    }

    static /* synthetic */ void finalizeIntrospection$default(SshTargetIntrospectionStep sshTargetIntrospectionStep, ModalityState modalityState, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        sshTargetIntrospectionStep.finalizeIntrospection(modalityState, bl);
    }

    public boolean isComplete() {
        return this.introspectionFinishedSuccessfully;
    }

    @NotNull
    protected JComponent createMainPanel() {
        this.console = new ConsoleViewImpl(this.getModel().getProject(), true);
        JPanel panel2 = new JPanel(new BorderLayout());
        ConsoleViewImpl consoleViewImpl = this.console;
        Intrinsics.checkNotNull((Object)consoleViewImpl);
        panel2.add((Component)consoleViewImpl.getComponent(), "Center");
        return panel2;
    }

    protected void doCommit(@Nullable AbstractWizardStepEx.CommitType commitType) {
    }

    public void dispose() {
        ConsoleViewImpl createdConsole = this.console;
        this.console = null;
        if (createdConsole != null) {
            Disposer.dispose((Disposable)((Disposable)createdConsole));
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        ConsoleViewImpl consoleViewImpl = this.console;
        return consoleViewImpl != null ? consoleViewImpl.getComponent() : null;
    }

    @JvmOverloads
    public SshTargetIntrospectionStep(@NotNull SshTargetWizardModel model) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this(model, null, 2, null);
    }

    private static final Unit _init$lambda$2$lambda$0(SshTargetIntrospectionStep this$0, ProcessOutput it) {
        if (it.checkSuccess(LOG)) {
            this$0.getModel().getSubject().setProjectRootOnTarget(it.getStdout() + "/" + this$0.getModel().getProject().getName());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void _init$lambda$2(SshTargetIntrospectionStep this$0, EventDispatcher $forceDisconnectDispatcher, ModalityState $modalityState) {
        boolean bl;
        RemoteCredentials credentials = this$0.getModel().getConnectionData().getResultingCredentials();
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)credentials, (Project)this$0.getModel().getProject(), null, (boolean)false, null, (int)14, null).withDisconnectTrigger($forceDisconnectDispatcher).withConnectionTimeout(10L, TimeUnit.SECONDS);
        try {
            bl = ConnectionBuilder.checkCanAuthenticate$default((ConnectionBuilder)connectionBuilder, (boolean)false, (int)1, null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            bl = false;
        }
        boolean canAuthenticate = bl;
        var textProvider2 = new SshTargetIntrospectable.TextProvider(this$0){
            final /* synthetic */ SshTargetIntrospectionStep this$0;
            {
                this.this$0 = $receiver;
            }

            public void printlnText(@Nls String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
                this.println(text, consoleViewContentType);
            }

            public void printlnSystemText(@Nls String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"SYSTEM_OUTPUT");
                this.println(text, consoleViewContentType);
            }

            public void printlnError(@Nls String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
                this.println(text, consoleViewContentType);
            }

            private final void println(@Nls String text, ConsoleViewContentType type) {
                block1: {
                    ConsoleViewImpl consoleViewImpl = SshTargetIntrospectionStep.access$getConsole$p(this.this$0);
                    if (consoleViewImpl != null) {
                        consoleViewImpl.print(text, type);
                    }
                    ConsoleViewImpl consoleViewImpl2 = SshTargetIntrospectionStep.access$getConsole$p(this.this$0);
                    if (consoleViewImpl2 == null) break block1;
                    consoleViewImpl2.print("\n", type);
                }
            }
        };
        if (!canAuthenticate) {
            Object[] objectArray = new Object[]{this$0.getModel().getConnectionData().getResultingCredentialsLine()};
            String string = RemoteSdkBundle.message("sst.target.introspection.step.message.failed.to.connect.to.0", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            textProvider2.printlnError(string);
            this$0.finalizeIntrospection($modalityState, false);
            return;
        }
        Object[] objectArray = new Object[]{this$0.getModel().getConnectionData().getResultingCredentialsLine()};
        String string = RemoteSdkBundle.message("sst.target.introspection.step.message.successfully.connected.to.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        textProvider2.printlnText(string);
        textProvider2.printlnText("");
        SshTargetIntrospectable introspectable = new SshTargetIntrospectable(connectionBuilder, textProvider2);
        introspectable.promiseExecuteScript(CollectionsKt.listOf((Object)"pwd")).thenApply(arg_0 -> SshTargetIntrospectionStep._init$lambda$2$lambda$1(arg_0 -> SshTargetIntrospectionStep._init$lambda$2$lambda$0(this$0, arg_0), arg_0));
        String validationMessage = RsyncStatusService.validateRsyncCommand();
        if (validationMessage == null) {
            textProvider2.printlnText("\n");
            String string2 = RemoteSdkBundle.message("sst.target.introspection.step.message.checking.rsync.connection", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            textProvider2.printlnSystemText(string2);
            RSyncUtil.testConnection((RemoteCredentials)this$0.getModel().getConnectionData().getResultingCredentials(), (RSyncUtil.IndicatorWrapper)new RSyncUtil.IndicatorWrapper(textProvider2, this$0, introspectable, $modalityState){
                final /* synthetic */ _init.1.textProvider.1 $textProvider;
                final /* synthetic */ SshTargetIntrospectionStep this$0;
                final /* synthetic */ SshTargetIntrospectable $introspectable;
                final /* synthetic */ ModalityState $modalityState;
                {
                    this.$textProvider = $textProvider;
                    this.this$0 = $receiver;
                    this.$introspectable = $introspectable;
                    this.$modalityState = $modalityState;
                }

                public boolean isCanceled() {
                    return false;
                }

                public void checkCanceled() {
                }

                public void addText(String text, Key<?> key) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    this.$textProvider.printlnText(text);
                }

                public void finished(int exitCode) {
                    Object[] objectArray = new Object[]{exitCode};
                    String string = RemoteSdkBundle.message("message.process.finished.with.exit.code.0", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.$textProvider.printlnSystemText(string);
                    this.$textProvider.printlnText("\n");
                    this.this$0.getModel().setCanUseRsync$intellij_remoteRun(exitCode == 0);
                    this.this$0.getModel().getSubject().setUseRsync(exitCode == 0);
                    SshTargetIntrospectionStep.access$introspect(this.this$0, this.$textProvider, this.this$0.getModel().getLanguageConfigForIntrospection(), this.$introspectable, this.$modalityState);
                }
            });
            return;
        }
        textProvider2.printlnText(validationMessage);
        this$0.introspect(textProvider2, this$0.getModel().getLanguageConfigForIntrospection(), introspectable, $modalityState);
    }

    private static final LanguageRuntimeConfiguration introspect$lambda$3(SshTargetIntrospectionStep this$0, LanguageRuntimeConfiguration it) {
        return this$0.getModel().getLanguageConfigForIntrospection();
    }

    private static final LanguageRuntimeConfiguration introspect$lambda$4(Function1 $tmp0, Object p0) {
        return (LanguageRuntimeConfiguration)$tmp0.invoke(p0);
    }

    private static final Unit introspect$lambda$5(SshTargetIntrospectable.TextProvider $textProvider, SshTargetIntrospectionStep this$0, SshTargetIntrospectable $introspectable, ModalityState $modalityState, Object object, Throwable err) {
        if (err == null) {
            $textProvider.printlnText("");
            String string = RemoteSdkBundle.message("sst.target.introspection.step.message.introspection.completed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $textProvider.printlnText(string);
        } else {
            $textProvider.printlnError("");
            Object[] objectArray = new Object[1];
            String string = this$0.getErrorMessage(err);
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String string2 = RemoteSdkBundle.message("sst.target.introspection.step.message.introspection.completed.with.error.0", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $textProvider.printlnError(string2);
        }
        $introspectable.shutdown();
        SshTargetIntrospectionStep.finalizeIntrospection$default(this$0, $modalityState, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final void introspect$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void finalizeIntrospection$lambda$7(SshTargetIntrospectionStep this$0, boolean $isAuthenticated) {
        this$0.introspectionFinishedSuccessfully = $isAuthenticated;
        this$0.fireStateChanged();
    }

    @NotNull
    public static final Object getID() {
        return Companion.getID();
    }

    public static final /* synthetic */ ConsoleViewImpl access$getConsole$p(SshTargetIntrospectionStep $this) {
        return $this.console;
    }

    public static final /* synthetic */ void access$introspect(SshTargetIntrospectionStep $this, SshTargetIntrospectable.TextProvider textProvider2, LanguageRuntimeConfiguration languageRuntimeConfiguration, SshTargetIntrospectable introspectable, ModalityState modalityState) {
        $this.introspect(textProvider2, languageRuntimeConfiguration, introspectable, modalityState);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshTargetIntrospectionStep.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0003\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectionStep$Companion;", "", "<init>", "()V", "ID", "getID$annotations", "getID", "()Ljava/lang/Object;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getID() {
            return ID;
        }

        @JvmStatic
        public static /* synthetic */ void getID$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

