/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LESSMixinReference
extends PsiPolyVariantReferenceBase<LESSMixinInvocation> {
    public LESSMixinReference(LESSMixinInvocation element) {
        super((PsiElement)element);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)this.myElement);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)((LESSMixinInvocation)this.myElement).getContainingFile(), (PsiElement)this.myElement, (boolean)false);
        LinkedList result = new LinkedList();
        LinkedList resultResolvedByNameOnly = new LinkedList();
        String invocationNamespace = ((LESSMixinInvocation)this.myElement).getNamespace();
        LessMixinIndex.process(((LESSMixinInvocation)this.myElement).getFullName(), ((LESSMixinInvocation)this.myElement).getProject(), scope, (Processor<? super LESSMixin>)((Processor)mixin -> {
            if (LESSUtil.isMixinMatchesWithInvocation(mixin, this.myElement, invocationNamespace)) {
                boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                PsiElementResolveResult resolveResult = new PsiElementResolveResult(mixin.getTargetForReference(), validResult);
                if (validResult) {
                    result.add(resolveResult);
                } else {
                    resultResolvedByNameOnly.add(resolveResult);
                }
            }
            return true;
        }));
        result.addAll(resultResolvedByNameOnly);
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            LESSMixinReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            LESSMixinReference.$$$reportNull$$$0(1);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    protected TextRange calculateDefaultRangeInElement() {
        LESSMixinName fullNameIdentifier = ((LESSMixinInvocation)this.myElement).getFullNameIdentifier();
        return fullNameIdentifier != null && fullNameIdentifier.getText().length() > 0 ? TextRange.from((int)(fullNameIdentifier.getStartOffsetInParent() + 1), (int)(fullNameIdentifier.getTextLength() - 1)) : TextRange.EMPTY_RANGE;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            LESSMixinReference.$$$reportNull$$$0(2);
        }
        return ((LESSMixinInvocation)this.myElement).setName(newElementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/references/LESSMixinReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/references/LESSMixinReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

