/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.google.common.base.Joiner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSElementGenerator;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.references.LESSNamespaceReference;

public class LESSNamespace
extends LESSMixinName
implements PsiNameIdentifierOwner {
    private static final LESSNamespace[] EMPTY_ARRAY = new LESSNamespace[0];
    public static final ArrayFactory<LESSNamespace> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new LESSNamespace[count];
    public static final Joiner NAMESPACE_JOINER = Joiner.on((char)'>');

    protected LESSNamespace() {
        super(LESSElementTypes.LESS_NAMESPACE);
    }

    @NotNull
    public String getNamespace() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (LESSNamespace parentNamespace = this.getParentNamespace(); parentNamespace != null; parentNamespace = parentNamespace.getParentNamespace()) {
            namespaces.add(parentNamespace.getFullName());
        }
        String string = NAMESPACE_JOINER.join((Iterable)ContainerUtil.reverse(namespaces));
        if (string == null) {
            LESSNamespace.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        LESSNamespace newElement;
        if (name == null) {
            LESSNamespace.$$$reportNull$$$0(1);
        }
        if ((newElement = LESSElementGenerator.createNamespace(this.getProject(), this.createNewName(name))) != null) {
            return this.replace((PsiElement)newElement);
        }
        return this;
    }

    public PsiReference getReference() {
        return new LESSNamespaceReference(this);
    }

    @Nullable
    private LESSNamespace getParentNamespace() {
        return (LESSNamespace)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this, LESSNamespace.class);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNamedElement();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LESSNamespace.$$$reportNull$$$0(2);
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitLESSNamespace(this);
            return;
        }
        super.accept(visitor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/psi/impl/LESSNamespace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/psi/impl/LESSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

