/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.lexer.LESSLexer;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;

public class LESSHighlightingLexer
extends CssHighlighterLexer {
    private static final int IN_DECLARATION_FLAG = 16;
    private static final int AFTER_AMPERSAND_FLAG = 32;
    private boolean inVariableDeclaration;
    private boolean afterAmpersand;

    public LESSHighlightingLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            LESSHighlightingLexer.$$$reportNull$$$0(0);
        }
        super((Lexer)new LESSLexer(), propertyValues);
        this.inVariableDeclaration = false;
        this.afterAmpersand = false;
    }

    public void advance() {
        IElementType type = this.getTokenType();
        this.afterAmpersand = LESSTokenTypes.AMPERSAND == type;
        super.advance();
    }

    protected void initState(int initialState) {
        super.initState(initialState);
        int state = initialState >> 24;
        this.inVariableDeclaration = (state & 0x10) != 0;
        this.afterAmpersand = (state & 0x20) != 0;
    }

    protected boolean isAndOrIdentifier(IElementType type, String tokenText) {
        return type == LESSTokenTypes.AND_KEYWORD || type == LESSTokenTypes.OR_KEYWORD;
    }

    public int getState() {
        int state = 0;
        state |= this.inVariableDeclaration ? 16 : 0;
        return super.getState() | (state |= this.afterAmpersand ? 32 : 0) << 24;
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (this.getDelegate().getTokenType() == LESSTokenTypes.INTERPOLATION_PREFIX) {
            return LESSTokenTypes.INTERPOLATION_PREFIX;
        }
        if (tokenType == LESSTokenTypes.VARIABLE) {
            this.myInPropertyValue = true;
            this.inVariableDeclaration = true;
        } else if (tokenType == CssElementTypes.CSS_SEMICOLON) {
            this.inVariableDeclaration = false;
        } else {
            if ((tokenType == CssElementTypes.CSS_IDENT || tokenType == CssElementTypes.CSS_HASH) && this.lookAhead(1) == CssElementTypes.CSS_LPAREN) {
                return CssElementTypes.CSS_FUNCTION_TOKEN;
            }
            if (tokenType == LESSTokenTypes.PLUGIN_SYM) {
                return CssElementTypes.CSS_KEYWORD;
            }
        }
        return tokenType;
    }

    public boolean isPropertyNameAllowed() {
        boolean detachedRuleset = (this.myAfterLeftBrace || this.myAfterSemicolon) && this.myFunctionNestingDepth > 0;
        return !this.afterAmpersand && (super.isPropertyNameAllowed() || detachedRuleset) && this.lookAhead(1) == CssElementTypes.CSS_COLON;
    }

    public boolean isPropertyValueAllowed() {
        return !(!this.myInPropertyValue && this.myFunctionNestingDepth <= 0 || !this.myInsideBlock && !this.inVariableDeclaration && !this.myAfterMediaOrSupports || this.myAfterLeftBrace || this.myAfterSemicolon);
    }

    public boolean isSelectorAllowed() {
        return !this.myInPropertyValue && this.myFunctionNestingDepth <= 0 && !this.myAfterMediaOrSupports && !this.isTerminatedDeclaration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValues", "org/jetbrains/plugins/less/lexer/LESSHighlightingLexer", "<init>"));
    }
}

