/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.statistics.FusAwareActionGroup;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\nB\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/flamegraph/CaptureImageActionGroup;", "T", "", "Lcom/intellij/profiler/statistics/FusAwareActionGroup;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "<init>", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;)V", "createImage", "Ljava/awt/image/BufferedImage;", "ImageTransferable", "intellij.profiler.common"})
public class CaptureImageActionGroup<T>
extends FusAwareActionGroup {
    @NotNull
    private final FlameGraphPanel<T> flameGraphPanel;

    public CaptureImageActionGroup(@NotNull FlameGraphPanel<T> flameGraphPanel2) {
        Intrinsics.checkNotNullParameter(flameGraphPanel2, (String)"flameGraphPanel");
        super(ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.FG_CAPTURE_IMAGE, null, 2, null);
        this.flameGraphPanel = flameGraphPanel2;
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Dump);
        this.getTemplatePresentation().setText(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture", new Object[0]));
        this.setPopup(true);
        String string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.toClipboard", new Object[0]);
        this.add((AnAction)new DumbAwareAction(string){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.FG_COPY_IMAGE, e, null, 4, null);
                CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(this.createImage()));
            }
        });
        string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.save", new Object[0]);
        this.add((AnAction)new DumbAwareAction(string){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.FG_SAVE_IMAGE, e, null, 4, null);
                String[] stringArray = new String[]{"png"};
                FileSaverDescriptor descriptor = new FileSaverDescriptor(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.saveImage", new Object[0]), CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.saveImage", new Object[0]), stringArray);
                FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, e.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
                FileSaverDialog dialog = fileSaverDialog;
                VirtualFileWrapper file = dialog.save("flamegraph.png");
                if (file != null) {
                    ImageIO.write((RenderedImage)this.createImage(), "png", file.getFile());
                }
            }
        });
    }

    @NotNull
    public final BufferedImage createImage() {
        Rectangle bounds = this.flameGraphPanel.getVisibleRect();
        BufferedImage bufferedImage = UIUtil.createImage((Component)((Component)((Object)this.flameGraphPanel)), (int)bounds.width, (int)bounds.height, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        Graphics2D graphics = image.createGraphics();
        graphics.translate(-bounds.x, -bounds.y);
        this.flameGraphPanel.paint(graphics);
        return image;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/flamegraph/CaptureImageActionGroup$ImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "", "intellij.profiler.common"})
    private static final class ImageTransferable
    implements Transferable {
        @NotNull
        private final BufferedImage image;

        public ImageTransferable(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@Nullable DataFlavor flavor) {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

