/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageWriter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.jetbrains.relocated.apache.batik.svggen.DefaultCachedImageHandler;
import org.jetbrains.relocated.apache.batik.svggen.ImageCacher;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.util.Base64EncoderStream;
import org.w3c.dom.Element;

public class CachedImageHandlerBase64Encoder
extends DefaultCachedImageHandler {
    public CachedImageHandlerBase64Encoder() {
        this.setImageCacher(new ImageCacher.Embedded());
    }

    @Override
    public Element createElement(SVGGeneratorContext generatorContext) {
        Element imageElement = generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "use");
        return imageElement;
    }

    @Override
    public String getRefPrefix() {
        return "";
    }

    @Override
    protected AffineTransform handleTransform(Element imageElement, double x2, double y2, double srcWidth, double srcHeight, double dstWidth, double dstHeight, SVGGeneratorContext generatorContext) {
        AffineTransform af = new AffineTransform();
        double hRatio = dstWidth / srcWidth;
        double vRatio = dstHeight / srcHeight;
        af.translate(x2, y2);
        if (hRatio != 1.0 || vRatio != 1.0) {
            af.scale(hRatio, vRatio);
        }
        if (!af.isIdentity()) {
            return af;
        }
        return null;
    }

    @Override
    public void encodeImage(BufferedImage buf, OutputStream os) throws IOException {
        Base64EncoderStream b64Encoder = new Base64EncoderStream(os);
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        writer.writeImage(buf, b64Encoder);
        b64Encoder.close();
    }

    @Override
    public int getBufferedImageType() {
        return 2;
    }
}

