/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.style;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.FontFace;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "", "textStyles", "", "", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "defaultFamily", "(Ljava/util/Map;Ljava/lang/String;)V", "getClasses", "", "getTextStyle", "className", "toCSS", "id", "Companion", "datamodel"})
@SourceDebugExtension(value={"SMAP\nStyleSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleSheet.kt\norg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1855#3,2:106\n*S KotlinDebug\n*F\n+ 1 StyleSheet.kt\norg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet\n*L\n41#1:106,2\n*E\n"})
public final class StyleSheet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, TextStyle> textStyles;
    @NotNull
    private final String defaultFamily;
    @NotNull
    private static final FontFace UNDEFINED_FONT_FACE = FontFace.Companion.getBOLD_ITALIC();
    @NotNull
    private static final Color UNDEFINED_FONT_COLOR = new Color(150, 0, 255, 0, 8, null);
    private static final double DEFAULT_FONT_SIZE = 15.0;
    @NotNull
    private static final String CSS_REGEX = "\\.([\\w\\-]+)\\s+\\{([^\\{\\}]*)\\}";

    public StyleSheet(@NotNull Map<String, TextStyle> textStyles, @NotNull String defaultFamily) {
        Intrinsics.checkNotNullParameter(textStyles, (String)"textStyles");
        Intrinsics.checkNotNullParameter((Object)defaultFamily, (String)"defaultFamily");
        this.textStyles = textStyles;
        this.defaultFamily = defaultFamily;
    }

    @NotNull
    public final List<String> getClasses() {
        return CollectionsKt.toList((Iterable)this.textStyles.keySet());
    }

    @NotNull
    public final TextStyle getTextStyle(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        TextStyle textStyle = this.textStyles.get(className);
        if (textStyle == null) {
            textStyle = new TextStyle(this.defaultFamily, UNDEFINED_FONT_FACE, 15.0, UNDEFINED_FONT_COLOR);
        }
        return textStyle;
    }

    @NotNull
    public final String toCSS(@NotNull String className, @Nullable String id) {
        String string;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder css;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                stringBuilder2 = css = new StringBuilder();
                stringBuilder = new StringBuilder().append("\n            |");
                string = id;
                if (string == null) break block2;
                String string2 = string;
                StringBuilder stringBuilder3 = stringBuilder;
                StringBuilder stringBuilder4 = stringBuilder2;
                boolean bl = false;
                String string3 = '#' + id + ' ';
                stringBuilder2 = stringBuilder4;
                stringBuilder = stringBuilder3;
                String string4 = string3;
                string = string4;
                if (string4 != null) break block3;
            }
            string = "";
        }
        stringBuilder2.append(StringsKt.trimMargin$default((String)stringBuilder.append(string).append('.').append(className).append(" {\n            |").append(StyleSheet.Companion.toCSS(this.getTextStyle(className))).append("\n            |}\n            |").toString(), null, (int)1, null));
        String string5 = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return string5;
    }

    @NotNull
    public final String toCSS() {
        StringBuilder css = new StringBuilder();
        Iterable $this$forEach$iv = this.getClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String className = (String)element$iv;
            boolean bl = false;
            css.append(this.toCSS(className, null));
        }
        String string = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0007J\n\u0010\u0015\u001a\u00020\u0004*\u00020\rJ\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet$Companion;", "", "()V", "CSS_REGEX", "", "getCSS_REGEX$annotations", "DEFAULT_FONT_SIZE", "", "UNDEFINED_FONT_COLOR", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getUNDEFINED_FONT_COLOR", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "UNDEFINED_FONT_FACE", "Lorg/jetbrains/letsPlot/commons/values/FontFace;", "getUNDEFINED_FONT_FACE", "()Lorg/jetbrains/letsPlot/commons/values/FontFace;", "fromCSS", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "css", "defaultFamily", "defaultSize", "toCSS", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "datamodel"})
    @SourceDebugExtension(value={"SMAP\nStyleSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleSheet.kt\norg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1313#2:105\n1314#2:107\n1#3:106\n*S KotlinDebug\n*F\n+ 1 StyleSheet.kt\norg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet$Companion\n*L\n82#1:105\n82#1:107\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontFace getUNDEFINED_FONT_FACE() {
            return UNDEFINED_FONT_FACE;
        }

        @NotNull
        public final Color getUNDEFINED_FONT_COLOR() {
            return UNDEFINED_FONT_COLOR;
        }

        @NotNull
        public final String toCSS(@NotNull FontFace $this$toCSS) {
            Intrinsics.checkNotNullParameter((Object)$this$toCSS, (String)"<this>");
            return "font-weight: " + ($this$toCSS.getBold() ? "bold" : "normal") + ";\n   font-style: " + ($this$toCSS.getItalic() ? "italic" : "normal") + ';';
        }

        private final String toCSS(TextStyle $this$toCSS) {
            return StringsKt.trimMargin$default((String)("\n                |   fill: " + $this$toCSS.getColor().toHexColor() + ";\n                |   font-family: " + $this$toCSS.getFamily() + ";\n                |   font-size: " + $this$toCSS.getSize() + "px;\n                |   " + this.toCSS($this$toCSS.getFace()) + "   \n                "), null, (int)1, null);
        }

        private static /* synthetic */ void getCSS_REGEX$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StyleSheet fromCSS(@NotNull String css, @NotNull String defaultFamily, double defaultSize) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)css, (String)"css");
            Intrinsics.checkNotNullParameter((Object)defaultFamily, (String)"defaultFamily");
            Map classes = new LinkedHashMap();
            Sequence sequence = Regex.findAll$default((Regex)new Regex(StyleSheet.CSS_REGEX), (CharSequence)css, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                double d;
                FontFace fontFace;
                String string;
                Map map2;
                String className;
                block6: {
                    block5: {
                        void p0;
                        MatchResult matched = (MatchResult)element$iv;
                        boolean bl = false;
                        MatchResult.Destructured destructured = matched.getDestructured();
                        className = (String)destructured.getMatch().getGroupValues().get(1);
                        String styleProperties = (String)destructured.getMatch().getGroupValues().get(2);
                        String string2 = org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-family");
                        if (string2 == null) {
                            string2 = defaultFamily;
                        }
                        String fontFamily = string2;
                        String fontWeight = org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-weight");
                        String fontStyle = org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-style");
                        Object object2 = org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-size");
                        double fontSize = object2 != null && (object2 = StringsKt.removeSuffix((String)object2, (CharSequence)"px")) != null && (object2 = StringsKt.toDoubleOrNull((String)object2)) != null ? (Double)object2 : defaultSize;
                        String color = org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "fill");
                        map2 = classes;
                        string = fontFamily;
                        fontFace = new FontFace(Intrinsics.areEqual((Object)fontWeight, (Object)"bold"), Intrinsics.areEqual((Object)fontStyle, (Object)"italic"));
                        d = fontSize;
                        object = color;
                        if (object == null) break block5;
                        String string3 = object;
                        Color.Companion companion = Color.Companion;
                        String string4 = string3;
                        double d2 = d;
                        FontFace fontFace2 = fontFace;
                        String string5 = string;
                        boolean bl2 = false;
                        Color color2 = companion.parseHex((String)p0);
                        string = string5;
                        fontFace = fontFace2;
                        d = d2;
                        Color color3 = color2;
                        object = color3;
                        if (color3 != null) break block6;
                    }
                    object = Color.Companion.getBLACK();
                }
                Object object3 = object;
                double d3 = d;
                FontFace fontFace3 = fontFace;
                String string6 = string;
                TextStyle textStyle = new TextStyle(string6, fontFace3, d3, (Color)object3);
                map2.put(className, textStyle);
            }
            return new StyleSheet(classes, defaultFamily);
        }

        private static final String fromCSS$parseProperty(String styleProperties, String propertyName) {
            Regex regex = new Regex(propertyName + ":(.+);");
            Object object = Regex.find$default((Regex)regex, (CharSequence)styleProperties, (int)0, (int)2, null);
            return object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

