/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.annotator;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.PyElementListCellRenderer;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    @Nls
    private static String getReferenceViewName(PsiElement usage) {
        PyFunction func;
        PsiFile file = usage.getContainingFile();
        Object name = file.getName();
        if (file.getParent() != null) {
            name = file.getParent().getName() + File.separator + (String)name;
        }
        if ((func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)usage, PyFunction.class)) != null) {
            name = DjangoBundle.message("django.view.line.marker.provider.view.name.in", func.getName(), name);
        }
        return name;
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        RelatedItemLineMarkerInfo<PsiFile> lineMarker;
        if (element == null) {
            ViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiFile && (lineMarker = ViewLineMarkerProvider.getViewLineMarker((PsiFile)element)) != null && !result2.contains(lineMarker)) {
            result2.add(lineMarker);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiFile> getViewLineMarker(PsiFile file) {
        TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)file.getProject(), (PsiFile)file);
        Set<NavigatablePsiElement> references = DjangoTemplateManager.getTemplateReferences(file, null, context);
        if (!references.isEmpty()) {
            return new DjangoRelatedItemLineMarkerInfo(file, file.getTextRange(), PythonFileType.INSTANCE.getIcon(), new ViewTooltipProvider(references), (GutterIconNavigationHandler<PsiFile>)new DefaultGutterIconNavigationHandler<PsiFile>(references, DjangoBundle.message("django.view.line.marker.provider.popup.title.select.view", new Object[0])){

                protected PyElementListCellRenderer createListCellRenderer() {
                    return new PyElementListCellRenderer(){

                        public String getElementText(PsiElement element) {
                            String name = ViewLineMarkerProvider.getReferenceViewName(element);
                            return name != null ? name : super.getElementText(element);
                        }
                    };
                }
            }, GutterIconRenderer.Alignment.RIGHT, GotoRelatedItem.createItems(references));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/annotator/ViewLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DjangoRelatedItemLineMarkerInfo
    extends RelatedItemLineMarkerInfo<PsiFile> {
        private final PsiFile myFile;
        private final TextRange myRange;

        private DjangoRelatedItemLineMarkerInfo(@NotNull PsiFile element, @NotNull TextRange range, Icon icon, @Nullable Function<? super PsiFile, String> tooltipProvider, @Nullable GutterIconNavigationHandler<PsiFile> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull Collection<? extends GotoRelatedItem> targets) {
            if (element == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (range == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (alignment == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if (targets == null) {
                DjangoRelatedItemLineMarkerInfo.$$$reportNull$$$0(3);
            }
            super((PsiElement)element, range, icon, tooltipProvider, navHandler, alignment, () -> targets);
            this.myFile = element;
            this.myRange = range;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DjangoRelatedItemLineMarkerInfo that = (DjangoRelatedItemLineMarkerInfo)((Object)o);
            assert (this.myFile != null);
            assert (that.myFile != null);
            if (this.myFile.getVirtualFile() != null && that.myFile.getVirtualFile() != null && !this.myFile.getVirtualFile().equals(that.myFile.getVirtualFile())) {
                return false;
            }
            return this.myRange.equals((Object)that.myRange);
        }

        public int hashCode() {
            int result2 = this.myFile.hashCode();
            result2 = 31 * result2 + this.myRange.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "alignment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targets";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/django/annotator/ViewLineMarkerProvider$DjangoRelatedItemLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ViewTooltipProvider
    implements Function<PsiFile, String> {
        private final Set<NavigatablePsiElement> myUsages;

        ViewTooltipProvider(Set<NavigatablePsiElement> usages) {
            this.myUsages = usages;
        }

        @Nls
        public String fun(PsiFile psiFile) {
            if (this.myUsages.size() == 1) {
                return DjangoBundle.message("django.view.line.marker.provider.referenced.from.param", ViewLineMarkerProvider.getReferenceViewName((PsiElement)this.myUsages.iterator().next()));
            }
            HtmlBuilder builder = new HtmlBuilder();
            builder.append(DjangoBundle.message("django.view.line.marker.provider.referenced.from", new Object[0]));
            for (PsiElement psiElement : this.myUsages) {
                builder.br().append(ViewLineMarkerProvider.getReferenceViewName(psiElement));
            }
            return builder.toString();
        }
    }
}

