/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.scientific.py.tables.panel.datawrangler.CellContent;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreePart;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreeRootNode;
import com.intellij.scientific.tables.api.ColumnDescriptionStatistics;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DescriptionStatisticsValue;
import com.intellij.scientific.tables.api.TableStatisticsData;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b*\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u000bH\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/MissingValuesSummaryTreePart;", "Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreePart;", "summaryName", "", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "<init>", "(Ljava/lang/String;Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)V", "getSummaryName", "()Ljava/lang/String;", "summaryData", "", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "getSummaryData", "()Ljava/util/Map;", "summaryRoot", "Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeRootNode;", "getSummaryRoot", "()Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeRootNode;", "computeSummaryData", "mapSummary", "Lcom/intellij/scientific/tables/api/ColumnDescriptionStatistics;", "getValueAt", "Lcom/intellij/scientific/py/tables/panel/datawrangler/CellContent;", "node", "", "column", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nSummaryTreeTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryTreeTable.kt\ncom/intellij/scientific/py/tables/panel/datawrangler/MissingValuesSummaryTreePart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1557#2:321\n1628#2,3:322\n1246#2,2:327\n1249#2:330\n462#3:325\n412#3:326\n503#3,7:331\n1#4:329\n*S KotlinDebug\n*F\n+ 1 SummaryTreeTable.kt\ncom/intellij/scientific/py/tables/panel/datawrangler/MissingValuesSummaryTreePart\n*L\n126#1:321\n126#1:322,3\n132#1:327,2\n132#1:330\n132#1:325\n132#1:326\n135#1:331,7\n*E\n"})
public final class MissingValuesSummaryTreePart
extends SummaryTreePart {
    @NotNull
    private final String summaryName;
    @NotNull
    private final Map<DefaultMutableTreeNode, Integer> summaryData;
    @NotNull
    private final SummaryTreeRootNode summaryRoot;

    public MissingValuesSummaryTreePart(@Nls @NotNull String summaryName, @NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        super(table);
        this.summaryName = summaryName;
        this.summaryData = this.computeSummaryData();
        this.summaryRoot = new SummaryTreeRootNode(this.getSummaryName(), this);
        this.addColumnsSummaryToRoot();
    }

    @Override
    @NotNull
    public String getSummaryName() {
        return this.summaryName;
    }

    @NotNull
    protected Map<DefaultMutableTreeNode, Integer> getSummaryData() {
        return this.summaryData;
    }

    @Override
    @NotNull
    protected SummaryTreeRootNode getSummaryRoot() {
        return this.summaryRoot;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<DefaultMutableTreeNode, Integer> computeSummaryData() {
        Map<DefaultMutableTreeNode, Integer> map2;
        DSDataFrameInfo dSDataFrameInfo;
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = this.getTable().getTableDataRetrieverFromDataSource();
        if (dSTableDataRetrieverFromDataSource != null && (dSDataFrameInfo = dSTableDataRetrieverFromDataSource.getDataFrameInfo()) != null) {
            Map<DefaultMutableTreeNode, Integer> map3;
            void $this$mapTo$iv$iv;
            DSDataFrameInfo info = dSDataFrameInfo;
            boolean bl = false;
            TableStatisticsData tableStatisticsData = info.getDataStatistics();
            Object object = tableStatisticsData;
            if (tableStatisticsData == null) return MapsKt.emptyMap();
            if ((object = object.getTableStatisticsData()) == null) {
                return MapsKt.emptyMap();
            }
            Object object2 = object;
            Iterable $this$map$iv = info.getColumnNames();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void columnName;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new DefaultMutableTreeNode(columnName));
            }
            Map map4 = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)((Iterable)object2)));
            if (map4 != null && (map3 = this.mapSummary(map4)) != null) {
                map2 = map3;
                return map2;
            }
        }
        map2 = MapsKt.emptyMap();
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DefaultMutableTreeNode, Integer> mapSummary(Map<DefaultMutableTreeNode, ColumnDescriptionStatistics> $this$mapSummary) {
        void $this$mapValuesTo$iv$iv;
        Map<DefaultMutableTreeNode, ColumnDescriptionStatistics> $this$mapValues$iv = $this$mapSummary;
        boolean $i$f$mapValues = false;
        Map<DefaultMutableTreeNode, ColumnDescriptionStatistics> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object object;
            Object v0;
            Map map3;
            Object k;
            block3: {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map3 = map4;
                boolean bl2 = false;
                ColumnDescriptionStatistics statistics = (ColumnDescriptionStatistics)entry2.getValue();
                Iterable iterable = statistics.getColumnStatistics();
                for (Object t : iterable) {
                    DescriptionStatisticsValue it = (DescriptionStatisticsValue)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getStatisticsName(), (Object)"Missing")) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            Integer n = (object = (DescriptionStatisticsValue)v0) != null && (object = object.getStatisticsValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            map3.put(k, n);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int missingStatistics = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(missingStatistics != 0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    public CellContent getValueAt(@Nullable Object node, int column) {
        CellContent cellContent;
        Object object = node;
        if (Intrinsics.areEqual((Object)object, (Object)this.getSummaryRoot())) {
            cellContent = new CellContent(String.valueOf(CollectionsKt.sumOfInt((Iterable)this.getSummaryData().values())), false);
        } else if (object instanceof DefaultMutableTreeNode) {
            Integer n = this.getSummaryData().get(node);
            if (n == null) {
                return new CellContent(null, false, 3, null);
            }
            int missing = n;
            DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = this.getTable().getTableDataRetrieverFromDataSource();
            if (dSTableDataRetrieverFromDataSource == null || (dSTableDataRetrieverFromDataSource = dSTableDataRetrieverFromDataSource.getDataFrameInfo()) == null) {
                return new CellContent(null, false, 3, null);
            }
            int rows = dSTableDataRetrieverFromDataSource.getRows();
            String string = "%.2f";
            Object[] objectArray = new Object[]{(double)missing * 100.0 / (double)rows};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd((String)string2, (char[])cArray);
            cArray = new char[]{'.'};
            CellContent cellContent2 = new CellContent(missing + ", " + StringsKt.trimEnd((String)string3, (char[])cArray) + "%", true);
            cellContent = cellContent2;
        } else {
            return new CellContent(null, false, 3, null);
        }
        return cellContent;
    }
}

