/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.uml;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.python.uml.ERDiagramNode;
import com.intellij.python.uml.ERUmlRelationships;
import com.intellij.python.uml.python.PyUmlEdge;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.python.psi.PyClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class ERDiagramModel
extends DiagramDataModel<PyClass> {
    protected final Set<DiagramNode<PyClass>> myNodes = ConcurrentCollectionFactory.createConcurrentSet();
    protected final Collection<DiagramEdge<PyClass>> myEdges = ConcurrentCollectionFactory.createConcurrentSet();
    public static final Map<PyClass, Map.Entry<String, String>> ourAdditionalFields = new HashMap<PyClass, Map.Entry<String, String>>();
    protected final Set<PyClass> myClasses = ConcurrentCollectionFactory.createConcurrentSet();
    private final PyClass myInitialElement;
    private final Project myProject;

    protected ERDiagramModel(Project project, PyClass element, DiagramProvider<PyClass> provider) {
        super(project, provider);
        this.myInitialElement = element;
        this.myProject = project;
    }

    protected abstract void init(Project var1, PyClass var2);

    @NotNull
    public Collection<DiagramNode<PyClass>> getNodes() {
        Set<DiagramNode<PyClass>> set2 = this.myNodes;
        if (set2 == null) {
            ERDiagramModel.$$$reportNull$$$0(0);
        }
        return set2;
    }

    @NotNull
    public Collection<DiagramEdge<PyClass>> getEdges() {
        Collection<DiagramEdge<PyClass>> collection = this.myEdges;
        if (collection == null) {
            ERDiagramModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<PyClass> node) {
        String name;
        if (node == null) {
            ERDiagramModel.$$$reportNull$$$0(2);
        }
        String string = (name = ((PyClass)node.getIdentifyingElement()).getName()) == null ? "" : name;
        if (string == null) {
            ERDiagramModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<PyClass> addElement(@Nullable PyClass element) {
        if (element == null || this.isAlreadyDrawn(element)) {
            return null;
        }
        return new ERDiagramNode(element, (DiagramProvider<PyClass>)this.getProvider());
    }

    protected boolean isAlreadyDrawn(PyClass element) {
        if (element != null) {
            String elementFQN = element.getQualifiedName();
            for (DiagramNode<PyClass> node : this.myNodes) {
                PyClass container = (PyClass)node.getIdentifyingElement();
                String nodeFQN = container.getName();
                if (elementFQN == null || nodeFQN == null || !elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeNode(@NotNull DiagramNode<PyClass> node) {
        if (node == null) {
            ERDiagramModel.$$$reportNull$$$0(4);
        }
        this.removeElement((PyClass)node.getIdentifyingElement());
    }

    private void removeElement(PyClass element) {
        DiagramNode<PyClass> node = this.findNode(element);
        if (node != null) {
            ArrayList<DiagramEdge<PyClass>> edges = new ArrayList<DiagramEdge<PyClass>>();
            for (DiagramEdge<PyClass> edge : this.myEdges) {
                if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
        }
        this.myNodes.remove(node);
    }

    @Nullable
    protected DiagramNode<PyClass> findNode(PyClass element) {
        if (element == null) {
            return null;
        }
        String elementFQN = element.getQualifiedName();
        for (DiagramNode<PyClass> node : this.myNodes) {
            String fqn = ((PyClass)node.getIdentifyingElement()).getQualifiedName();
            if (elementFQN == null || !elementFQN.equals(fqn)) continue;
            return node;
        }
        return null;
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ERDiagramModel.$$$reportNull$$$0(5);
        }
        return this.refreshDataModel(indicator);
    }

    @NotNull
    private CompletableFuture<Void> refreshDataModel(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ERDiagramModel.$$$reportNull$$$0(6);
        }
        CancellablePromise promise = ReadAction.nonBlocking(() -> {
            this.myNodes.clear();
            this.myClasses.clear();
            this.myEdges.clear();
            if (this.myInitialElement != null && this.myInitialElement.isValid()) {
                this.init(this.myProject, this.myInitialElement);
            }
            this.calculateRelations();
        }).expireWith((Disposable)this).inSmartMode(this.getProject()).wrapProgress(indicator).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)promise);
        if (completableFuture == null) {
            ERDiagramModel.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    protected abstract void calculateRelations();

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            ERDiagramModel.$$$reportNull$$$0(8);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    protected void addEdges(@NotNull DiagramNode<PyClass> fromNode, @NotNull Map<PyClass, String> res, @NotNull String relation, DiagramProvider<PyClass> provider) {
        if (fromNode == null) {
            ERDiagramModel.$$$reportNull$$$0(9);
        }
        if (res == null) {
            ERDiagramModel.$$$reportNull$$$0(10);
        }
        if (relation == null) {
            ERDiagramModel.$$$reportNull$$$0(11);
        }
        for (Map.Entry<PyClass, String> pyClass : res.entrySet()) {
            this.addEdge(fromNode, relation, provider, pyClass);
        }
    }

    protected void addEdge(DiagramNode<PyClass> fromNode, String relation, DiagramProvider<PyClass> provider, Map.Entry<PyClass, String> pyClass) {
        Object toNode = this.findNode(pyClass.getKey());
        if (toNode == null) {
            toNode = new ERDiagramNode(pyClass.getKey(), provider);
            this.myNodes.add((DiagramNode<PyClass>)toNode);
        }
        String label2 = pyClass.getValue();
        PyUmlEdge edge = new PyUmlEdge(fromNode, (DiagramNode<PyClass>)toNode, (DiagramRelationshipInfo)new ERUmlRelationships(relation, label2));
        this.myEdges.add((DiagramEdge<PyClass>)edge);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/uml/ERDiagramModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/uml/ERDiagramModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModelAsync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    protected static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public MyEntry(K key, V value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value2) {
            V old = this.value;
            this.value = value2;
            return old;
        }
    }
}

