/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.scientific.PySciProjectComponent;
import com.intellij.python.scientific.figures.PlotsBackend;
import com.intellij.python.scientific.ui.PyPlotToolWindow;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonRunConfigurationExtension;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public final class PySciEnvironmentProvider
extends PythonRunConfigurationExtension
implements PythonCommandLineEnvironmentProvider {
    private static final Logger LOG = Logger.getInstance(PySciEnvironmentProvider.class);

    public boolean isApplicableFor(@NotNull AbstractPythonRunConfiguration configuration) {
        Project project;
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(0);
        }
        return !(project = configuration.getProject()).isDefault() && !PySciProjectComponent.getInstance(project).isPortForwarded();
    }

    public boolean isEnabledFor(@NotNull AbstractPythonRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(1);
        }
        return PySciProjectComponent.getInstance(applicableConfiguration.getProject()).isMatplotlibInToolwindow();
    }

    protected void patchCommandLine(@NotNull AbstractPythonRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(2);
        }
        if (cmdLine == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(3);
        }
        if (runnerId == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(4);
        }
    }

    protected void attachToProcess(@NotNull AbstractPythonRunConfiguration configuration, @NotNull ProcessHandler handler2, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(5);
        }
        if (handler2 == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(6);
        }
        try {
            Process process = PySciEnvironmentProvider.tryGetProcess(handler2);
            if (process instanceof Tunnelable && !PySciProjectComponent.getInstance(configuration.getProject()).isPortForwarded()) {
                int port = BuiltInServerManager.getInstance().getPort();
                ((Tunnelable)process).addRemoteTunnel(port, "localhost", port);
                PySciProjectComponent.getInstance(configuration.getProject()).enablePortForwarding();
            }
        }
        catch (RemoteSdkException exception) {
            LOG.info("Failed to forward ports: " + exception);
        }
    }

    @Nullable
    private static Process tryGetProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(7);
        }
        if (processHandler instanceof BaseProcessHandler) {
            return ((BaseProcessHandler)processHandler).getProcess();
        }
        return null;
    }

    public void extendEnvironment(@NotNull Project project, @Nullable SdkAdditionalData data, @NotNull GeneralCommandLine cmdLine, @NotNull PythonRunParams runParams) {
        int port;
        if (project == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(8);
        }
        if (cmdLine == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(9);
        }
        if (runParams == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(10);
        }
        Map envs = cmdLine.getEnvironment();
        if (runParams instanceof PydevConsoleRunnerImpl.PythonConsoleRunParams) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                envs.put("PYCHARM_MATPLOTLIB_INTERACTIVE", "true");
                envs.put("PYCHARM_MATPLOTLIB_INDEX", String.valueOf(PyPlotToolWindow.getInstance(project).getLastPlotIndex()));
            });
        }
        if (PySciProjectComponent.getInstance(project).isMatplotlibInToolwindow() && (port = BuiltInServerManager.getInstance().getPort()) != -1) {
            if (data instanceof PyRemoteSdkAdditionalDataBase) {
                try {
                    Integer newPort = PySciEnvironmentProvider.createRemotePortForwarding(project, (PyRemoteSdkAdditionalDataBase)data, port);
                    if (newPort != null) {
                        port = newPort;
                        PySciProjectComponent.getInstance(project).enablePortForwarding();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to create remote port forwarding for port " + port, (Throwable)e);
                }
            }
            envs.put("PYCHARM_DISPLAY_PORT", String.valueOf(port));
            envs.put("PYCHARM_PROJECT_ID", project.getLocationHash());
            envs.put("PYCHARM_UUID", PlotsBackend.GENERATED_UUID);
            int isInteractive = PySciProjectComponent.getInstance(project).isInteractivePlotsMode() ? 1 : 0;
            envs.put("PYCHARM_INTERACTIVE_PLOTS", String.valueOf(isInteractive));
            LOG.info("Plots on port: " + port);
            PythonEnvUtil.addToPythonPath((Map)envs, (Collection)ContainerUtil.map(PlotsBackend.PYCHARM_PLOTS_BACKEND_PACKAGES, PythonHelpersLocator::findPathStringInHelpers));
        }
    }

    @Nullable
    private static Integer createRemotePortForwarding(@NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, int localPort) throws IOException {
        PythonConsoleRemoteProcessCreator[] extensions;
        if (project == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(12);
        }
        for (PythonConsoleRemoteProcessCreator extension : extensions = (PythonConsoleRemoteProcessCreator[])PythonConsoleRemoteProcessCreator.EP_NAME.getExtensions()) {
            if (!extension.getCredentialsType().equals(data.getRemoteConnectionType())) continue;
            return extension.createRemoteTunnel(project, data, localPort);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParams";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/scientific/figures/PySciEnvironmentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetProcess";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extendEnvironment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createRemotePortForwarding";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

