/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.actions.PyExecuteSelectionAction;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteCellAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            PyExecuteCellAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) instanceof EditorImpl) {
            PyExecuteConsoleCustomizer.Companion.getInstance().notifySciCellGutterExecuted((EditorImpl)editor, "PyExecuteCellAction");
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor != null && file != null) {
            PsiElement element = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)this.getValidOffset(editor), PsiElement.class, (boolean)false);
            String cellText = PyExecuteCellAction.getCellText(element);
            if (!PyExecuteInConsole.checkIfAvailableAndShowHint((Editor)editor)) {
                return;
            }
            PyExecuteCellAction.showConsoleAndExecuteCode(e, cellText);
        }
    }

    private static void showConsoleAndExecuteCode(@NotNull AnActionEvent e, @NotNull String cellText) {
        if (e == null) {
            PyExecuteCellAction.$$$reportNull$$$0(1);
        }
        if (cellText == null) {
            PyExecuteCellAction.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PythonRunConfiguration config2 = PyExecuteConsoleCustomizer.Companion.getInstance().getContextConfig(e.getDataContext());
        if (!PyExecuteInConsole.checkIfAvailableAndShowHint((Editor)editor)) {
            return;
        }
        PyExecuteInConsole.executeCodeInConsole((Project)project, (String)cellText, (Editor)editor, (boolean)true, (boolean)false, (boolean)false, (PythonRunConfiguration)config2);
    }

    @NotNull
    private static String getCellText(@Nullable PsiElement element) {
        if (element != null) {
            element = PyCellUtil.getCellStart((PsiElement)element);
            String string = PyCellUtil.getCodeInCell((PsiElement)element);
            if (string == null) {
                PyExecuteCellAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    public int getValidOffset(@NotNull Editor editor) {
        int documentLength;
        int offset2;
        if (editor == null) {
            PyExecuteCellAction.$$$reportNull$$$0(4);
        }
        if ((offset2 = editor.getCaretModel().getOffset()) >= (documentLength = editor.getDocument().getTextLength()) && documentLength > 0) {
            offset2 = documentLength - 1;
        }
        return offset2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PyExecuteCellAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyExecuteCellAction.$$$reportNull$$$0(6);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (file != null && PyExecuteSelectionAction.isPython((Editor)editor) && PyCellUtil.hasCells((PsiFile)file)) {
            PsiElement element = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)this.getValidOffset(editor), PsiElement.class, (boolean)false);
            String text2 = PyExecuteCellAction.getCellText(element);
            enabled = !StringUtil.isEmpty((String)text2);
        }
        presentation.setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellText";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/scientific/cells/PyExecuteCellAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/scientific/cells/PyExecuteCellAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showConsoleAndExecuteCode";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValidOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    public static final class CellActionPromoter
    implements ActionPromoter {
        public List<AnAction> promote(@NotNull List<? extends AnAction> actions, @NotNull DataContext context) {
            if (actions == null) {
                CellActionPromoter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CellActionPromoter.$$$reportNull$$$0(1);
            }
            for (AnAction anAction : actions) {
                if (!(anAction instanceof PyExecuteCellAction)) continue;
                return List.of(anAction);
            }
            return new ArrayList<AnAction>();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/python/scientific/cells/PyExecuteCellAction$CellActionPromoter";
            objectArray[2] = "promote";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

