/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.templates.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pyramid.templates.lexer.ChameleonTokenTypes;
import com.intellij.python.pyramid.templates.parser.ChameleonParsingContext;
import com.intellij.python.pyramid.templates.psi.ChameleonElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.parsing.ParsingContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChameleonParser
implements PsiParser,
ChameleonElementTypes,
ChameleonTokenTypes {
    @NonNls
    protected static final String EXTEND_MACRO_TOK = "extend-macro";
    @NonNls
    protected static final String USE_MACRO_TOK = "use-macro";
    @NonNls
    protected static final String DEFINE_TOK = "define";
    @NonNls
    protected static final String SWITCH_TOK = "switch";
    @NonNls
    protected static final String CASE_TOK = "case";
    @NonNls
    protected static final String OMIT_TAG_TOK = "omit-tag";
    @NonNls
    protected static final String REPEAT_TOK = "repeat";
    @NonNls
    protected static final String REPLACE_TOK = "replace";
    @NonNls
    protected static final String CONTEXT_TOK = "content";
    @NonNls
    protected static final String CONDITION_TOK = "condition";
    @NonNls
    protected static final String ATTRIBUTES_TOK = "attributes";

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        Parsing parsing = new Parsing(builder);
        parsing.parseDocument();
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            ChameleonParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/pyramid/templates/parser/ChameleonParser", "parse"));
    }

    private static class Parsing {
        private final PsiBuilder myBuilder;
        protected ParsingContext myContext;

        Parsing(PsiBuilder builder) {
            this.myBuilder = builder;
            this.myContext = new ChameleonParsingContext(this.myBuilder);
        }

        private void parseDocument() {
            while (!this.myBuilder.eof()) {
                if (this.token() == ChameleonTokenTypes.TAL_STATEMENT) {
                    this.parseTalStatement();
                    continue;
                }
                if (this.token() == ChameleonTokenTypes.METAL_STATEMENT) {
                    this.parseMetalStatement();
                    continue;
                }
                if (this.token() == ChameleonTokenTypes.I18N_STATEMENT) {
                    this.parseI18nStatement();
                    continue;
                }
                if (this.token() == ChameleonTokenTypes.PYTHON_TAG_START) {
                    PsiBuilder.Marker mark = this.mark();
                    this.advance();
                    if (this.token() == ChameleonTokenTypes.PYTHON_CODE) {
                        this.advance();
                    }
                    while (this.token() != ChameleonTokenTypes.PYTHON_TAG_END && this.token() != null) {
                        this.myContext.pushScope(this.myContext.emptyParsingScope());
                        this.myContext.getStatementParser().parseStatement();
                        this.myContext.popScope();
                        if (this.token() != PyTokenTypes.STATEMENT_BREAK) continue;
                        this.advance();
                    }
                    if (this.token() == ChameleonTokenTypes.PYTHON_TAG_END) {
                        this.advance();
                    } else {
                        this.error(PythonProBundle.message((String)"chameleon.closing.tag.expected.error"));
                    }
                    mark.done((IElementType)ChameleonElementTypes.CODE_BLOCK);
                    continue;
                }
                if (this.token() == ChameleonTokenTypes.SUBSTITUTION_EXPR) {
                    this.parseSubstitution();
                    continue;
                }
                this.advance();
            }
        }

        private void parseI18nStatement() {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            if (this.token() == ChameleonTokenTypes.TAL_STATEMENT_NAME) {
                this.advance();
                this.parseI18nValue();
            }
            mark.done((IElementType)ChameleonElementTypes.CHAMELEON_ATTRIBUTE);
        }

        private void parseMetalStatement() {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            if (this.token() == ChameleonTokenTypes.TAL_STATEMENT_NAME) {
                String statementName = this.myBuilder.getTokenText();
                this.advance();
                this.parseMetalValue(statementName);
            }
            mark.done((IElementType)ChameleonElementTypes.CHAMELEON_ATTRIBUTE);
        }

        private void parseMetalValue(String statementName) {
            this.advance();
            if (this.token() == ChameleonTokenTypes.ATTR_START_DELIM) {
                PsiBuilder.Marker mark = this.mark();
                this.advance();
                if (this.token() != ChameleonTokenTypes.ATTR_END_DELIM && (statementName.equals(ChameleonParser.EXTEND_MACRO_TOK) || statementName.equals(ChameleonParser.USE_MACRO_TOK))) {
                    this.parseExpression();
                } else {
                    while (this.token() != null && this.token() != ChameleonTokenTypes.ATTR_END_DELIM) {
                        this.advance();
                    }
                }
                if (this.token() != ChameleonTokenTypes.ATTR_END_DELIM) {
                    this.error(PythonProBundle.message((String)"chameleon.closing.quote.expected.error"));
                }
                mark.done((IElementType)ChameleonElementTypes.CHAMELEON_ATTRIBUTE_VALUE);
            }
        }

        private void parseI18nValue() {
            this.advance();
            if (this.token() == ChameleonTokenTypes.ATTR_START_DELIM) {
                PsiBuilder.Marker mark = this.mark();
                while (this.token() != null && this.token() != ChameleonTokenTypes.ATTR_END_DELIM) {
                    this.advance();
                }
                if (this.token() != ChameleonTokenTypes.ATTR_END_DELIM) {
                    this.error(PythonProBundle.message((String)"chameleon.closing.quote.expected.error"));
                }
                mark.done((IElementType)ChameleonElementTypes.CHAMELEON_ATTRIBUTE_VALUE);
            }
        }

        private void parseTalStatement() {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            if (this.token() == ChameleonTokenTypes.TAL_STATEMENT_NAME) {
                String statementName = this.myBuilder.getTokenText();
                this.advance();
                this.parseTalValue(statementName);
            }
            mark.done((IElementType)ChameleonElementTypes.CHAMELEON_ATTRIBUTE);
        }

        private void parseTalValue(String statementName) {
            this.advance();
            if (this.token() == ChameleonTokenTypes.ATTR_START_DELIM) {
                PsiBuilder.Marker mark = this.mark();
                this.advance();
                this.parseContent(statementName);
                if (this.token() == ChameleonTokenTypes.ATTR_END_DELIM) {
                    this.advance();
                } else {
                    this.error(PythonProBundle.message((String)"chameleon.closing.quote.expected.error"));
                }
                mark.done((IElementType)ChameleonElementTypes.CHAMELEON_ATTRIBUTE_VALUE);
            }
        }

        private void parseContent(String name) {
            if (this.token() == ChameleonTokenTypes.ATTR_END_DELIM) {
                return;
            }
            if (ChameleonParser.DEFINE_TOK.equals(name)) {
                this.parseDefine();
            } else if (ChameleonParser.SWITCH_TOK.equals(name)) {
                this.parseSwitch();
            } else if (ChameleonParser.CASE_TOK.equals(name)) {
                this.parseCase();
            } else if (ChameleonParser.OMIT_TAG_TOK.equals(name)) {
                this.parseOmitTag();
            } else if (ChameleonParser.REPEAT_TOK.equals(name)) {
                this.parseRepeat();
            } else if (ChameleonParser.REPLACE_TOK.equals(name)) {
                this.parseReplace();
            } else if (ChameleonParser.CONTEXT_TOK.equals(name)) {
                this.parseContent();
            } else if (ChameleonParser.CONDITION_TOK.equals(name)) {
                this.parseCondition();
            } else if (ChameleonParser.ATTRIBUTES_TOK.equals(name)) {
                this.parseAttributes();
            }
        }

        private void parseAttributes() {
            this.advance();
            if (this.token() == PyTokenTypes.COLON || this.token() == PyTokenTypes.MINUS) {
                this.advance();
                this.advance();
            }
            this.parseExpression();
            if (this.token() == PyTokenTypes.SEMICOLON) {
                this.advance();
                this.parseAttributes();
            }
        }

        private void parseExpression() {
            if (this.token() == ChameleonTokenTypes.ATTR_END_DELIM) {
                return;
            }
            PsiBuilder.Marker marker = this.mark();
            String tokenText = this.myBuilder.getTokenText();
            this.advance();
            if (this.token() == PyTokenTypes.COLON) {
                marker.drop();
                this.advance();
                if ("string".equals(tokenText)) {
                    this.parseExpressionString();
                } else if ("load".equals(tokenText)) {
                    this.parseExpressionLoad();
                } else {
                    this.myContext.getExpressionParser().parseExpression();
                }
            } else {
                marker.rollbackTo();
                this.myContext.getExpressionParser().parseExpression();
            }
        }

        private void parseExpressionLoad() {
            while (this.token() != null && this.token() != ChameleonTokenTypes.ATTR_END_DELIM) {
                this.advance();
            }
        }

        private void parseExpressionString() {
            if (this.token() == ChameleonTokenTypes.SUBSTITUTION_EXPR) {
                this.parseSubstitution();
            } else {
                this.myContext.getExpressionParser().parseExpression();
            }
        }

        private void parseSubstitution() {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            this.parseExpression();
            if (this.token() != PyTokenTypes.RBRACE) {
                this.error(PythonProBundle.message((String)"chameleon.closing.brace.expected.error"));
            } else {
                this.advance();
            }
            mark.done((IElementType)ChameleonElementTypes.SUBSTITUTION);
        }

        private void parseCondition() {
            this.parseExpression();
        }

        private void parseContent() {
            String text2 = this.myBuilder.getTokenText();
            if ("structure".equals(text2) || "text".equals(text2)) {
                this.advance();
            }
            this.parseExpression();
        }

        private void parseReplace() {
            String text2 = this.myBuilder.getTokenText();
            if ("structure".equals(text2)) {
                this.advance();
            }
            this.parseExpression();
        }

        private void parseRepeat() {
            PsiBuilder.Marker mark = this.mark();
            this.myContext.getExpressionParser().parsePrimaryExpression(true);
            this.parseExpression();
            mark.done((IElementType)ChameleonElementTypes.CHAMELEON_REPEAT);
        }

        private void parseOmitTag() {
            this.parseExpression();
        }

        private void parseCase() {
            this.parseExpression();
        }

        private void parseSwitch() {
            this.parseExpression();
        }

        private void parseDefine() {
            PsiBuilder.Marker mark = this.mark();
            String tokenText = this.myBuilder.getTokenText();
            if ("global".equals(tokenText) || "local".equals(tokenText)) {
                this.advance();
            }
            this.myContext.getExpressionParser().parsePrimaryExpression(true);
            this.parseExpression();
            if (this.token() == PyTokenTypes.SEMICOLON) {
                this.advance();
                this.parseDefine();
            }
            mark.done((IElementType)ChameleonElementTypes.CHAMELEON_DEFINE);
        }

        private IElementType token() {
            return this.myBuilder.getTokenType();
        }

        private PsiBuilder.Marker mark() {
            return this.myBuilder.mark();
        }

        private void advance() {
            this.myBuilder.advanceLexer();
        }

        private void error(@Nullable PsiBuilder.Marker marker, @Nls @NotNull String errorString) {
            if (errorString == null) {
                Parsing.$$$reportNull$$$0(0);
            }
            PsiBuilder.Marker err = this.mark();
            err.error(errorString);
            this.advance();
            if (marker != null) {
                marker.drop();
            }
        }

        private void error(@Nls @NotNull String errorString) {
            if (errorString == null) {
                Parsing.$$$reportNull$$$0(1);
            }
            this.error(null, errorString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorString", "com/intellij/python/pyramid/templates/parser/ChameleonParser$Parsing", "error"));
        }
    }
}

