/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.cacheManager.ui.core;

import com.intellij.python.huggingFace.cacheManager.ui.core.ColumnWidthFittingStrategy;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\nH\u0002J\"\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\nR0\u0010\u0004\u001a$\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00060\u0005j\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/ui/core/MaterialTableUtils;", "", "<init>", "()V", "numericClasses", "Ljava/util/HashSet;", "Ljava/lang/Class;", "Lkotlin/collections/HashSet;", "", "getColumnHeaderWidth", "", "table", "Ljavax/swing/JTable;", "column", "getColumnWidth", "columnIndex", "strategy", "Lcom/intellij/python/huggingFace/cacheManager/ui/core/ColumnWidthFittingStrategy;", "fitColumnWidth", "", "maxWidth", "fitColumnsWidth", "intellij.python.huggingFace"})
public final class MaterialTableUtils {
    @NotNull
    public static final MaterialTableUtils INSTANCE = new MaterialTableUtils();
    @NotNull
    private static final HashSet<? extends Class<? extends Object>> numericClasses;

    private MaterialTableUtils() {
    }

    private final int getColumnHeaderWidth(JTable table, int column) {
        if (table.getTableHeader() == null || table.getColumnModel().getColumnCount() <= column) {
            return 0;
        }
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Object value2 = tableColumn.getHeaderValue();
        TableCellRenderer tableCellRenderer = renderer;
        Intrinsics.checkNotNull((Object)tableCellRenderer);
        Component c = tableCellRenderer.getTableCellRendererComponent(table, value2, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    private final int getColumnWidth(JTable table, int columnIndex, ColumnWidthFittingStrategy strategy) {
        int headerWidth = Math.max(JBUI.scale((int)35), this.getColumnHeaderWidth(table, columnIndex));
        headerWidth = Math.min(headerWidth, 350);
        if (table.getRowCount() == 0) {
            return headerWidth + JBUI.scale((int)10);
        }
        int averageWidth = headerWidth;
        if (strategy == ColumnWidthFittingStrategy.PERCENTILE_BASED && !CollectionsKt.contains((Iterable)numericClasses, table.getColumnClass(columnIndex))) {
            int n;
            int step2 = table.getRowCount() / 50;
            if (step2 == 0) {
                step2 = 1;
            }
            int n2 = 0;
            int n3 = (int)Math.ceil((double)table.getRowCount() / (double)step2);
            Integer[] integerArray = new Integer[n3];
            while (n2 < n3) {
                n = n2++;
                integerArray[n] = 0;
            }
            Integer[] widths = integerArray;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)table.getRowCount())), (int)step2);
            n3 = intProgression.getFirst();
            int n4 = intProgression.getLast();
            n = intProgression.getStep();
            int n5 = 0;
            if (n > 0 && n3 <= n4 || n < 0 && n4 <= n3) {
                while (true) {
                    int i = n5++;
                    int row = n3;
                    TableCellRenderer renderer = table.getCellRenderer(row, columnIndex);
                    Component comp = table.prepareRenderer(renderer, row, columnIndex);
                    widths[i] = comp.getPreferredSize().width;
                    if (row == n4) break;
                    n3 += n;
                }
            }
            ArraysKt.sort((Object[])widths);
            averageWidth = widths[(int)((double)widths.length * 0.75)];
            if (averageWidth < 350) {
                int n6 = 350;
                Integer n7 = (Integer)ArraysKt.maxOrNull((Comparable[])widths);
                n3 = n7 != null ? n7 : JBUI.scale((int)35);
                averageWidth = Math.min(n6, n3);
            }
        } else {
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                TableCellRenderer renderer = table.getCellRenderer(i, columnIndex);
                Component comp = table.prepareRenderer(renderer, i, columnIndex);
                averageWidth = Math.max(averageWidth, comp.getPreferredSize().width);
            }
        }
        return Math.max(headerWidth, averageWidth + JBUI.scale((int)10));
    }

    private final void fitColumnWidth(int columnIndex, JTable table, ColumnWidthFittingStrategy strategy, int maxWidth) {
        int width2 = this.getColumnWidth(table, columnIndex, strategy);
        boolean bl = 1 <= maxWidth ? maxWidth < width2 : false;
        if (bl) {
            width2 = maxWidth;
        }
        table.getColumnModel().getColumn(columnIndex).setPreferredWidth(width2);
    }

    static /* synthetic */ void fitColumnWidth$default(MaterialTableUtils materialTableUtils, int n, JTable jTable, ColumnWidthFittingStrategy columnWidthFittingStrategy, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            columnWidthFittingStrategy = ColumnWidthFittingStrategy.MAX_WIDTH_BASED;
        }
        if ((n3 & 8) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        materialTableUtils.fitColumnWidth(n, jTable, columnWidthFittingStrategy, n2);
    }

    public final void fitColumnsWidth(@NotNull JTable table, @NotNull ColumnWidthFittingStrategy strategy, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        int n = table.getColumnCount();
        for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
            this.fitColumnWidth(columnIndex, table, strategy, maxWidth);
        }
    }

    public static /* synthetic */ void fitColumnsWidth$default(MaterialTableUtils materialTableUtils, JTable jTable, ColumnWidthFittingStrategy columnWidthFittingStrategy, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            columnWidthFittingStrategy = ColumnWidthFittingStrategy.MAX_WIDTH_BASED;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        materialTableUtils.fitColumnsWidth(jTable, columnWidthFittingStrategy, n);
    }

    static {
        Object[] objectArray = new Class[]{Integer.TYPE, Double.TYPE, Long.TYPE, Float.TYPE};
        numericClasses = SetsKt.hashSetOf((Object[])objectArray);
    }
}

