/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.compose.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.docker.utils.DockerNetworkUtil;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.docker.PyDockerProcessUtil;
import com.intellij.python.docker.compose.console.PythonConsoleDockerComposeProcessCreatorKt;
import com.intellij.remote.CredentialsType;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/docker/compose/console/PythonConsoleDockerComposeProcessCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/docker/remote/DockerComposeCredentialsHolder;", "<init>", "()V", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "Companion", "intellij.python.docker"})
public final class PythonConsoleDockerComposeProcessCreator
implements PythonConsoleRemoteProcessCreator<DockerComposeCredentialsHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DOCKER_CONTAINER_PROJECT_PATH = "/opt/project";

    @NotNull
    public CredentialsType<DockerComposeCredentialsHolder> getCredentialsType() {
        DockerComposeCredentialsType dockerComposeCredentialsType = DockerComposeCredentialsType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeCredentialsType, (String)"getInstance(...)");
        return (CredentialsType)dockerComposeCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull DockerComposeCredentialsHolder credentials) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        int clientPort = NetUtils.findAvailableSocketPort();
        PydevConsoleCli.setupPythonConsoleScriptInServerMode((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), (Integer)clientPort);
        String[] stringArray = commandLine.getParametersList().getArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArray(...)");
        String[] command = stringArray;
        Map map2 = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
        Map env = map2;
        File workDirectory = commandLine.getWorkDirectory();
        GeneralCommandLine patchedCommandLine = new GeneralCommandLine();
        patchedCommandLine.setWorkDirectory(workDirectory);
        patchedCommandLine.withParameters(Arrays.copyOf(command, command.length));
        patchedCommandLine.getEnvironment().putAll(env);
        patchedCommandLine.getParametersList().set(0, PythonRemoteInterpreterManager.toSystemDependent((String)new File(data.getHelpersPath(), runnerFileFromHelpers).getPath(), (boolean)PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        try {
            String dockerHost;
            String string;
            patchedCommandLine.putUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS, (Object)PythonConsoleDockerComposeProcessCreator.Companion.buildDockerPathMappings(project));
            DockerCloudConfiguration configuration = DockerUtils.getDockerCloudConfiguration((String)credentials.getAccountName());
            List portBindings = CollectionsKt.listOf((Object)new DockerComposePort("0.0.0.0", Integer.valueOf(clientPort), Integer.valueOf(clientPort)));
            BaseOSProcessHandler processHandler = PythonConsoleDockerComposeProcessCreatorKt.access$startDockerComposeProcess(project, patchedCommandLine, data, pathMapper, portBindings);
            Process process = processHandler.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            Process process2 = process;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using communication for Python console: port " + clientPort + " on pydevconsole.py side");
            }
            if ((string = DockerNetworkUtil.getDockerEngineAddress((DockerCloudConfiguration)configuration)) == null) {
                string = dockerHost = "localhost";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + dockerHost + " address to connect to pydevconsole.py side");
            }
            PydevConsoleCli.waitForPythonConsoleServerToBeStarted((Process)process2);
            PydevConsoleCommunicationClient pydevConsoleCommunication = new PydevConsoleCommunicationClient(project, dockerHost, clientPort, process2);
            pydevConsoleCommunication.connect();
            PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(data).getPyRemoteSocketToLocalHostProvider();
            Intrinsics.checkNotNullExpressionValue((Object)pyRemoteSocketToLocalHostProvider, (String)"getPyRemoteSocketToLocalHostProvider(...)");
            PyRemoteSocketToLocalHostProvider socketProvider = pyRemoteSocketToLocalHostProvider;
            PydevConsoleCommunication pydevConsoleCommunication2 = (PydevConsoleCommunication)pydevConsoleCommunication;
            String string2 = processHandler.getCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLine(...)");
            return new RemoteConsoleProcessData(pydevConsoleCommunication2, string2, process2, socketProvider);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Logger logger2 = Logger.getInstance((String)PythonConsoleDockerComposeProcessCreator.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/python/docker/compose/console/PythonConsoleDockerComposeProcessCreator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DOCKER_CONTAINER_PROJECT_PATH", "", "buildDockerPathMappings", "Lcom/intellij/util/PathMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final PathMappingSettings buildDockerPathMappings(Project project) {
            return new PathMappingSettings(CollectionsKt.listOf((Object)new PathMappingSettings.PathMapping(project.getBasePath(), PythonConsoleDockerComposeProcessCreator.DOCKER_CONTAINER_PROJECT_PATH)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

