/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker;

import com.google.common.base.Joiner;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.docker.LineWiseStreamConsumer;
import com.intellij.python.docker.PyDockerAgentDeploymentConfigImpl;
import com.intellij.python.docker.PyDockerBundle;
import com.intellij.python.docker.PyDockerProcessConnectionData;
import com.intellij.python.docker.PyDockerProcessUtil;
import com.intellij.python.docker.PyDockerSkeletonGeneratorBase;
import com.intellij.python.remoteInterpreter.PyRemoteSkeletonGeneratorBase;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerSkeletonGenerator
extends PyDockerSkeletonGeneratorBase {
    public PyDockerSkeletonGenerator(@Nullable Project project, String skeletonsPath, Sdk sdk) {
        super(project, skeletonsPath, sdk);
    }

    @NotNull
    public ProcessOutput getProcessOutput(String homePath, String @NotNull [] commandLine, @Nullable String stdin, @Nullable Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        OutputStream outputStream;
        if (commandLine == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(0);
        }
        Object[] extendedCommandLine = PyRemoteSkeletonGeneratorBase.addUnbuffered(homePath, commandLine);
        RemoteDockerApplicationRuntime applicationRuntime = this.createContainer((String[])extendedCommandLine);
        try {
            OutputStream input;
            applicationRuntime.startAndAttach();
            if (stdin != null) {
                input = applicationRuntime.getStdin();
                PyDockerSkeletonGenerator.sendLineToStream((OutputStream)input, (String)stdin);
            }
            input = applicationRuntime.wait4AndGetOutput();
            outputStream = input;
        }
        catch (ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        finally {
            applicationRuntime.removeContainerWithVolumes();
        }
        if (outputStream == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(1);
        }
        return outputStream;
    }

    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener2) throws InvalidSdkException {
        ProcessOutput processOutput;
        if (homePath == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (cmd == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(5);
        }
        Object[] extendedCommandLine = PyRemoteSkeletonGeneratorBase.addUnbuffered(homePath, ArrayUtil.toStringArray(cmd));
        RemoteDockerApplicationRuntime applicationRuntime = this.createContainer((String[])extendedCommandLine);
        try {
            applicationRuntime.startAndAttach();
            OutputStream input = applicationRuntime.getStdin();
            if (stdin != null) {
                PyDockerSkeletonGenerator.sendLineToStream((OutputStream)input, (String)stdin);
            }
            ProcessOutput output = new ProcessOutput();
            LineWiseStreamConsumer stdoutConsumer = LineWiseStreamConsumer.consume(applicationRuntime.getStdout(), line2 -> {
                listener2.onStdoutLine(line2);
                output.appendStdout(line2);
                output.appendStdout("\n");
            });
            LineWiseStreamConsumer stderrConsumer = LineWiseStreamConsumer.consume(applicationRuntime.getStderr(), line2 -> {
                listener2.onStderrLine(line2);
                output.appendStderr(line2);
                output.appendStderr("\n");
            });
            int exitCode = applicationRuntime.wait4Exit();
            output.setExitCode(exitCode);
            stdoutConsumer.await();
            stderrConsumer.await();
            ProcessOutput processOutput2 = output;
            processOutput = processOutput2;
        }
        catch (ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        finally {
            applicationRuntime.removeContainerWithVolumes();
        }
        if (processOutput == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.getProcessConnectionData().getAccount(), (Project)this.getProject());
        if (remoteDockerRuntime == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(7);
        }
        return remoteDockerRuntime;
    }

    @NotNull
    private RemoteDockerApplicationRuntime createContainer(String @NotNull [] extendedCommandLine) throws InvalidSdkException {
        RemoteDockerApplicationRuntime applicationRuntime;
        if (extendedCommandLine == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(8);
        }
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerProcessConnectionData data = PyDockerProcessUtil.getPyDockerProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), (PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        try {
            RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
            VolumesBuilder bindingBuilder = VolumesBuilder.builder();
            bindingBuilder.addBoundVolume("/opt/pycharm/skeletons", this.prepareSkeletonsVolume());
            HashMap<String, String> env = new HashMap<String, String>();
            PythonEnvUtil.setPythonUnbuffered(env);
            env.put("JETBRAINS_REMOTE_RUN", "1");
            PyDockerAgentDeploymentConfigImpl config2 = new PyDockerAgentDeploymentConfigImpl(data.getImage(), bindingBuilder.build(), null);
            config2.withEnvs(env);
            config2.withEntrypoint(new String[0]);
            config2.setupHelpers(dockerRuntime);
            config2.setupRemoteCommandLine(pathMapper, extendedCommandLine, null, sdkAdditionalData.getInterpreterPath());
            applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config2);
        }
        catch (RemoteSdkException | ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join((Object[])extendedCommandLine), e});
            throw PyDockerSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = applicationRuntime;
        if (remoteDockerApplicationRuntime == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(9);
        }
        return remoteDockerApplicationRuntime;
    }

    @Override
    @NotNull
    protected String setupSkeletonsVolume() throws ServerRuntimeException, RemoteSdkException, IOException {
        String user;
        String volumeName = this.computeSkeletonsVolumeName();
        PyDockerProcessConnectionData data = this.getProcessConnectionData();
        LOG.debug("Setting up volume \"" + volumeName + "\" for skeletons for image \"" + data.getImage() + "\"");
        RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
        DockerAgentImage image = dockerRuntime.findImageByName(data.getImage());
        String string = user = image == null ? null : image.getUser();
        if (StringUtil.isNotEmpty((String)user)) {
            LOG.debug("User for image \"" + data.getImage() + "\" is " + user + ", permissions setup for skeletons volume \"" + volumeName + "\" required");
            VolumesBuilder volumesBuilder = VolumesBuilder.builder().addBoundVolume("/opt/pycharm/skeletons", volumeName);
            DockerAgentDeploymentConfigImpl config2 = new DockerAgentDeploymentConfigImpl(data.getImage(), volumesBuilder.build()).withUser("root").withEntrypoint(ArrayUtilRt.EMPTY_STRING_ARRAY).withCommand(new String[]{"chown", "-R", user, "/opt/pycharm/skeletons"});
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config2);
            ProcessOutput output = applicationRuntime.startAndGetOutput();
            if (!output.checkSuccess(LOG)) {
                throw new RemoteSdkException(PyDockerBundle.message("failed.to.change.owner.skeletons.volume.for.docker.image", data.getImage()));
            }
        } else {
            LOG.debug("User for image \"" + data.getImage() + "\" is default (root)");
        }
        String string2 = volumeName;
        if (string2 == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    private PyDockerProcessConnectionData getProcessConnectionData() {
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerProcessConnectionData pyDockerProcessConnectionData = PyDockerProcessUtil.getPyDockerProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        if (pyDockerProcessConnectionData == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(11);
        }
        return pyDockerProcessConnectionData;
    }

    @Override
    protected void doDownloadSources(@NotNull String srcRemotePath, @NotNull File targetLocalDir, @NotNull VolumesBuilder bindingBuilder, @Nullable Map<String, String> map2) throws RemoteSdkException, IOException, ServerRuntimeException {
        if (srcRemotePath == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(12);
        }
        if (targetLocalDir == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(13);
        }
        if (bindingBuilder == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(14);
        }
        PyDockerProcessConnectionData data = this.getProcessConnectionData();
        RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
        DockerAgentDeploymentConfigImpl config2 = new DockerAgentDeploymentConfigImpl(data.getImage(), bindingBuilder.build()).withCommand(new String[]{"/bin/true"});
        RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config2);
        applicationRuntime.downloadDirectoryAndRemove(srcRemotePath, targetLocalDir, map2, data.getAccount().getMachine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/docker/PyDockerSkeletonGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedCommandLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRemotePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocalDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/docker/PyDockerSkeletonGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithLineOutputListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSkeletonsVolume";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessConnectionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithLineOutputListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadSources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

