/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer.tool.panels;

import com.intellij.python.concurrencyVisualizer.PythonConcurrencyVisualizerBundle;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyGraphSettings;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyNotesPanel
extends JPanel {
    private static final int HEIGHT = ConcurrencyGraphSettings.TABLE_ROW_HEIGHT * 3 / 2;
    private static final int VERTICAL_INTERVAL = ConcurrencyGraphSettings.TABLE_ROW_HEIGHT / 2;
    private static final int HORIZONTAL_INTERVAL = ConcurrencyGraphSettings.TABLE_ROW_HEIGHT / 2;
    private static final int RECT_EDGE = ConcurrencyGraphSettings.TABLE_ROW_HEIGHT / 2;
    private final String[] COLOR_NAMES = new String[]{PythonConcurrencyVisualizerBundle.message("concurrency.panel.notes.running", new Object[0]), PythonConcurrencyVisualizerBundle.message("concurrency.panel.notes.waiting.for.lock", new Object[0]), PythonConcurrencyVisualizerBundle.message("concurrency.panel.notes.running.with.lock", new Object[0]), PythonConcurrencyVisualizerBundle.message("concurrency.panel.notes.deadlock", new Object[0])};
    private final Color[] COLORS = new Color[]{ConcurrencyGraphSettings.BASIC_COLOR, ConcurrencyGraphSettings.LOCK_WAIT_COLOR, ConcurrencyGraphSettings.LOCK_OWNING_COLOR, ConcurrencyGraphSettings.DEADLOCK_COLOR};

    public ConcurrencyNotesPanel(JPanel panel) {
        this.setPreferredSize(new Dimension(panel.getWidth(), HEIGHT));
        this.setBackground((Color)JBColor.WHITE);
        this.setBorder(BorderFactory.createLineBorder(JBColor.border()));
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            ConcurrencyNotesPanel.$$$reportNull$$$0(0);
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics metrics = g.getFontMetrics(this.getFont());
        int padding = HORIZONTAL_INTERVAL;
        for (int i = 0; i < this.COLOR_NAMES.length; ++i) {
            String text2 = this.COLOR_NAMES[i];
            int textWidth = metrics.stringWidth(text2);
            int textHeight = metrics.getHeight();
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(this.COLORS[i]);
            g2.fillRect(padding, VERTICAL_INTERVAL, RECT_EDGE, RECT_EDGE);
            g2.setColor((Color)JBColor.BLACK);
            g.drawString(text2, padding += RECT_EDGE + HORIZONTAL_INTERVAL, VERTICAL_INTERVAL + textHeight / 2);
            padding += textWidth + HORIZONTAL_INTERVAL;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/python/concurrencyVisualizer/tool/panels/ConcurrencyNotesPanel", "paintComponent"));
    }
}

