/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.google.common.collect.ImmutableList;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.jinja.template.formatter.BlockIndex;
import com.intellij.jinja.template.formatter.DjangoIndentingBlock;
import com.intellij.jinja.template.formatter.DjangoTagBlock;
import com.intellij.jinja.template.formatter.DjangoTemplateFormattingModelBuilder;
import com.intellij.jinja.template.formatter.MutableBlock;
import com.intellij.jinja.template.formatter.MutableBlockWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockModification {
    protected final Block myParentBlock;
    private final Type myType;

    public BlockModification(Type type, @NotNull Block parentBlock) {
        if (parentBlock == null) {
            BlockModification.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.myParentBlock = parentBlock;
    }

    public Type getType() {
        return this.myType;
    }

    public abstract List<Block> applyToChildren(ImmutableList<Block> var1, BlockIndex var2);

    public Block apply(BlockIndex index) {
        List<Block> subBlocks = this.applyToChildren((ImmutableList<Block>)ImmutableList.copyOf((Collection)this.myParentBlock.getSubBlocks()), index);
        index.updateParent(subBlocks, this.myParentBlock);
        Block grandParent = index.getParent(this.myParentBlock);
        if (subBlocks.isEmpty()) {
            return BlockModification.deleteBlocksFrom(Collections.singletonList(this.myParentBlock), grandParent).apply(index);
        }
        if (this.myParentBlock instanceof MutableBlock) {
            ((MutableBlock)this.myParentBlock).setSubBlocks(subBlocks);
            if (grandParent != null) {
                return BlockModification.goUp(grandParent, index);
            }
            return this.myParentBlock;
        }
        MutableBlockWrapper newBlock = new MutableBlockWrapper(this.myParentBlock, subBlocks);
        index.updateParent(subBlocks, (Block)newBlock);
        index.updateParent(newBlock, grandParent);
        if (grandParent != null) {
            return BlockModification.replace(this.myParentBlock, newBlock, grandParent).apply(index);
        }
        index.replace(this.myParentBlock, newBlock);
        return newBlock;
    }

    private static Block goUp(Block block, BlockIndex index) {
        Block parent;
        if (block instanceof MutableBlock) {
            ((MutableBlock)block).dropCaches();
        }
        if ((parent = index.getParent(block)) != null) {
            return BlockModification.goUp(parent, index);
        }
        return block;
    }

    @NotNull
    public static BlockModification deleteBlocksFrom(@NotNull List<Block> blocksToDel, @NotNull Block fromWhere) {
        if (blocksToDel == null) {
            BlockModification.$$$reportNull$$$0(1);
        }
        if (fromWhere == null) {
            BlockModification.$$$reportNull$$$0(2);
        }
        return new DeleteModification(blocksToDel, fromWhere);
    }

    @NotNull
    public static BlockModification addBlocksAfter(@NotNull List<Block> blocksToAdd, @NotNull Block parentBlock, @Nullable Block after) {
        if (blocksToAdd == null) {
            BlockModification.$$$reportNull$$$0(3);
        }
        if (parentBlock == null) {
            BlockModification.$$$reportNull$$$0(4);
        }
        return new AddModification(blocksToAdd, parentBlock, after);
    }

    @NotNull
    public static BlockModification replace(@NotNull Block blockToReplace, @NotNull Block replacement, @NotNull Block parentBlock) {
        if (blockToReplace == null) {
            BlockModification.$$$reportNull$$$0(5);
        }
        if (replacement == null) {
            BlockModification.$$$reportNull$$$0(6);
        }
        if (parentBlock == null) {
            BlockModification.$$$reportNull$$$0(7);
        }
        return new ReplaceModification(blockToReplace, replacement, parentBlock);
    }

    @NotNull
    public static BlockModification indentInnerBlocksBetween(@Nullable XmlFormattingPolicy policy, @NotNull Block after, @NotNull Block before, @NotNull Set<Block> middle, @NotNull Block parentBlock) {
        if (after == null) {
            BlockModification.$$$reportNull$$$0(8);
        }
        if (before == null) {
            BlockModification.$$$reportNull$$$0(9);
        }
        if (middle == null) {
            BlockModification.$$$reportNull$$$0(10);
        }
        if (parentBlock == null) {
            BlockModification.$$$reportNull$$$0(11);
        }
        return new IndentInnerModification(policy, after, before, parentBlock, middle);
    }

    @NotNull
    public static BlockModification uniteTagBlock(@NotNull Block after, @NotNull Block before, @NotNull Block parentBlock) {
        if (after == null) {
            BlockModification.$$$reportNull$$$0(12);
        }
        if (before == null) {
            BlockModification.$$$reportNull$$$0(13);
        }
        if (parentBlock == null) {
            BlockModification.$$$reportNull$$$0(14);
        }
        return new UniteTagBlockModification(after, before, parentBlock);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocksToDel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromWhere";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocksToAdd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockToReplace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middle";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jinja/template/formatter/BlockModification";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBlocksFrom";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addBlocksAfter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "indentInnerBlocksBetween";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "uniteTagBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Type {
        ADD,
        DELETE,
        REPLACE,
        INDENT_INNER;

    }

    private static class DeleteModification
    extends BlockModification {
        private final List<Block> myBlocksToDel;

        DeleteModification(@NotNull List<Block> blocksToDel, @NotNull Block parentBlock) {
            if (blocksToDel == null) {
                DeleteModification.$$$reportNull$$$0(0);
            }
            if (parentBlock == null) {
                DeleteModification.$$$reportNull$$$0(1);
            }
            super(Type.DELETE, parentBlock);
            this.myBlocksToDel = blocksToDel;
        }

        @Override
        public List<Block> applyToChildren(ImmutableList<Block> subBlocks, BlockIndex index) {
            ArrayList<Block> result2 = new ArrayList<Block>();
            result2.addAll((Collection<Block>)subBlocks);
            for (Block b2 : this.myBlocksToDel) {
                index.updateParent(b2, null);
            }
            result2.removeAll(this.myBlocksToDel);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "blocksToDel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentBlock";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jinja/template/formatter/BlockModification$DeleteModification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddModification
    extends BlockModification {
        @NotNull
        private final List<Block> myBlocksToAdd;
        @Nullable
        private final Block myAfter;

        AddModification(@NotNull List<Block> blockToAdd, @NotNull Block parentBlock, @Nullable Block after) {
            if (blockToAdd == null) {
                AddModification.$$$reportNull$$$0(0);
            }
            if (parentBlock == null) {
                AddModification.$$$reportNull$$$0(1);
            }
            super(Type.ADD, parentBlock);
            this.myBlocksToAdd = blockToAdd;
            this.myAfter = after;
        }

        @Override
        public List<Block> applyToChildren(ImmutableList<Block> subBlocks, BlockIndex index) {
            ArrayList<Block> result2 = new ArrayList<Block>();
            result2.addAll((Collection<Block>)subBlocks);
            Indent indent = null;
            if (!subBlocks.isEmpty()) {
                indent = ((Block)subBlocks.get(0)).getIndent();
            }
            if (indent == null) {
                indent = Indent.getNoneIndent();
            }
            int i = -1;
            if (this.myAfter != null && (i = result2.indexOf(this.myAfter)) == -1) {
                throw new IllegalStateException("after hook should present in subBlocks");
            }
            for (Block b2 : this.myBlocksToAdd) {
                if (!indent.equals(b2.getIndent())) {
                    MutableBlock w = MutableBlockWrapper.adapt(b2, index);
                    w.setIndent(indent);
                    b2 = w;
                }
                if (this.myAfter != null) {
                    result2.add(i + 1, b2);
                    ++i;
                    continue;
                }
                result2.add(b2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "blockToAdd";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentBlock";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jinja/template/formatter/BlockModification$AddModification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceModification
    extends BlockModification {
        private final Block myBlockToReplace;
        private final Block myReplacement;

        ReplaceModification(@NotNull Block blockToReplace, @NotNull Block replacement, @NotNull Block parentBlock) {
            if (blockToReplace == null) {
                ReplaceModification.$$$reportNull$$$0(0);
            }
            if (replacement == null) {
                ReplaceModification.$$$reportNull$$$0(1);
            }
            if (parentBlock == null) {
                ReplaceModification.$$$reportNull$$$0(2);
            }
            super(Type.REPLACE, parentBlock);
            this.myBlockToReplace = blockToReplace;
            this.myReplacement = replacement;
        }

        @Override
        public List<Block> applyToChildren(ImmutableList<Block> subBlocks, BlockIndex index) {
            ArrayList<Block> result2 = new ArrayList<Block>();
            for (Block b2 : subBlocks) {
                if (index.equalBlocks(this.myBlockToReplace, b2)) {
                    result2.add(this.myReplacement);
                    index.replace(b2, this.myReplacement);
                    continue;
                }
                result2.add(b2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "blockToReplace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replacement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentBlock";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jinja/template/formatter/BlockModification$ReplaceModification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IndentInnerModification
    extends BlockModification {
        @Nullable
        private final XmlFormattingPolicy myFormattingPolicy;
        private final Block myAfter;
        private final Block myBefore;
        private final Set<Block> myMiddle;

        IndentInnerModification(@Nullable XmlFormattingPolicy policy, @NotNull Block after, @NotNull Block before, @NotNull Block parentBlock, @NotNull Set<Block> middle) {
            if (after == null) {
                IndentInnerModification.$$$reportNull$$$0(0);
            }
            if (before == null) {
                IndentInnerModification.$$$reportNull$$$0(1);
            }
            if (parentBlock == null) {
                IndentInnerModification.$$$reportNull$$$0(2);
            }
            if (middle == null) {
                IndentInnerModification.$$$reportNull$$$0(3);
            }
            super(Type.INDENT_INNER, parentBlock);
            this.myFormattingPolicy = policy;
            this.myAfter = after;
            this.myBefore = before;
            this.myMiddle = middle;
        }

        @Override
        public List<Block> applyToChildren(ImmutableList<Block> subBlocks, BlockIndex index) {
            ArrayList<Block> result2 = new ArrayList<Block>();
            ArrayList<Block> inner = new ArrayList<Block>();
            ArrayList<Block> indentList = new ArrayList<Block>();
            Indent indent = null;
            boolean addToInner = false;
            for (Block b2 : subBlocks) {
                if (index.equalBlocks(b2, this.myBefore)) {
                    addToInner = false;
                    this.processInner(index, indentList, inner);
                    indentList.add(IndentInnerModification.withIndent(Indent.getNoneIndent(), b2, index));
                    ArrayList<Block> list2 = indentList;
                    DjangoIndentingBlock indentingBlock = new DjangoIndentingBlock(list2, indent);
                    index.updateParent(list2, (Block)indentingBlock);
                    result2.add(indentingBlock);
                }
                if (this.isMiddle(index, b2)) {
                    this.processInner(index, indentList, inner);
                    inner.clear();
                    indentList.add(IndentInnerModification.withIndent(Indent.getNoneIndent(), b2, index));
                } else if (addToInner) {
                    inner.add(b2);
                } else if (!index.equalBlocks(b2, this.myAfter) && !index.equalBlocks(b2, this.myBefore)) {
                    result2.add(b2);
                }
                if (!index.equalBlocks(b2, this.myAfter)) continue;
                indent = b2.getIndent();
                addToInner = true;
                indentList.add(IndentInnerModification.withWrapIfNull(IndentInnerModification.withIndent(Indent.getNoneIndent(), b2, index), Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true), index));
            }
            return result2;
        }

        private boolean isMiddle(BlockIndex index, Block b2) {
            for (Block middleBlock : this.myMiddle) {
                if (!index.equalBlocks(b2, middleBlock)) continue;
                return true;
            }
            return false;
        }

        private void processInner(BlockIndex index, List<Block> result2, List<Block> inner) {
            if (!inner.isEmpty()) {
                inner = IndentInnerModification.withIndent(Indent.getNormalIndent(), inner, index);
                if (this.myFormattingPolicy != null) {
                    Wrap textWrap = Wrap.createWrap((WrapType)AbstractXmlBlock.getWrapType((int)this.myFormattingPolicy.getTextWrap(null)), (boolean)true);
                    Wrap attributesWrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                    inner = IndentInnerModification.withWrapIfNull(inner, textWrap, attributesWrap, index);
                }
                result2.addAll(inner);
            }
        }

        private static List<Block> withWrapIfNull(List<Block> blocks, Wrap textWrap, Wrap attributeWrap, BlockIndex index) {
            ArrayList<Block> res = new ArrayList<Block>();
            for (Block b2 : blocks) {
                Block newBlock = IndentInnerModification.isAttributeBlock(b2) ? IndentInnerModification.withWrapIfNull(b2, attributeWrap, index) : IndentInnerModification.withWrapIfNull(b2, textWrap, index);
                res.add(newBlock);
            }
            return res;
        }

        private static boolean isAttributeBlock(Block b2) {
            ASTNode node;
            Block origBlock = b2;
            if (b2 instanceof MutableBlock) {
                origBlock = ((MutableBlockWrapper)b2).getOriginalBlock();
            }
            if (origBlock instanceof ASTBlock && (node = ((ASTBlock)origBlock).getNode()) != null) {
                return DjangoTemplateFormattingModelBuilder.isInAttribute(node.getPsi());
            }
            return false;
        }

        private static Block withWrapIfNull(Block block, Wrap wrap2, BlockIndex index) {
            if (block.getWrap() == null) {
                MutableBlock mb = MutableBlockWrapper.adapt(block, index);
                mb.setWrap(wrap2);
                return mb;
            }
            return block;
        }

        @NotNull
        private static List<Block> withIndent(@NotNull Indent indent, @NotNull List<Block> blocks, @NotNull BlockIndex index) {
            if (indent == null) {
                IndentInnerModification.$$$reportNull$$$0(4);
            }
            if (blocks == null) {
                IndentInnerModification.$$$reportNull$$$0(5);
            }
            if (index == null) {
                IndentInnerModification.$$$reportNull$$$0(6);
            }
            ArrayList<Block> res = new ArrayList<Block>();
            for (Block b2 : blocks) {
                res.add(IndentInnerModification.withIndent(indent, b2, index));
            }
            ArrayList<Block> arrayList = res;
            if (arrayList == null) {
                IndentInnerModification.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        private static Block withIndent(@NotNull Indent indent, @NotNull Block block, @NotNull BlockIndex index) {
            if (indent == null) {
                IndentInnerModification.$$$reportNull$$$0(8);
            }
            if (block == null) {
                IndentInnerModification.$$$reportNull$$$0(9);
            }
            if (index == null) {
                IndentInnerModification.$$$reportNull$$$0(10);
            }
            if (!indent.equals(block.getIndent())) {
                MutableBlock mb = MutableBlockWrapper.adapt(block, index);
                mb.setIndent(indent);
                MutableBlock mutableBlock = mb;
                if (mutableBlock == null) {
                    IndentInnerModification.$$$reportNull$$$0(11);
                }
                return mutableBlock;
            }
            Block block2 = block;
            if (block2 == null) {
                IndentInnerModification.$$$reportNull$$$0(12);
            }
            return block2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "after";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentBlock";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "middle";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blocks";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jinja/template/formatter/BlockModification$IndentInnerModification";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jinja/template/formatter/BlockModification$IndentInnerModification";
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIndent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "withIndent";
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    private static class UniteTagBlockModification
    extends BlockModification {
        private final Block myAfter;
        private final Block myBefore;

        UniteTagBlockModification(@NotNull Block after, @NotNull Block before, @NotNull Block parentBlock) {
            if (after == null) {
                UniteTagBlockModification.$$$reportNull$$$0(0);
            }
            if (before == null) {
                UniteTagBlockModification.$$$reportNull$$$0(1);
            }
            if (parentBlock == null) {
                UniteTagBlockModification.$$$reportNull$$$0(2);
            }
            super(Type.INDENT_INNER, parentBlock);
            this.myAfter = after;
            this.myBefore = before;
        }

        @Override
        public List<Block> applyToChildren(ImmutableList<Block> subBlocks, BlockIndex index) {
            ArrayList<Block> result2 = new ArrayList<Block>();
            ArrayList<Block> inner = new ArrayList<Block>();
            boolean addToInner = false;
            for (Block b2 : subBlocks) {
                if (b2 == this.myBefore) {
                    addToInner = false;
                    DjangoTagBlock tagBlock = new DjangoTagBlock(inner, this.myAfter, this.myBefore);
                    result2.add(tagBlock);
                    index.updateParent(inner, (Block)tagBlock);
                    continue;
                }
                if (b2 == this.myAfter) {
                    addToInner = true;
                    continue;
                }
                if (addToInner) {
                    inner.add(b2);
                    continue;
                }
                result2.add(b2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "after";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "before";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentBlock";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jinja/template/formatter/BlockModification$UniteTagBlockModification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

