/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteCopyPasteManager;
import com.intellij.jupyter.py.ui.remote.providers.MultipleLocalFilesToRemoteDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.MultipleRemoteFilesToOtherRemoteDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.MultipleRemoteFilesToSameRemoteDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.MultipleRemoteItemsToLocalDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommandsKt;
import com.intellij.jupyter.py.ui.remote.providers.SingleLocalFileToRemoteDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.SingleRemoteFileToOtherRemoteDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.SingleRemoteFileToSameRemoteDirCommand;
import com.intellij.jupyter.py.ui.remote.providers.SingleRemoteItemToLocalDirCommand;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nJ\u0018\u0010\u000b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommandFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/actionSystem/DataContext;)V", "createPasteCommand", "Ljava/lang/Runnable;", "Lcom/intellij/jupyter/py/ui/remote/providers/Command;", "handleLocalToRemoteCase", "remoteTargetDirectory", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "handleRemoteToSameRemoteCase", "handleRemoteToOtherRemoteCase", "handleRemoteToLocalCase", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\npasteCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/PasteCommandFactory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n11491#2:395\n13409#2:396\n13410#2:398\n11492#2:399\n1#3:397\n*S KotlinDebug\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/PasteCommandFactory\n*L\n59#1:395\n59#1:396\n59#1:398\n59#1:399\n59#1:397\n*E\n"})
public final class PasteCommandFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final DataContext dataContext;

    public PasteCommandFactory(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.project = project;
        this.dataContext = dataContext;
    }

    @Nullable
    public final Runnable createPasteCommand() {
        JupyterRemotePath jupyterRemotePath = PasteCommandsKt.access$getRemoteTargetDirectory(this.dataContext);
        if (jupyterRemotePath == null) {
            return this.handleRemoteToLocalCase();
        }
        JupyterRemotePath remoteTargetDirectory = jupyterRemotePath;
        Collection<JupyterRemoteNode> remoteSourceItems = JupyterRemoteCopyPasteManager.Companion.getInstance().getRemoteItems();
        return remoteSourceItems == null ? this.handleLocalToRemoteCase(remoteTargetDirectory) : (Intrinsics.areEqual((Object)((JupyterRemoteNode)((Object)CollectionsKt.first((Iterable)remoteSourceItems))).getRemotePath().getAuthority(), (Object)remoteTargetDirectory.getAuthority()) ? this.handleRemoteToSameRemoteCase(remoteTargetDirectory) : this.handleRemoteToOtherRemoteCase(remoteTargetDirectory));
    }

    private final Runnable handleLocalToRemoteCase(JupyterRemotePath remoteTargetDirectory) {
        Object[] objectArray = PsiCopyPasteManager.getInstance().getElements(new boolean[1]);
        if (objectArray == null) {
            return null;
        }
        Object[] itemsToPaste = objectArray;
        if (itemsToPaste.length == 1) {
            Object object = ArraysKt.first((Object[])itemsToPaste);
            PsiFileSystemItem psiFileSystemItem = object instanceof PsiFileSystemItem ? (PsiFileSystemItem)object : null;
            if (psiFileSystemItem == null) {
                return null;
            }
            PsiFileSystemItem fileSystemItem = psiFileSystemItem;
            String string = fileSystemItem.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = fileSystemItem.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = PasteCommandsKt.access$askNewName(this.project, string, string2, remoteTargetDirectory.getFullPath());
            if (string3 == null) {
                return null;
            }
            String newName = string3;
            return new SingleLocalFileToRemoteDirCommand(this.project, newName, fileSystemItem, remoteTargetDirectory);
        }
        List fileSystemItems = new ArrayList();
        Object[] $this$mapNotNullTo$iv = itemsToPaste;
        boolean $i$f$mapNotNullTo = false;
        Object[] $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            PsiFileSystemItem it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            Object it = element$iv;
            boolean bl2 = false;
            if ((it instanceof PsiFileSystemItem ? (PsiFileSystemItem)it : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            ((Collection)fileSystemItems).add(it$iv);
        }
        if (fileSystemItems.size() != itemsToPaste.length) {
            return null;
        }
        return new MultipleLocalFilesToRemoteDirCommand(this.project, fileSystemItems, remoteTargetDirectory);
    }

    private final Runnable handleRemoteToSameRemoteCase(JupyterRemotePath remoteTargetDirectory) {
        Collection<JupyterRemoteNode> collection = JupyterRemoteCopyPasteManager.Companion.getInstance().getRemoteItems();
        if (collection == null) {
            return null;
        }
        Collection<JupyterRemoteNode> itemsToPaste = collection;
        if (itemsToPaste.size() == 1) {
            JupyterRemoteNode remoteNode = (JupyterRemoteNode)((Object)CollectionsKt.first((Iterable)itemsToPaste));
            String string = remoteNode.getRemotePath().getName();
            Intrinsics.checkNotNull((Object)string);
            String string2 = PasteCommandsKt.access$askNewName(this.project, string, remoteNode.getRemotePath().getFullPath(), remoteTargetDirectory.getFullPath());
            if (string2 == null) {
                return null;
            }
            String newName = string2;
            return new SingleRemoteFileToSameRemoteDirCommand(this.project, newName, remoteNode, remoteTargetDirectory);
        }
        return new MultipleRemoteFilesToSameRemoteDirCommand(this.project, itemsToPaste, remoteTargetDirectory);
    }

    private final Runnable handleRemoteToOtherRemoteCase(JupyterRemotePath remoteTargetDirectory) {
        Collection<JupyterRemoteNode> collection = JupyterRemoteCopyPasteManager.Companion.getInstance().getRemoteItems();
        if (collection == null) {
            return null;
        }
        Collection<JupyterRemoteNode> itemsToPaste = collection;
        if (itemsToPaste.size() == 1) {
            JupyterRemoteNode remoteNode = (JupyterRemoteNode)((Object)CollectionsKt.first((Iterable)itemsToPaste));
            String string = remoteNode.getRemotePath().getName();
            Intrinsics.checkNotNull((Object)string);
            String string2 = PasteCommandsKt.access$askNewName(this.project, string, remoteNode.getRemotePath().getFullPath(), remoteTargetDirectory.getFullPath());
            if (string2 == null) {
                return null;
            }
            String newName = string2;
            return new SingleRemoteFileToOtherRemoteDirCommand(this.project, newName, remoteNode, remoteTargetDirectory);
        }
        return new MultipleRemoteFilesToOtherRemoteDirCommand(this.project, itemsToPaste, remoteTargetDirectory);
    }

    private final Runnable handleRemoteToLocalCase() {
        PsiElement psiElement;
        block7: {
            block6: {
                PsiElement psiElement2;
                psiElement = (PsiElement)this.dataContext.getData(LangDataKeys.PASTE_TARGET_PSI_ELEMENT);
                if (psiElement == null) break block6;
                PsiElement $this$handleRemoteToLocalCase_u24lambda_u241 = psiElement;
                boolean bl = false;
                Object object = $this$handleRemoteToLocalCase_u24lambda_u241 instanceof PsiDirectory ? (PsiDirectory)$this$handleRemoteToLocalCase_u24lambda_u241 : ((psiElement2 = $this$handleRemoteToLocalCase_u24lambda_u241.getParent()) instanceof PsiDirectory ? (PsiDirectory)psiElement2 : null);
                psiElement = object;
                if (object != null) break block7;
            }
            return null;
        }
        PsiElement pasteTarget = psiElement;
        Collection<JupyterRemoteNode> collection = JupyterRemoteCopyPasteManager.Companion.getInstance().getRemoteItems();
        if (collection == null) {
            return null;
        }
        Collection<JupyterRemoteNode> itemsToPaste = collection;
        if (itemsToPaste.size() == 1) {
            JupyterRemoteNode remoteNode = (JupyterRemoteNode)((Object)CollectionsKt.first((Iterable)itemsToPaste));
            String string = remoteNode.getRemotePath().getName();
            Intrinsics.checkNotNull((Object)string);
            String string2 = remoteNode.getRemotePath().getFullPath();
            String string3 = pasteTarget.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            String string4 = PasteCommandsKt.access$askNewName(this.project, string, string2, string3);
            if (string4 == null) {
                return null;
            }
            String newName = string4;
            return new SingleRemoteItemToLocalDirCommand(this.project, newName, remoteNode, (PsiDirectory)pasteTarget);
        }
        return new MultipleRemoteItemsToLocalDirCommand(this.project, itemsToPaste, (PsiDirectory)pasteTarget);
    }
}

