/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleService;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/actions/JupyterBaseConsoleAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "service", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;", "getService", "()Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "canCreateConsole", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOrCreateConsoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterBaseConsoleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterBaseConsoleAction.kt\ncom/intellij/jupyter/py/jupyterConsole/actions/JupyterBaseConsoleAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,47:1\n40#2,3:48\n*S KotlinDebug\n*F\n+ 1 JupyterBaseConsoleAction.kt\ncom/intellij/jupyter/py/jupyterConsole/actions/JupyterBaseConsoleAction\n*L\n17#1:48,3\n*E\n"})
public abstract class JupyterBaseConsoleAction
extends AnAction
implements DumbAware {
    @NotNull
    private final JupyterConsoleService service;

    public JupyterBaseConsoleAction() {
        boolean $i$f$service = false;
        Class<JupyterConsoleService> serviceClass$iv = JupyterConsoleService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.service = (JupyterConsoleService)object;
    }

    @NotNull
    protected final JupyterConsoleService getService() {
        return this.service;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected final boolean canCreateConsole(@NotNull AnActionEvent e) {
        JupyterNotebookSession session;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean registryEnabled = Registry.Companion.is("jupyter.console.attached.to.kernel.action");
        Project project = e.getProject();
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        return project != null && virtualFile != null && registryEnabled ? (session = JupyterRuntimeService.Companion.getInstance(project).getSession(virtualFile)) != null && Intrinsics.areEqual((Object)session.getKernelSpec().getLanguage(), (Object)"python") : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final JupyterConsoleView getOrCreateConsoleView(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile) {
        JupyterConsoleView jupyterConsoleView;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        JupyterConsoleView consoleView = this.service.getConsoleView(notebookFile);
        if (consoleView == null) {
            this.service.showConsoleViewContent(project, notebookFile);
            JupyterConsoleView jupyterConsoleView2 = this.service.getConsoleView(notebookFile);
            jupyterConsoleView = jupyterConsoleView2;
            Intrinsics.checkNotNull((Object)((Object)jupyterConsoleView2));
        } else {
            void var3_3;
            this.service.showToolwindowIfInactive(project);
            this.service.requestFocus(consoleView);
            jupyterConsoleView = var3_3;
        }
        return jupyterConsoleView;
    }
}

