/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.outputs;

import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.jupyter.diff.outputs.ComponentExtractor;
import com.intellij.jupyter.diff.outputs.DataExtractor;
import com.intellij.jupyter.diff.outputs.DiffPainter;
import com.intellij.jupyter.diff.outputs.OutputKeysComparator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u0010\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ`\u0010\u0010\u001aD\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0015j\b\u0012\u0004\u0012\u00020\u0006`\u0016\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0015j\b\u0012\u0004\u0012\u00020\u0006`\u0016\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0015j\b\u0012\u0004\u0012\u00020\u0006`\u00160\u00142\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eJ\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u001e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eJ\u001f\u0010\u0019\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001b\"\u00020\u000e\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/diff/outputs/JupyterDiffOutputViewer;", "", "<init>", "()V", "outputComponents", "", "Ljavax/swing/JComponent;", "outputChangeRanges", "Lcom/intellij/diff/util/Range;", "outputChangeMergeRanges", "Lcom/intellij/diff/util/MergeRange;", "highlightOutputsInsert", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlightOutputsDelete", "highlightChangedOutputs", "Lkotlin/Pair;", "editor1", "editor2", "Lkotlin/Triple;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "editor3", "loadOutputKeysDifferences", "loadOutputComponents", "editors", "", "([Lcom/intellij/openapi/editor/Editor;)V", "isOutputDiffChangesEmpty", "", "getOutputChangesCount", "", "getChangedComponent", "outputComponent", "intellij.jupyter.diff"})
@SourceDebugExtension(value={"SMAP\nJupyterDiffOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDiffOutput.kt\ncom/intellij/jupyter/diff/outputs/JupyterDiffOutputViewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,302:1\n1557#2:303\n1628#2,3:304\n1557#2:307\n1628#2,3:308\n1557#2:311\n1628#2,3:312\n1557#2:315\n1628#2,3:316\n11165#3:319\n11500#3,3:320\n19#4:323\n*S KotlinDebug\n*F\n+ 1 JupyterDiffOutput.kt\ncom/intellij/jupyter/diff/outputs/JupyterDiffOutputViewer\n*L\n30#1:303\n30#1:304,3\n35#1:307\n35#1:308,3\n104#1:311\n104#1:312,3\n111#1:315\n111#1:316,3\n116#1:319\n116#1:320,3\n125#1:323\n*E\n"})
public final class JupyterDiffOutputViewer {
    @NotNull
    private List<? extends List<? extends JComponent>> outputComponents = CollectionsKt.emptyList();
    @NotNull
    private List<Range> outputChangeRanges = CollectionsKt.emptyList();
    @NotNull
    private List<? extends MergeRange> outputChangeMergeRanges = CollectionsKt.emptyList();

    /*
     * WARNING - void declaration
     */
    public final void highlightOutputsInsert(@NotNull Editor editor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$map$iv = ComponentExtractor.INSTANCE.getOutputInlays(editor);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Inlay inlay = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EditorCustomElementRenderer editorCustomElementRenderer = it.getRenderer();
            Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            collection.add((JComponent)editorCustomElementRenderer);
        }
        List components = (List)destination$iv$iv;
        TextDiffType textDiffType = TextDiffType.INSERTED;
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"INSERTED");
        DiffPainter.INSTANCE.paintAllComponents(components, editor, textDiffType);
    }

    /*
     * WARNING - void declaration
     */
    public final void highlightOutputsDelete(@NotNull Editor editor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$map$iv = ComponentExtractor.INSTANCE.getOutputInlays(editor);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Inlay inlay = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EditorCustomElementRenderer editorCustomElementRenderer = it.getRenderer();
            Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            collection.add((JComponent)editorCustomElementRenderer);
        }
        List components = (List)destination$iv$iv;
        TextDiffType textDiffType = TextDiffType.DELETED;
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"DELETED");
        DiffPainter.INSTANCE.paintAllComponents(components, editor, textDiffType);
    }

    @NotNull
    public final Pair<List<JComponent>, List<JComponent>> highlightChangedOutputs(@NotNull Editor editor1, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        ArrayList<JComponent> leftChangedComponents = new ArrayList<JComponent>();
        ArrayList<JComponent> rightChangedComponents = new ArrayList<JComponent>();
        if (this.outputComponents.size() < 2) {
            return TuplesKt.to(leftChangedComponents, rightChangedComponents);
        }
        for (Range changeRange : this.outputChangeRanges) {
            JComponent component;
            int i;
            Pair pair = TuplesKt.to((Object)changeRange.start1, (Object)changeRange.end1);
            int start1 = ((Number)pair.component1()).intValue();
            int end1 = ((Number)pair.component2()).intValue();
            Pair pair2 = TuplesKt.to((Object)changeRange.start2, (Object)changeRange.end2);
            int start2 = ((Number)pair2.component1()).intValue();
            int end2 = ((Number)pair2.component2()).intValue();
            for (i = start1; i < end1; ++i) {
                if (i >= this.outputComponents.get(0).size()) continue;
                component = this.outputComponents.get(0).get(i);
                leftChangedComponents.add(this.getChangedComponent(component));
                DiffPainter.INSTANCE.paintDiffComponentTwoSide(component, editor1, Side.LEFT);
            }
            for (i = start2; i < end2; ++i) {
                if (i >= this.outputComponents.get(1).size()) continue;
                component = this.outputComponents.get(1).get(i);
                rightChangedComponents.add(this.getChangedComponent(component));
                DiffPainter.INSTANCE.paintDiffComponentTwoSide(component, editor2, Side.RIGHT);
            }
        }
        return TuplesKt.to(leftChangedComponents, rightChangedComponents);
    }

    @NotNull
    public final Triple<ArrayList<JComponent>, ArrayList<JComponent>, ArrayList<JComponent>> highlightChangedOutputs(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull Editor editor3) {
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Intrinsics.checkNotNullParameter((Object)editor3, (String)"editor3");
        ArrayList<JComponent> leftChangedComponents = new ArrayList<JComponent>();
        ArrayList<JComponent> baseChangedComponents = new ArrayList<JComponent>();
        ArrayList<JComponent> rightChangedComponents = new ArrayList<JComponent>();
        for (MergeRange mergeRange : this.outputChangeMergeRanges) {
            JComponent component;
            int i;
            Pair pair = TuplesKt.to((Object)mergeRange.start1, (Object)mergeRange.end1);
            int start1 = ((Number)pair.component1()).intValue();
            int end1 = ((Number)pair.component2()).intValue();
            Pair pair2 = TuplesKt.to((Object)mergeRange.start2, (Object)mergeRange.end2);
            int start2 = ((Number)pair2.component1()).intValue();
            int end2 = ((Number)pair2.component2()).intValue();
            Pair pair3 = TuplesKt.to((Object)mergeRange.start3, (Object)mergeRange.end3);
            int start3 = ((Number)pair3.component1()).intValue();
            int end3 = ((Number)pair3.component2()).intValue();
            for (i = start1; i < end1; ++i) {
                component = this.outputComponents.get(0).get(i);
                leftChangedComponents.add(this.getChangedComponent(component));
                DiffPainter.INSTANCE.paintDiffComponentThreeSide(component, editor1, ThreeSide.LEFT);
            }
            for (i = start2; i < end2; ++i) {
                component = this.outputComponents.get(1).get(i);
                baseChangedComponents.add(this.getChangedComponent(component));
                DiffPainter.INSTANCE.paintDiffComponentThreeSide(component, editor2, ThreeSide.BASE);
            }
            for (i = start3; i < end3; ++i) {
                component = this.outputComponents.get(2).get(i);
                rightChangedComponents.add(this.getChangedComponent(component));
                DiffPainter.INSTANCE.paintDiffComponentThreeSide(component, editor3, ThreeSide.RIGHT);
            }
        }
        return new Triple(leftChangedComponents, baseChangedComponents, rightChangedComponents);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadOutputKeysDifferences(@NotNull Editor editor1, @NotNull Editor editor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Object[] objectArray = new Editor[]{editor1, editor2};
        List editors = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = editors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Editor editor = (Editor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DataExtractor.INSTANCE.getOutputDataKeys((Editor)it));
        }
        List outputKeysLists = (List)destination$iv$iv;
        this.outputChangeRanges = OutputKeysComparator.INSTANCE.compare((List)outputKeysLists.get(0), (List)outputKeysLists.get(1));
    }

    /*
     * WARNING - void declaration
     */
    public final void loadOutputKeysDifferences(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull Editor editor3) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Intrinsics.checkNotNullParameter((Object)editor3, (String)"editor3");
        Object[] objectArray = new Editor[]{editor1, editor2, editor3};
        List editors = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = editors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Editor editor = (Editor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DataExtractor.INSTANCE.getOutputDataKeys((Editor)it));
        }
        List outputKeysLists = (List)destination$iv$iv;
        this.outputChangeMergeRanges = OutputKeysComparator.INSTANCE.compare((List)outputKeysLists.get(0), (List)outputKeysLists.get(1), (List)outputKeysLists.get(2));
    }

    /*
     * WARNING - void declaration
     */
    public final void loadOutputComponents(Editor ... editors) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)editors, (String)"editors");
        Editor[] editorArray = editors;
        JupyterDiffOutputViewer jupyterDiffOutputViewer = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ComponentExtractor.INSTANCE.getOutputComponents((Editor)it));
        }
        jupyterDiffOutputViewer.outputComponents = (List)destination$iv$iv;
    }

    public final boolean isOutputDiffChangesEmpty() {
        return this.outputChangeRanges.isEmpty();
    }

    public final int getOutputChangesCount() {
        return this.outputChangeRanges.size();
    }

    private final JComponent getChangedComponent(JComponent outputComponent) {
        Component firstComponent;
        Component[] componentArray = outputComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Component $this$asSafely$iv = firstComponent = (Component)ArraysKt.first((Object[])componentArray);
        boolean $i$f$asSafely = false;
        Component component = $this$asSafely$iv;
        if (!(component instanceof JComponent)) {
            component = null;
        }
        JComponent jComponent = (JComponent)component;
        if (jComponent == null) {
            throw new AssertionError((Object)("Output component " + outputComponent + " must have one JComponent inside, but it has " + firstComponent));
        }
        return jComponent;
    }
}

