/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.webcore.util.JsonUtil;
import com.jetbrains.nodejs.run.profile.heap.calculation.HeapSnapshotListener;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HeapSnapshotReader
implements Closeable {
    @NotNull
    private final File myFile;
    private final JsonReader myReader;
    private long myNodesCnt;
    private long myEdgesCnt;
    private long myStringsCnt;
    private List<String> myNodeFields;
    private boolean myHaveTraceData;

    public HeapSnapshotReader(@NotNull File file) throws FileNotFoundException {
        if (file == null) {
            HeapSnapshotReader.$$$reportNull$$$0(0);
        }
        this.myNodeFields = List.of();
        this.myHaveTraceData = false;
        this.myFile = file;
        FileInputStream fileReader = new FileInputStream(this.myFile);
        InputStreamReader ir = new InputStreamReader((InputStream)fileReader, StandardCharsets.UTF_8);
        this.myReader = new JsonReader((Reader)ir);
        this.myStringsCnt = 0L;
    }

    public V8HeapHeader readHeader() throws IOException {
        this.myReader.beginObject();
        HeapSnapshotReader.assertName(this.myReader, "snapshot");
        this.myReader.beginObject();
        String name = this.myFile.getName();
        long traceFunctionsCnt = 0L;
        while (JsonToken.NAME.equals((Object)this.myReader.peek())) {
            String readName = this.myReader.nextName();
            if ("meta".equals(readName)) {
                this.readMeta();
                continue;
            }
            if ("title".equals(readName)) {
                name = readName;
                this.myReader.skipValue();
                continue;
            }
            if ("node_count".equals(readName)) {
                this.myNodesCnt = this.myReader.nextLong();
                continue;
            }
            if ("edge_count".equals(readName)) {
                this.myEdgesCnt = this.myReader.nextLong();
                continue;
            }
            if ("trace_function_count".equals(readName)) {
                traceFunctionsCnt = this.myReader.nextLong();
                this.myHaveTraceData = true;
                continue;
            }
            this.myReader.skipValue();
        }
        this.myReader.endObject();
        return new V8HeapHeader(name, this.myNodesCnt, this.myEdgesCnt, traceFunctionsCnt);
    }

    private void readMeta() throws IOException {
        this.myReader.beginObject();
        while (this.myReader.hasNext()) {
            String name = this.myReader.nextName();
            if ("node_fields".equals(name)) {
                this.myNodeFields = JsonUtil.nextStringList((JsonReader)this.myReader);
                continue;
            }
            this.myReader.skipValue();
        }
        this.myReader.endObject();
    }

    @Override
    public void close() throws IOException {
        this.myReader.close();
    }

    public void readWithReader(@NotNull HeapSnapshotListener listener) throws IOException {
        if (listener == null) {
            HeapSnapshotReader.$$$reportNull$$$0(1);
        }
        while (JsonToken.NAME.equals((Object)this.myReader.peek())) {
            String name = this.myReader.nextName();
            if ("nodes".equals(name)) {
                this.readNodes(this.myReader, listener);
                listener.allNodesRead();
                continue;
            }
            if ("edges".equals(name)) {
                this.readEdges(this.myReader, listener);
                listener.allEdgesRead();
                continue;
            }
            if ("strings".equals(name)) {
                this.myReader.beginArray();
                ++this.myStringsCnt;
                listener.stringsCount(this.myStringsCnt);
                while (this.myReader.hasNext()) {
                    String string = this.myReader.nextString();
                    listener.accept(string);
                }
                this.myReader.endArray();
                continue;
            }
            this.myReader.skipValue();
        }
        this.myReader.endObject();
    }

    private void readEdges(JsonReader reader, HeapSnapshotListener listener) throws IOException {
        reader.beginArray();
        int i = 0;
        while ((long)i < this.myEdgesCnt) {
            long toIndex;
            long nameId;
            int typeCode = reader.nextInt();
            V8HeapEdge edge = V8HeapEdge.createFromJson(typeCode, nameId = reader.nextLong(), toIndex = reader.nextLong(), i, this.myNodeFields);
            if (edge.hasStringName()) {
                this.myStringsCnt = Math.max(this.myStringsCnt, nameId);
            }
            listener.accept(edge);
            ++i;
        }
        reader.endArray();
    }

    private void readNodes(JsonReader reader, HeapSnapshotListener listener) throws IOException {
        reader.beginArray();
        Map<NodeFieldType, Integer> positionByFieldType = Arrays.stream(NodeFieldType.values()).collect(Collectors.toMap(key -> key, key -> this.myNodeFields.indexOf(key.name())));
        int i = 0;
        while ((long)i < this.myNodesCnt) {
            long[] values = HeapSnapshotReader.readLongs(reader, this.myNodeFields.size());
            int type = (int)this.getValue(values, positionByFieldType, NodeFieldType.type);
            long nameId = this.getValue(values, positionByFieldType, NodeFieldType.name);
            long snapshotId = this.getValue(values, positionByFieldType, NodeFieldType.id);
            long size = this.getValue(values, positionByFieldType, NodeFieldType.self_size);
            long childrenCount = this.getValue(values, positionByFieldType, NodeFieldType.edge_count);
            long traceId = this.myHaveTraceData ? this.getValue(values, positionByFieldType, NodeFieldType.trace_node_id) : -1L;
            this.myStringsCnt = Math.max(this.myStringsCnt, nameId);
            listener.accept(V8HeapEntry.createFromJson(type, nameId, snapshotId, childrenCount, size, traceId, i));
            ++i;
        }
        reader.endArray();
    }

    private static long[] readLongs(@NotNull JsonReader reader, int size) throws IOException {
        if (reader == null) {
            HeapSnapshotReader.$$$reportNull$$$0(2);
        }
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            long value;
            if (reader.peek() == JsonToken.NUMBER) {
                value = reader.nextLong();
            } else {
                reader.skipValue();
                value = 0L;
            }
            result[i] = value;
        }
        return result;
    }

    private long getValue(long[] values, @NotNull Map<NodeFieldType, Integer> valueIndByFieldType, @NotNull NodeFieldType fieldType) throws IOException {
        Integer valueInd;
        if (valueIndByFieldType == null) {
            HeapSnapshotReader.$$$reportNull$$$0(3);
        }
        if (fieldType == null) {
            HeapSnapshotReader.$$$reportNull$$$0(4);
        }
        if ((valueInd = valueIndByFieldType.get((Object)fieldType)) == null || valueInd < 0 || valueInd >= values.length) {
            throw new IOException("Wrong format. Cannot find " + NodeFieldType.type + " in " + this.myNodeFields);
        }
        return values[valueInd];
    }

    private static void assertName(@NotNull JsonReader reader, @NotNull String name) throws IOException {
        String readName;
        if (reader == null) {
            HeapSnapshotReader.$$$reportNull$$$0(5);
        }
        if (name == null) {
            HeapSnapshotReader.$$$reportNull$$$0(6);
        }
        if (!name.equals(readName = reader.nextName())) {
            throw new JsonParseException("Wrong format");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueIndByFieldType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/HeapSnapshotReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readWithReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readLongs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "assertName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum NodeFieldType {
        type,
        name,
        id,
        self_size,
        edge_count,
        trace_node_id,
        detachedness;

    }
}

