/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.ui.MyDoNotAskOptionForPush;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushUtils;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dvcs/push/ui/ForcePushAction;", "Lcom/intellij/dvcs/push/ui/PushActionBase;", "<init>", "()V", "actionPerformed", "", "project", "Lcom/intellij/openapi/project/Project;", "ui", "Lcom/intellij/dvcs/push/ui/VcsPushUi;", "isEnabled", "", "getDescription", "", "enabled", "confirmForcePush", "intellij.platform.vcs.dvcs.impl"})
@SourceDebugExtension(value={"SMAP\nForcePushAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForcePushAction.kt\ncom/intellij/dvcs/push/ui/ForcePushAction\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n462#2:92\n412#2:93\n503#2,7:100\n1246#3,2:94\n774#3:96\n865#3,2:97\n1249#3:99\n1557#3:107\n1628#3,3:108\n*S KotlinDebug\n*F\n+ 1 ForcePushAction.kt\ncom/intellij/dvcs/push/ui/ForcePushAction\n*L\n43#1:92\n43#1:93\n46#1:100,7\n43#1:94,2\n44#1:96\n44#1:97,2\n43#1:99\n62#1:107\n62#1:108,3\n*E\n"})
final class ForcePushAction
extends PushActionBase {
    @Override
    protected void actionPerformed(@NotNull Project project, @NotNull VcsPushUi ui) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        if (this.confirmForcePush(project, ui)) {
            ui.push(true);
        }
    }

    @Override
    protected boolean isEnabled(@NotNull VcsPushUi ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        return ui.canPush() && PushUtils.getProhibitedTarget(ui) == null;
    }

    @Override
    @Nullable
    protected String getDescription(@NotNull VcsPushUi ui, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        PushTarget prohibitedTarget = PushUtils.getProhibitedTarget(ui);
        String configurablePath = PushUtils.getProhibitedTargetConfigurablePath(ui);
        if (!enabled && prohibitedTarget != null) {
            Object[] objectArray = new Object[]{prohibitedTarget.getPresentation()};
            String string = DvcsBundle.message("action.force.push.is.prohibited.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object message = string;
            if (configurablePath != null) {
                Object[] objectArray2 = new Object[]{configurablePath};
                message = (String)message + "<br/>" + DvcsBundle.message("action.force.push.is.prohibited.settings.link", objectArray2);
            }
            return message;
        }
        if (configurablePath != null) {
            Object[] objectArray = new Object[]{configurablePath};
            return DvcsBundle.message("action.force.push.is.prohibited.settings.link", objectArray);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean confirmForcePush(Project project, VcsPushUi ui) {
        MyDoNotAskOptionForPush myDoNotAskOptionForPush;
        String string;
        void $this$filterValues$iv;
        Object object;
        PushInfo it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> map = ui.getSelectedPushSpecs();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getSelectedPushSpecs(...)");
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> map2 = map;
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map3;
            boolean bl22 = false;
            PushSupport support = (PushSupport)entry2.getKey();
            Collection pushInfos = (Collection)entry2.getValue();
            Intrinsics.checkNotNull((Object)pushInfos);
            Iterable $this$filter$iv = pushInfos;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PushInfo it = (PushInfo)element$iv$iv;
                boolean bl3 = false;
                if (!(!support.isSilentForcePushAllowed(it.getPushSpec().getTarget()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            object.put(k, list);
        }
        $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl3 = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map silentForcePushIsNotAllowed = result$iv;
        if (silentForcePushIsNotAllowed.isEmpty()) {
            return true;
        }
        PushTarget commonTarget = null;
        PushSupport aSupport = null;
        if (silentForcePushIsNotAllowed.size() > 1) {
            aSupport = null;
            commonTarget = null;
        } else {
            aSupport = (PushSupport)CollectionsKt.first((Iterable)silentForcePushIsNotAllowed.keySet());
            Object v = silentForcePushIsNotAllowed.get(aSupport);
            Intrinsics.checkNotNull(v);
            Iterable $this$map$iv = (Iterable)v;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it;
                it$iv$iv = (PushInfo)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl5 = false;
                object.add(it.getPushSpec().getTarget());
            }
            commonTarget = (PushTarget)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv3)));
        }
        if (commonTarget != null) {
            Object[] objectArray = new Object[]{commonTarget.getPresentation()};
            string = DvcsBundle.message("action.force.push.to.confirmation.text", objectArray);
        } else {
            string = DvcsBundle.message("action.force.push.confirmation.text", new Object[0]);
        }
        String $i$f$map = string;
        Intrinsics.checkNotNull((Object)$i$f$map);
        String message = $i$f$map;
        if (commonTarget != null) {
            PushSupport pushSupport = aSupport;
            Intrinsics.checkNotNull((Object)pushSupport);
            myDoNotAskOptionForPush = new MyDoNotAskOptionForPush(pushSupport, commonTarget);
        } else {
            myDoNotAskOptionForPush = null;
        }
        MyDoNotAskOptionForPush myDoNotAskOption = myDoNotAskOptionForPush;
        String string2 = DvcsBundle.message("force.push.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = XmlStringUtil.wrapInHtml((CharSequence)message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wrapInHtml(...)");
        String string4 = DvcsBundle.message("action.force.push", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        int n = MessageUtil.showOkCancelDialog$default((String)string2, (String)string3, (String)string4, null, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)((DialogWrapper.DoNotAskOption)myDoNotAskOption), (Project)project, (int)8, null);
        return n == 0;
    }
}

