/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.server.ui;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.jupyter.core.JupyterCoreIcons;
import com.intellij.jupyter.core.core.impl.project.UtilKt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterManagedServerConfiguration;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerContentCloseListener;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.net.URI;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u001b"}, d2={"JUPYTER_TOOL_WINDOW_ID", "", "JUPYTER_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getJUPYTER_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "EVENT_LOG_NOTIFICATION_GROUP", "getEVENT_LOG_NOTIFICATION_GROUP", "getJupyterToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateJupyterToolWindow", "attachJupyterServerContentCloseListener", "", "content", "Lcom/intellij/ui/content/Content;", "sessionName", "handler", "Lcom/intellij/execution/process/KillableProcessHandler;", "notifyJupyterServerStarted", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "notifyJupyterServerRunning", "managedServerConfiguration", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterManagedServerConfiguration;", "notifyJupyterServerTerminated", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerToolWindow.kt\ncom/intellij/jupyter/core/jupyter/server/ui/JupyterServerToolWindowKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 JupyterServerToolWindow.kt\ncom/intellij/jupyter/core/jupyter/server/ui/JupyterServerToolWindowKt\n*L\n101#1:106,2\n*E\n"})
public final class JupyterServerToolWindowKt {
    @NotNull
    private static final String JUPYTER_TOOL_WINDOW_ID = "Jupyter";

    @NotNull
    public static final NotificationGroup getJUPYTER_NOTIFICATION_GROUP() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Jupyter Server (Tool Window)");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @NotNull
    public static final NotificationGroup getEVENT_LOG_NOTIFICATION_GROUP() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Jupyter Server (Event Log)");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @Nullable
    public static final ToolWindow getJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow(JUPYTER_TOOL_WINDOW_ID);
    }

    @NotNull
    public static final ToolWindow getOrCreateJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(JUPYTER_TOOL_WINDOW_ID);
        if (toolWindow == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
            ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
            toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(JUPYTER_TOOL_WINDOW_ID, toolWindowAnchor2, null, false, true, false, false, null, null, null, 1004, null));
        }
        ToolWindow toolWindow2 = toolWindow;
        toolWindow2.setIcon(JupyterCoreIcons.ToolWindowJupyter);
        return toolWindow2;
    }

    public static final void attachJupyterServerContentCloseListener(@NotNull Content content, @NotNull Project project, @Nls @NotNull String sessionName, @NotNull KillableProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        new JupyterServerContentCloseListener(content, project, sessionName, handler);
    }

    public static final void notifyJupyterServerStarted(@NotNull Project project, @NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
        URI initialUri = connectionParameters.getLocation().getUri();
        String initialUriString = initialUri.toASCIIString();
        String shareableUri = connectionParameters.getAuthHandler().shareableUrl(initialUri).toASCIIString();
        Object[] objectArray = new Object[]{initialUriString};
        String message2 = JupyterBundle.message("jupyter.server.started.at", objectArray);
        Object[] objectArray2 = new Object[]{HtmlChunk.tag((String)"a").attr("href", shareableUri).addText(initialUriString).toString()};
        String messageWithURL = JupyterBundle.message("jupyter.server.started.at", objectArray2);
        JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP().createNotification(messageWithURL, NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER).notify(project);
        JupyterServerToolWindowKt.getEVENT_LOG_NOTIFICATION_GROUP().createNotification(message2, NotificationType.INFORMATION).addAction((AnAction)new BrowseNotificationAction(JupyterBundle.message("Jupyter.open.in.browser", new Object[0]), shareableUri)).notify(project);
    }

    /*
     * WARNING - void declaration
     */
    public static final void notifyJupyterServerRunning(@NotNull Project project, @NotNull JupyterManagedServerConfiguration managedServerConfiguration) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)managedServerConfiguration, (String)"managedServerConfiguration");
        NotificationGroup notificationGroup = JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP();
        String string = "jupyter.server.running.in";
        Object[] objectArray2 = objectArray = new Object[1];
        int n = 0;
        String string2 = managedServerConfiguration.getWorkingDirectory();
        if (string2 == null) {
            void $this$notifyJupyterServerRunning_u24lambda_u240;
            Module module = managedServerConfiguration.getModule();
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            String string3 = string;
            NotificationGroup notificationGroup2 = notificationGroup;
            boolean bl = false;
            String string4 = UtilKt.getBasePath((Module)$this$notifyJupyterServerRunning_u24lambda_u240);
            if (string4 == null) {
                String string5 = $this$notifyJupyterServerRunning_u24lambda_u240.getName();
                string4 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            }
            String string6 = string4;
            notificationGroup = notificationGroup2;
            string = string3;
            objectArray2 = objectArray3;
            n = n2;
            string2 = string6;
        }
        objectArray2[n] = string2;
        notificationGroup.createNotification(JupyterBundle.message(string, objectArray), NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER).notify(project);
    }

    public static final void notifyJupyterServerTerminated(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new NotificationGroup[]{JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP(), JupyterServerToolWindowKt.getEVENT_LOG_NOTIFICATION_GROUP()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationGroup it = (NotificationGroup)element$iv;
            boolean bl = false;
            it.createNotification(JupyterBundle.message("jupyter.server.stopped", new Object[0]), NotificationType.INFORMATION).notify(project);
        }
    }
}

