/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen;

import com.jetbrains.cef.SharedMemory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/SharedMemoryCache;", "", "<init>", "()V", "CLEAN_CACHE_TIME_MS", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "myCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/cef/SharedMemory$WithRaster;", "myIsDisposed", "", "dispose", "", "cleanCacheIfNecessary", "get", "sharedMemName", "sharedMemHandle", "", "intellij.jupyter.core"})
public final class SharedMemoryCache {
    private final Integer CLEAN_CACHE_TIME_MS = Integer.getInteger("jcef.remote.osr.clean_cache_time_ms", 10000);
    @NotNull
    private final ConcurrentHashMap<String, SharedMemory.WithRaster> myCache = new ConcurrentHashMap();
    private boolean myIsDisposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        SharedMemoryCache sharedMemoryCache = this;
        synchronized (sharedMemoryCache) {
            boolean bl = false;
            if (this.myIsDisposed) {
                return;
            }
            this.myIsDisposed = true;
            this.myCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cleanCacheIfNecessary() {
        long timeMs = System.currentTimeMillis();
        if (this.myCache.size() < 2) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator<Map.Entry<String, Object>> iterator = this.myCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SharedMemory.WithRaster> item;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            if (timeMs - item.getValue().lasUsedMs <= (long)this.CLEAN_CACHE_TIME_MS.intValue()) continue;
            toRemove.add(item.getKey());
        }
        Iterator iterator2 = toRemove.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        iterator = iterator2;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
            String name = (String)((Object)entry);
            this.myCache.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SharedMemory.WithRaster get(@NotNull String sharedMemName, long sharedMemHandle) {
        Intrinsics.checkNotNullParameter((Object)sharedMemName, (String)"sharedMemName");
        SharedMemory.WithRaster mem = null;
        mem = this.myCache.get(sharedMemName);
        if (mem == null) {
            this.cleanCacheIfNecessary();
            mem = new SharedMemory.WithRaster(sharedMemName, sharedMemHandle);
            SharedMemoryCache sharedMemoryCache = this;
            synchronized (sharedMemoryCache) {
                boolean bl = false;
                if (!this.myIsDisposed) {
                    this.myCache.put(sharedMemName, mem);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return mem;
    }
}

