/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.jupyter.core.editor.markdown.FoldAction;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCell;
import com.intellij.jupyter.core.editor.markdown.NotebookStructureElement;
import com.intellij.jupyter.core.editor.markdown.UnfoldAction;
import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.markdown.JupyterMarkdownHtmlPane;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputApi;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.helper.JupyterMarkdownHelperKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.CustomFoldingEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.InputComponent;
import com.intellij.notebooks.visualization.ui.TextEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u0018H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0007J\b\u0010(\u001a\u00020)H\u0016J\u001e\u0010*\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010'0,\u0012\u0006\u0012\u0004\u0018\u00010\f0+H\u0002J3\u0010-\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\f0+2\u000b\u0010.\u001a\u00070/\u00a2\u0006\u0002\b02\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0002J\u000e\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\bJ\u000e\u00105\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u00106\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u00107\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J-\u00108\u001a\u0002H9\"\b\b\u0000\u00109*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0002\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020@H\u0002J\u000e\u0010A\u001a\u00020\u00182\u0006\u0010B\u001a\u00020CJ\u0018\u0010D\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020\bH\u0016J\b\u0010F\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/InputComponent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "foldingEnabled", "", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCell;Z)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "contributedPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "foldedRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "component", "getComponent", "()Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "markdownEditorCell", "Lcom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell;", "updateView", "", "section", "Lcom/intellij/jupyter/core/editor/markdown/NotebookStructureElement$NotebookSection;", "sectionFolded", "unfold", "removeHeadingFolding", "ctx", "Lcom/intellij/notebooks/visualization/UpdateContext;", "removeExistingHiddenCellHint", "removeExistingRegion", "foldingModel", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "foldRegion", "dispose", "getComponentForTest", "Ljavax/swing/JComponent;", "calculateBounds", "Ljava/awt/Rectangle;", "createComponent", "Lkotlin/Pair;", "Ljavax/swing/JLayer;", "createMarkdownRenderer", "markdownText", "", "Lcom/intellij/openapi/util/NlsSafe;", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "switchPresentation", "rendered", "switchToRenderedPresentation", "switchToTextPresentation", "updateInput", "replaceCurrentComponent", "T", "componentFactory", "Lkotlin/Function0;", "(Lcom/intellij/notebooks/visualization/UpdateContext;Lkotlin/jvm/functions/Function0;)Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "createTextComponent", "Lcom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent;", "createFoldingComponent", "Lcom/intellij/notebooks/visualization/ui/CustomFoldingEditorCellViewComponent;", "browserClicked", "clickCount", "", "updateFolding", "folded", "requestCaret", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownEditorCellViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownEditorCellViewComponent.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent\n+ 2 EditorCell.kt\ncom/intellij/notebooks/visualization/ui/EditorCell\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n139#2:314\n1#3:315\n*S KotlinDebug\n*F\n+ 1 MarkdownEditorCellViewComponent.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent\n*L\n61#1:314\n*E\n"})
public final class MarkdownEditorCellViewComponent
extends EditorCellViewComponent
implements InputComponent {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCell cell;
    private final boolean foldingEnabled;
    @NotNull
    private final Disposable disposable;
    @Nullable
    private InlayPresentation contributedPresentation;
    @Nullable
    private FoldRegion foldedRegion;
    @Nullable
    private final MarkdownEditorCell markdownEditorCell;

    public MarkdownEditorCellViewComponent(@NotNull EditorImpl editor, @NotNull EditorCell cell, boolean foldingEnabled) {
        block0: {
            MarkdownEditorCell markdownEditorCell;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            this.editor = editor;
            this.cell = cell;
            this.foldingEnabled = foldingEnabled;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.disposable = disposable;
            EditorCell this_$iv = this.cell;
            boolean $i$f$getExtension = false;
            this.markdownEditorCell = (MarkdownEditorCell)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
            UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, arg_0 -> MarkdownEditorCellViewComponent._init_$lambda$1(this, arg_0), (int)1, null);
            MarkdownEditorCell markdownEditorCell2 = this.markdownEditorCell;
            if (markdownEditorCell2 == null) break block0;
            MarkdownEditorCell $this$_init__u24lambda_u245 = markdownEditorCell = markdownEditorCell2;
            boolean bl = false;
            $this$_init__u24lambda_u245.getSectionFolded().afterChange((Disposable)this, arg_0 -> MarkdownEditorCellViewComponent.lambda$5$lambda$3(this, arg_0));
            $this$_init__u24lambda_u245.getRendered().afterChange((Disposable)this, arg_0 -> MarkdownEditorCellViewComponent.lambda$5$lambda$4(this, arg_0));
        }
    }

    private final EditorCellViewComponent getComponent() {
        return (EditorCellViewComponent)CollectionsKt.firstOrNull((List)this.getChildren());
    }

    private final void updateView(EditorCellViewComponent component2, NotebookStructureElement.NotebookSection section, boolean sectionFolded) {
        ActionsKt.runInEdt$default(null, () -> MarkdownEditorCellViewComponent.updateView$lambda$9(sectionFolded, section, this, component2), (int)1, null);
    }

    public final void unfold() {
        UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.unfold$lambda$10(this, arg_0), (int)1, null);
    }

    public final void removeHeadingFolding(@NotNull UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FoldRegion foldRegion = this.foldedRegion;
        if (foldRegion != null) {
            ctx.addFoldingOperation(arg_0 -> MarkdownEditorCellViewComponent.removeHeadingFolding$lambda$11(this, foldRegion, arg_0));
        }
        this.foldedRegion = null;
    }

    private final void removeExistingHiddenCellHint() {
        InlayPresentation inlayPresentation = this.contributedPresentation;
        if (inlayPresentation != null) {
            InlayPresentation presentation = inlayPresentation;
            boolean bl = false;
            EditorCellViewComponent editorCellViewComponent = this.getComponent();
            if (editorCellViewComponent != null) {
                editorCellViewComponent.removeInlayBelow(presentation);
            }
        }
        this.contributedPresentation = null;
    }

    private final void removeExistingRegion(FoldingModelEx foldingModel, FoldRegion foldRegion) {
        foldingModel.removeFoldRegion(foldRegion);
        foldRegion.dispose();
    }

    public void dispose() {
        UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.dispose$lambda$13(this, arg_0), (int)1, null);
        Disposer.dispose((Disposable)this.disposable);
    }

    @TestOnly
    @Nullable
    public final JComponent getComponentForTest() {
        EditorCellViewComponent editorCellViewComponent = this.getComponent();
        CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent = editorCellViewComponent instanceof CustomFoldingEditorCellViewComponent ? (CustomFoldingEditorCellViewComponent)editorCellViewComponent : null;
        return customFoldingEditorCellViewComponent != null ? customFoldingEditorCellViewComponent.getComponentForTest() : null;
    }

    @NotNull
    public Rectangle calculateBounds() {
        Object object = this.getComponent();
        if (object == null || (object = object.calculateBounds()) == null) {
            object = new Rectangle(0, 0, 0, 0);
        }
        return object;
    }

    private final Pair<JLayer<JComponent>, Disposable> createComponent() {
        Pair<JComponent, Disposable> pair;
        Pair<JComponent, Disposable> pair2 = (Pair<JComponent, Disposable>)this.cell.getSource().get();
        if (StringsKt.isBlank((CharSequence)pair2)) {
            boolean bl = false;
            pair = JupyterBundle.message("markdown.empty.cell.placeholder", new Object[0]);
        } else {
            pair = pair2;
        }
        String markdownText = (String)pair;
        pair2 = this.createMarkdownRenderer(markdownText, this.editor, this.cell.getIntervalPointer());
        JComponent rendererComponent = (JComponent)pair2.component1();
        Disposable rendererDisposable = (Disposable)pair2.component2();
        JLayer<Component> component2 = new JLayer<Component>(rendererComponent, (LayerUI)new LayerUI<JComponent>(this){
            final /* synthetic */ MarkdownEditorCellViewComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void installUI(JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.installUI(c);
                JLayer l = (JLayer)c;
                l.setLayerEventMask(16L);
            }

            public void uninstallUI(JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.uninstallUI(c);
                JLayer l = (JLayer)c;
                l.setLayerEventMask(0L);
            }

            protected void processMouseEvent(MouseEvent e, JLayer<? extends JComponent> l) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(l, (String)"l");
                if (e.getID() == 500) {
                    Object object = e.getSource();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
                    Point editorPoint = SwingUtilities.convertPoint((Component)object, e.getPoint(), (Component)MarkdownEditorCellViewComponent.access$getEditor$p(this.this$0).getContentComponent());
                    LogicalPosition logicalPosition = MarkdownEditorCellViewComponent.access$getEditor$p(this.this$0).xyToLogicalPosition(editorPoint);
                    Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                    LogicalPosition logicalPosition2 = logicalPosition;
                    NotebookVisualizationUiUtilKt.getCell((Editor)((Editor)MarkdownEditorCellViewComponent.access$getEditor$p(this.this$0)), (int)Math.min(logicalPosition2.line, MarkdownEditorCellViewComponent.access$getEditor$p(this.this$0).getDocument().getLineCount() - 1));
                    this.this$0.browserClicked(e.getClickCount());
                }
            }
        });
        component2.setOpaque(false);
        return TuplesKt.to(component2, (Object)rendererDisposable);
    }

    private final Pair<JComponent, Disposable> createMarkdownRenderer(String markdownText, EditorImpl editor, NotebookIntervalPointer intervalPointer) {
        return switch (WhenMappings.$EnumSwitchMapping$0[JupyterDSSettings.Companion.getInstance().getMarkdownRenderMode().ordinal()]) {
            case 1 -> {
                JBScrollPane var4_4;
                JBScrollPane $this$createMarkdownRenderer_u24lambda_u2415 = var4_4 = new JBScrollPane((Component)new JupyterMarkdownHtmlPane(editor, markdownText));
                boolean $i$a$-apply-MarkdownEditorCellViewComponent$createMarkdownRenderer$1 = false;
                $this$createMarkdownRenderer_u24lambda_u2415.setBorder(BorderFactory.createEmptyBorder());
                yield TuplesKt.to((Object)var4_4, null);
            }
            case 2 -> {
                ObjectNode node = new ObjectNode(new JsonNodeFactory(false));
                ArrayNode mdField = node.putArray("text/markdown");
                mdField.add(markdownText);
                JupyterWebOutputApi outputApi = JupyterWebOutputApi.Companion.getJupyterWebOutputApi((Editor)editor);
                String v1 = node.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                String var8_10 = v1;
                String var9_11 = outputApi.createOutputId();
                NotebookCellLines.Interval v2 = intervalPointer.get();
                Intrinsics.checkNotNull((Object)v2);
                int var10_12 = v2.getOrdinal();
                JupyterWebOutputInfo.Output outputInfo = new JupyterWebOutputInfo.Output(var8_10, var9_11, var10_12, 0, false);
                yield JupyterWebOutputApi.Companion.getJupyterWebOutputApi((Editor)editor).createComponent(outputInfo);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void switchPresentation(boolean rendered) {
        UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.switchPresentation$lambda$16(rendered, this, arg_0), (int)1, null);
    }

    public final void switchToRenderedPresentation(@NotNull UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ActionsKt.runInEdt$default(null, () -> MarkdownEditorCellViewComponent.switchToRenderedPresentation$lambda$18(this, ctx), (int)1, null);
    }

    public final void switchToTextPresentation(@NotNull UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ActionsKt.runInEdt$default(null, () -> MarkdownEditorCellViewComponent.switchToTextPresentation$lambda$20(this, ctx), (int)1, null);
    }

    public void updateInput(@NotNull UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ActionsKt.runInEdt$default(null, () -> MarkdownEditorCellViewComponent.updateInput$lambda$22(this, ctx), (int)1, null);
    }

    private final <T extends EditorCellViewComponent> T replaceCurrentComponent(UpdateContext ctx, Function0<? extends T> componentFactory) {
        EditorCellViewComponent current = this.getComponent();
        if (current != null) {
            this.remove(current);
        }
        EditorCellViewComponent newComponent = (EditorCellViewComponent)componentFactory.invoke();
        this.add(newComponent);
        newComponent.updateCellFolding(ctx);
        return (T)newComponent;
    }

    private final TextEditorCellViewComponent createTextComponent() {
        MarkdownEditorCell markdownEditorCell;
        TextEditorCellViewComponent textEditorCellViewComponent;
        TextEditorCellViewComponent it = textEditorCellViewComponent = new TextEditorCellViewComponent((EditorEx)this.editor, this.cell);
        boolean bl = false;
        MarkdownEditorCell markdownEditorCell2 = this.markdownEditorCell;
        this.updateView((EditorCellViewComponent)it, markdownEditorCell2 != null ? markdownEditorCell2.getSection() : null, (markdownEditorCell = this.markdownEditorCell) != null && (markdownEditorCell = markdownEditorCell.getSectionFolded()) != null ? markdownEditorCell.get().booleanValue() : false);
        return textEditorCellViewComponent;
    }

    private final CustomFoldingEditorCellViewComponent createFoldingComponent() {
        CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent;
        block0: {
            MarkdownEditorCell markdownEditorCell;
            Pair<JLayer<JComponent>, Disposable> pair = this.createComponent();
            JLayer rendererComponent = (JLayer)pair.component1();
            Disposable rendererDisposable = (Disposable)pair.component2();
            CustomFoldingEditorCellViewComponent it = customFoldingEditorCellViewComponent = new CustomFoldingEditorCellViewComponent((JComponent)rendererComponent, (EditorEx)this.editor, this.cell);
            boolean bl = false;
            MarkdownEditorCell markdownEditorCell2 = this.markdownEditorCell;
            this.updateView((EditorCellViewComponent)it, markdownEditorCell2 != null ? markdownEditorCell2.getSection() : null, (markdownEditorCell = this.markdownEditorCell) != null && (markdownEditorCell = markdownEditorCell.getSectionFolded()) != null ? markdownEditorCell.get().booleanValue() : false);
            CustomFoldingEditorCellViewComponent component2 = customFoldingEditorCellViewComponent;
            boolean bl2 = false;
            Disposable disposable = rendererDisposable;
            if (disposable == null) break block0;
            Disposable it2 = disposable;
            boolean bl3 = false;
            Disposer.register((Disposable)((Disposable)component2), (Disposable)it2);
        }
        return customFoldingEditorCellViewComponent;
    }

    public final void browserClicked(int clickCount) {
        if (clickCount > 1 && JupyterMarkdownHelperKt.getMarkdownRendered(this.cell)) {
            JupyterMarkdownHelperKt.setMarkdownRendered(this.cell, false);
            NotebookEditorModeKt.setMode((Editor)((Editor)this.editor), (NotebookEditorMode)NotebookEditorMode.EDIT);
            this.editor.getSettings().setCaretRowShown(true);
        } else {
            this.cell.requestCaret();
        }
    }

    public void updateFolding(@NotNull UpdateContext ctx, boolean folded) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        EditorCellViewComponent currentComponent = this.getComponent();
        if (folded) {
            TextEditorCellViewComponent textEditorCellViewComponent = currentComponent instanceof TextEditorCellViewComponent ? (TextEditorCellViewComponent)currentComponent : null;
            if (textEditorCellViewComponent == null) {
                textEditorCellViewComponent = (TextEditorCellViewComponent)this.replaceCurrentComponent(ctx, () -> MarkdownEditorCellViewComponent.updateFolding$lambda$27(this));
            }
            TextEditorCellViewComponent textComponent = textEditorCellViewComponent;
            textComponent.updateFolding(ctx, true);
        } else {
            if (currentComponent instanceof CustomFoldingEditorCellViewComponent) {
                return;
            }
            this.replaceCurrentComponent(ctx, () -> MarkdownEditorCellViewComponent.updateFolding$lambda$28(this));
        }
    }

    public void requestCaret() {
        IntRange lines = this.cell.getInterval().getLines();
        int offset = this.editor.getDocument().getLineStartOffset(lines.getFirst() + 1);
        this.editor.getCaretModel().moveToOffset(offset);
    }

    private static final CustomFoldingEditorCellViewComponent lambda$1$lambda$0(MarkdownEditorCellViewComponent this$0) {
        return this$0.createFoldingComponent();
    }

    private static final CustomFoldingEditorCellViewComponent _init_$lambda$1(MarkdownEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (CustomFoldingEditorCellViewComponent)this$0.replaceCurrentComponent(ctx, () -> MarkdownEditorCellViewComponent.lambda$1$lambda$0(this$0));
    }

    private static final Unit lambda$5$lambda$3(MarkdownEditorCellViewComponent this$0, boolean sectionFolded) {
        block0: {
            EditorCellViewComponent editorCellViewComponent = this$0.getComponent();
            if (editorCellViewComponent == null) break block0;
            EditorCellViewComponent it = editorCellViewComponent;
            boolean bl = false;
            this$0.updateView(it, this$0.markdownEditorCell.getSection(), sectionFolded);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4(MarkdownEditorCellViewComponent this$0, boolean rendered) {
        this$0.switchPresentation(rendered);
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$9$lambda$8$lambda$6(int $startLine, int $lastLine, MarkdownEditorCellViewComponent this$0, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        CustomFoldRegion region2 = foldingModel.addCustomLinesFolding($startLine, $lastLine, new CustomFoldRegionRenderer(){

            public int calcWidthInPixels(CustomFoldRegion region2) {
                Intrinsics.checkNotNullParameter((Object)region2, (String)"region");
                return 1;
            }

            public int calcHeightInPixels(CustomFoldRegion region2) {
                Intrinsics.checkNotNullParameter((Object)region2, (String)"region");
                return 1;
            }

            public void paint(CustomFoldRegion region2, Graphics2D g, Rectangle2D targetRegion, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter((Object)region2, (String)"region");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            }
        });
        if (region2 != null) {
            region2.putUserData(NotebookCellInlayManager.Companion.getFOLDING_MARKER_KEY(), (Object)true);
            this$0.foldedRegion = (FoldRegion)region2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$9$lambda$8$lambda$7(MarkdownEditorCellViewComponent this$0, MouseEvent mouseEvent, Point point) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
            Object object = this$0.markdownEditorCell;
            if (object == null || (object = ((MarkdownEditorCell)object).getSection()) == null) break block0;
            ((NotebookStructureElement.NotebookSection)object).unfold();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$9$lambda$8(NotebookStructureElement.NotebookSection $section, MarkdownEditorCellViewComponent this$0, EditorCellViewComponent $component, UpdateContext ctx) {
        EditorCell lastCell;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        NotebookStructureElement notebookStructureElement = (NotebookStructureElement)CollectionsKt.firstOrNull($section.getChildren());
        EditorCell firstCell = notebookStructureElement != null ? notebookStructureElement.getFirst() : null;
        NotebookStructureElement notebookStructureElement2 = (NotebookStructureElement)CollectionsKt.lastOrNull($section.getChildren());
        Object object = lastCell = notebookStructureElement2 != null ? notebookStructureElement2.getLast() : null;
        if (firstCell != null && lastCell != null) {
            InlayPresentation presentation;
            int startLine = firstCell.getInterval().getLines().getFirst();
            int lastLine = lastCell.getInterval().getLines().getLast();
            ctx.addFoldingOperation(arg_0 -> MarkdownEditorCellViewComponent.updateView$lambda$9$lambda$8$lambda$6(startLine, lastLine, this$0, arg_0));
            this$0.removeExistingHiddenCellHint();
            PresentationFactory factory2 = new PresentationFactory((Editor)this$0.editor);
            Object[] objectArray = new Object[]{$section.getSize()};
            InlayPresentation inlayPresentation = factory2.smallText(JupyterBundle.message("jupyter.folding.cells.hidden", objectArray));
            Cursor cursor = Cursor.getPredefinedCursor(12);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
            this$0.contributedPresentation = presentation = factory2.onClick(factory2.withCursorOnHover(inlayPresentation, cursor), MouseButton.Left, (arg_0, arg_1) -> MarkdownEditorCellViewComponent.updateView$lambda$9$lambda$8$lambda$7(this$0, arg_0, arg_1));
            $component.addInlayBelow(presentation);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$9(boolean $sectionFolded, NotebookStructureElement.NotebookSection $section, MarkdownEditorCellViewComponent this$0, EditorCellViewComponent $component) {
        if ($sectionFolded) {
            if ($section != null && $section.isNotEmpty()) {
                UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this$0.editor)), (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.updateView$lambda$9$lambda$8($section, this$0, $component, arg_0), (int)1, null);
            }
        } else {
            this$0.unfold();
        }
        if (this$0.foldingEnabled && $section != null) {
            if ($sectionFolded) {
                this$0.cell.setGutterAction((AnAction)new UnfoldAction(this$0.cell));
            } else {
                this$0.cell.setGutterAction((AnAction)new FoldAction(this$0.cell));
            }
        } else {
            this$0.cell.setGutterAction(null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit unfold$lambda$10(MarkdownEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.removeHeadingFolding(ctx);
        this$0.removeExistingHiddenCellHint();
        return Unit.INSTANCE;
    }

    private static final Unit removeHeadingFolding$lambda$11(MarkdownEditorCellViewComponent this$0, FoldRegion $foldRegion, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        this$0.removeExistingRegion(foldingModel, $foldRegion);
        return Unit.INSTANCE;
    }

    private static final Unit dispose$lambda$13(MarkdownEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.removeHeadingFolding(ctx);
        return Unit.INSTANCE;
    }

    private static final Unit switchPresentation$lambda$16(boolean $rendered, MarkdownEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if ($rendered) {
            this$0.switchToRenderedPresentation(ctx);
        } else {
            this$0.switchToTextPresentation(ctx);
        }
        return Unit.INSTANCE;
    }

    private static final CustomFoldingEditorCellViewComponent switchToRenderedPresentation$lambda$18$lambda$17(MarkdownEditorCellViewComponent this$0) {
        return this$0.createFoldingComponent();
    }

    private static final Unit switchToRenderedPresentation$lambda$18(MarkdownEditorCellViewComponent this$0, UpdateContext $ctx) {
        if (this$0.getComponent() instanceof CustomFoldingEditorCellViewComponent) {
            return Unit.INSTANCE;
        }
        this$0.replaceCurrentComponent($ctx, () -> MarkdownEditorCellViewComponent.switchToRenderedPresentation$lambda$18$lambda$17(this$0));
        return Unit.INSTANCE;
    }

    private static final TextEditorCellViewComponent switchToTextPresentation$lambda$20$lambda$19(MarkdownEditorCellViewComponent this$0) {
        return this$0.createTextComponent();
    }

    private static final Unit switchToTextPresentation$lambda$20(MarkdownEditorCellViewComponent this$0, UpdateContext $ctx) {
        if (this$0.getComponent() instanceof TextEditorCellViewComponent) {
            return Unit.INSTANCE;
        }
        this$0.replaceCurrentComponent($ctx, () -> MarkdownEditorCellViewComponent.switchToTextPresentation$lambda$20$lambda$19(this$0));
        return Unit.INSTANCE;
    }

    private static final CustomFoldingEditorCellViewComponent updateInput$lambda$22$lambda$21(MarkdownEditorCellViewComponent this$0) {
        return this$0.createFoldingComponent();
    }

    private static final Unit updateInput$lambda$22(MarkdownEditorCellViewComponent this$0, UpdateContext $ctx) {
        if (this$0.getComponent() instanceof CustomFoldingEditorCellViewComponent) {
            this$0.replaceCurrentComponent($ctx, () -> MarkdownEditorCellViewComponent.updateInput$lambda$22$lambda$21(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final TextEditorCellViewComponent updateFolding$lambda$27(MarkdownEditorCellViewComponent this$0) {
        return new TextEditorCellViewComponent((EditorEx)this$0.editor, this$0.cell);
    }

    private static final CustomFoldingEditorCellViewComponent updateFolding$lambda$28(MarkdownEditorCellViewComponent this$0) {
        return this$0.createFoldingComponent();
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(MarkdownEditorCellViewComponent $this) {
        return $this.editor;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterDSSettings.MarkdownRenderMode.values().length];
            try {
                nArray[JupyterDSSettings.MarkdownRenderMode.SWING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterDSSettings.MarkdownRenderMode.NOTEBOOK_CEF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

