/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.fus.JupyterFeatureCollectorManager;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorCustomizer;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.helper.OtherKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.JComponentFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createJupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkEditorAndPsi", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "disposeEditor", "onEditorDispose", "moveCaret", "textEditor", "accept", "", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileEditorProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n1863#2,2:124\n1#3:126\n24#4:127\n*S KotlinDebug\n*F\n+ 1 JupyterFileEditorProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider\n*L\n59#1:124,2\n84#1:127\n*E\n"})
public abstract class JupyterFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    public abstract JupyterFileEditor createJupyterFileEditor(@NotNull Project var1, @NotNull BackedNotebookVirtualFile var2);

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        JupyterFileEditor jupyterFileEditor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        BackedNotebookVirtualFile notebookSourceFile = BackedNotebookVirtualFile.Companion.takeOrFind(file);
        JupyterFeatureCollectorManager.Companion.getInstance().startLoadNotebook(file);
        try {
            BackedNotebookVirtualFile backedNotebookVirtualFile = notebookSourceFile;
            Intrinsics.checkNotNull((Object)backedNotebookVirtualFile);
            jupyterFileEditor = this.createJupyterFileEditor(project, backedNotebookVirtualFile);
        }
        catch (Throwable throwable) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JLabel(JupyterBundle.message("jupyter.corrupted.file.message", new Object[0]), 0), "Center");
            return (FileEditor)new JComponentFileEditor(file, (JComponent)panel2);
        }
        JupyterFileEditor editor = jupyterFileEditor;
        if (!JupyterConsoleUtil.INSTANCE.isNotebookViewerMode(file)) {
            Disposer.register((Disposable)NotebookDisposable.Companion.forProject(project), (Disposable)((Disposable)editor));
        }
        this.moveCaret(editor);
        Iterable $this$forEach$iv = JupyterEditorCustomizer.Companion.getEP().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterEditorCustomizer customizer = (JupyterEditorCustomizer)element$iv;
            boolean bl = false;
            customizer.onEditorCreated(project, editor, notebookSourceFile);
        }
        jupyterFileEditor = editor.getEditor().getProject();
        if (jupyterFileEditor != null) {
            JupyterFileEditor it = jupyterFileEditor;
            boolean bl = false;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)it);
            if (psiDocumentManager != null) {
                psiDocumentManager.performForCommittedDocument(editor.getEditor().getDocument(), () -> JupyterFileEditorProvider.createEditor$lambda$2(this, editor, notebookSourceFile));
            }
        }
        file.putUserData(OtherKt.getJUPYTER_EDITOR_KEY(), new WeakReference<Editor>(editor.getEditor()));
        file.putUserData(OtherKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), (Object)notebookSourceFile);
        return (FileEditor)editor;
    }

    private final void checkEditorAndPsi(Editor editor, JupyterNotebook notebook) {
        Project project = editor.getProject();
        if (!(project != null)) {
            boolean $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$32 = false;
            String $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$32 = "project must be not null";
            throw new IllegalStateException($i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$32.toString());
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (!(psiFile instanceof JupyterFile)) {
            boolean $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$42 = false;
            String $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$42 = "psi file must be Jupyter File, but it isn't. The actual value is: " + psiFile;
            throw new IllegalStateException($i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$42.toString());
        }
        List intervals = (List)ActionsKt.runReadAction(() -> JupyterFileEditorProvider.checkEditorAndPsi$lambda$5(editor));
        if (notebook.cellsCount() != intervals.size()) {
            JupyterFileEditorProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileEditorProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("size of intervals should be equal to the size of nb cells");
        }
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super.disposeEditor(editor);
        VirtualFile virtualFile = editor.getFile();
        if (virtualFile != null && (virtualFile = JupyterFileExtensionsKt.getOriginalVirtualFile(virtualFile)) != null) {
            virtualFile.putUserData(OtherKt.getJUPYTER_EDITOR_KEY(), null);
        }
        if (editor instanceof TextEditor) {
            Editor editor2 = ((TextEditor)editor).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            this.onEditorDispose(editor2);
        }
    }

    private final void onEditorDispose(Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JupyterInlayProgressStatusManager.Companion.getInstance(project2).disposeEditor(editor);
    }

    private final void moveCaret(JupyterFileEditor textEditor) {
        JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(textEditor, null){
            int label;
            final /* synthetic */ JupyterFileEditor $textEditor;
            {
                this.$textEditor = $textEditor;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!this.$textEditor.isValid()) {
                            return Unit.INSTANCE;
                        }
                        Editor editor = this.$textEditor.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        Editor editor2 = editor;
                        List<NotebookCellLines.Interval> list = JupyterHelper.INSTANCE.getCellIntervals(editor2);
                        if (list == null) {
                            return Unit.INSTANCE;
                        }
                        List<NotebookCellLines.Interval> cells = list;
                        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull(cells, (int)0);
                        if (interval == null) {
                            return Unit.INSTANCE;
                        }
                        NotebookCellLines.Interval firstCell = interval;
                        int offset = firstCell.getContentRange(editor2).getStartOffset();
                        this.label = 1;
                        Object object3 = CoroutinesKt.writeIntentReadAction(() -> moveCaret.1.invokeSuspend$lambda$0(editor2, offset), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Editor $editor, int $offset) {
                $editor.getCaretModel().getPrimaryCaret().moveToOffset($offset);
                return Unit.INSTANCE;
            }
        }));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getFileType() == JupyterFileType.INSTANCE;
    }

    @NotNull
    public String getEditorTypeId() {
        return "jupyter-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (FileEditorState)new TextEditorState();
    }

    private static final void createEditor$lambda$2(JupyterFileEditorProvider this$0, JupyterFileEditor $editor, BackedNotebookVirtualFile $notebookSourceFile) {
        Editor editor = $editor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        this$0.checkEditorAndPsi(editor, $notebookSourceFile.getNotebook());
    }

    private static final List checkEditorAndPsi$lambda$5(Editor $editor) {
        return NotebookCellLines.Companion.get($editor).getIntervals();
    }
}

