/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.debugger.common;

import com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineDebugRendererBase;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineTreeInlayPopup;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineValuePopupProvider;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\u000bH\u0015J\b\u0010\"\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f8\u0014X\u0095\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterInlineDebugRenderer;", "Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterInlineDebugRendererBase;", "valueNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/xdebugger/XDebugSession;)V", "isDark", "", "customNode", "name", "", "Lorg/jetbrains/annotations/Nullable;", "getName", "()Ljava/lang/String;", "presentation", "Lcom/intellij/ui/SimpleColoredText;", "popupIsShown", "treeCreator", "Lcom/intellij/xdebugger/impl/evaluate/quick/XDebuggerTreeCreator;", "onClick", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "handleClick", "getPresentation", "isCustomNode", "isErrorMessage", "calculateIsInExecutionPoint", "updatePresentation", "Companion", "intellij.jupyter.core"})
@ApiStatus.Internal
public class JupyterInlineDebugRenderer
extends JupyterInlineDebugRendererBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XValueNodeImpl valueNode;
    @NotNull
    private final XSourcePosition position;
    @NotNull
    private final XDebugSession session;
    private final boolean isDark;
    private final boolean customNode;
    @Nls
    @Nullable
    private final String name;
    private SimpleColoredText presentation;
    private boolean popupIsShown;
    @NotNull
    private XDebuggerTreeCreator treeCreator;
    @NotNull
    public static final String ID = "JupyterInlayDebugRenderer";
    private static final TextAttributesKey ATTRIBUTES_KEY = DebuggerColors.INLINED_VALUES;
    @NotNull
    private static final Color NORMAL_DARK_COLOR = new Color(4030565);

    public JupyterInlineDebugRenderer(@NotNull XValueNodeImpl valueNode, @NotNull XSourcePosition position, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)valueNode, (String)"valueNode");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.valueNode = valueNode;
        this.position = position;
        this.session = session;
        this.isDark = EditorColorsManager.getInstance().isDarkEditor();
        this.customNode = this.valueNode instanceof InlineWatchNodeImpl;
        this.name = this.valueNode.getName();
        XValueMarkers markers = this.session instanceof XDebugSessionImpl ? ((XDebugSessionImpl)this.session).getValueMarkers() : null;
        this.treeCreator = new XDebuggerTreeCreator(this.session.getProject(), this.session.getDebugProcess().getEditorsProvider(), this.session.getCurrentPosition(), markers);
        this.updatePresentation();
    }

    @Override
    @Nullable
    protected String getName() {
        return this.name;
    }

    public void onClick(@NotNull Inlay<?> inlay, @NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.customNode && event.getMouseEvent().getX() > this.myRemoveXCoordinate) {
            XDebugSession xDebugSession = this.session;
            Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
            XDebugSessionTab xDebugSessionTab = ((XDebugSessionImpl)xDebugSession).getSessionTab();
            if (xDebugSessionTab != null && (xDebugSessionTab = xDebugSessionTab.getWatchesView()) != null) {
                xDebugSessionTab.removeWatches(Collections.singletonList(this.valueNode));
            }
            inlay.update();
        } else if (event.getMouseEvent().getX() >= this.myTextStartXCoordinate) {
            this.handleClick(inlay);
        }
    }

    private final void handleClick(Inlay<?> inlay) {
        Rectangle bounds;
        JupyterVarsCollector.INSTANCE.getCLICK_INLINE_CURRENT_LINE_EVENT().log();
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineDebugRenderer");
        JupyterInlineDebugRenderer inlayRenderer = (JupyterInlineDebugRenderer)editorCustomElementRenderer;
        if (inlayRenderer.popupIsShown) {
            return;
        }
        Pair pair = InlineDebugRenderer.getXValueDescriptor((XValueNodeImpl)this.valueNode);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getXValueDescriptor(...)");
        Pair descriptor = pair;
        Rectangle rectangle = bounds = inlay.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        Point point = new Point(rectangle.x, bounds.y + bounds.height);
        inlayRenderer.popupIsShown = true;
        Runnable hidePopupRunnable = () -> JupyterInlineDebugRenderer.handleClick$lambda$1(inlayRenderer);
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        InlineValuePopupProvider popupProvider = (InlineValuePopupProvider)InlineValuePopupProvider.EP_NAME.findFirstSafe(arg_0 -> JupyterInlineDebugRenderer.handleClick$lambda$3(arg_0 -> JupyterInlineDebugRenderer.handleClick$lambda$2(this, arg_0), arg_0));
        if (popupProvider != null) {
            popupProvider.showPopup(this.valueNode, this.session, this.position, this.treeCreator, editor2, point, hidePopupRunnable);
        } else {
            DebuggerTreeCreator debuggerTreeCreator = (DebuggerTreeCreator)this.treeCreator;
            Project project = editor2.getProject();
            Intrinsics.checkNotNull((Object)project);
            JupyterInlineTreeInlayPopup.Companion.showTreePopup(debuggerTreeCreator, descriptor, editor2, point, project, hidePopupRunnable);
        }
    }

    @NotNull
    public SimpleColoredText getPresentation() {
        SimpleColoredText simpleColoredText = this.presentation;
        if (simpleColoredText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presentation");
            simpleColoredText = null;
        }
        return simpleColoredText;
    }

    public boolean isCustomNode() {
        return this.customNode;
    }

    public boolean isErrorMessage() {
        return Intrinsics.areEqual((Object)XDebuggerUIConstants.ERROR_MESSAGE_ICON, (Object)this.valueNode.getIcon());
    }

    @Override
    @RequiresBackgroundThread
    protected boolean calculateIsInExecutionPoint() {
        return true;
    }

    private final void updatePresentation() {
        JBColor jBColor = JBColor.lazy(() -> JupyterInlineDebugRenderer.updatePresentation$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        JBColor color = jBColor;
        TextAttributes attributes = new TextAttributes((Color)color, null, null, null, 2);
        SimpleColoredText text = new SimpleColoredText();
        String string = this.getName();
        if (string == null) {
            string = "";
        }
        text.append(string, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
        this.presentation = text;
    }

    private static final void handleClick$lambda$1$lambda$0(JupyterInlineDebugRenderer $inlayRenderer) {
        $inlayRenderer.popupIsShown = false;
    }

    private static final void handleClick$lambda$1(JupyterInlineDebugRenderer $inlayRenderer) {
        ApplicationManager.getApplication().invokeLater(() -> JupyterInlineDebugRenderer.handleClick$lambda$1$lambda$0($inlayRenderer));
    }

    private static final boolean handleClick$lambda$2(JupyterInlineDebugRenderer this$0, InlineValuePopupProvider a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return a.accepts(this$0.valueNode);
    }

    private static final boolean handleClick$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Color updatePresentation$lambda$4(JupyterInlineDebugRenderer this$0) {
        return this$0.isDark ? NORMAL_DARK_COLOR : (Color)Gray._135;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterInlineDebugRenderer$Companion;", "", "<init>", "()V", "ID", "", "ATTRIBUTES_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "kotlin.jvm.PlatformType", "getATTRIBUTES_KEY$intellij_jupyter_core", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "NORMAL_DARK_COLOR", "Ljava/awt/Color;", "getNORMAL_DARK_COLOR$annotations", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final TextAttributesKey getATTRIBUTES_KEY$intellij_jupyter_core() {
            return ATTRIBUTES_KEY;
        }

        private static /* synthetic */ void getNORMAL_DARK_COLOR$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

