/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.BytesWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageChannel;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageHeader;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageHeaderBase;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageId;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterProtocolSchema;
import com.intellij.jupyter.core.jupyter.connections.execution.message.StringWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.WebSocketMessage;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAwareBase;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0016J\u0006\u0010\u0015\u001a\u00020\u0004J\b\u0010*\u001a\u00020+H\u0016J \u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-H\u0086\b\u00f8\u0001\u0000J\b\u00100\u001a\u00020/H\u0016J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u000206H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR$\u0010 \u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020$8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00068"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadataAwareBase;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "buffers", "", "", "schema", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterProtocolSchema;", "<init>", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/util/List;Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterProtocolSchema;)V", "getJson", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getBuffers", "()Ljava/util/List;", "getSchema$intellij_jupyter_core", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterProtocolSchema;", "content", "getContent", "getMetadata", "createMetadata", "value", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageHeader;", "header", "getHeader", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageHeader;", "setHeader", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageHeader;)V", "parentHeader", "getParentHeader", "setParentHeader", "messageContent", "getMessageContent", "setMessageContent", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "channel", "getChannel", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "setChannel", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;)V", "serialize", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/WebSocketMessage;", "jsonSerializer", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/JsonNode;", "", "toString", "equals", "", "other", "", "hashCode", "", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterMessageBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterMessageBase.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n69#1,13:209\n82#1,19:223\n1#2:222\n1#2:242\n*S KotlinDebug\n*F\n+ 1 JupyterMessageBase.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageBase\n*L\n65#1:209,13\n65#1:223,19\n65#1:222\n*E\n"})
public class JupyterMessageBase
extends JupyterMetadataAwareBase
implements JupyterMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectNode json;
    @NotNull
    private final List<byte[]> buffers;
    @NotNull
    private final JupyterProtocolSchema schema;
    @NotNull
    private final ObjectNode content;

    public JupyterMessageBase(@NotNull ObjectNode json, @NotNull List<byte[]> buffers, @NotNull JupyterProtocolSchema schema) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.json = json;
        this.buffers = buffers;
        this.schema = schema;
        this.content = this.json;
        this.getOrCreateMetadata();
    }

    @Override
    @NotNull
    public final ObjectNode getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public List<byte[]> getBuffers() {
        return this.buffers;
    }

    @NotNull
    public final JupyterProtocolSchema getSchema$intellij_jupyter_core() {
        return this.schema;
    }

    @Override
    @NotNull
    protected ObjectNode getContent() {
        return this.content;
    }

    @Override
    @Nullable
    public ObjectNode getMetadata() {
        JsonNode jsonNode = this.getContent().get("metadata");
        return jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
    }

    @Override
    @NotNull
    public final ObjectNode createMetadata() {
        ObjectNode objectNode = this.getContent().putObject("metadata");
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"putObject(...)");
        return objectNode;
    }

    @Override
    @NotNull
    public JupyterMessageHeader getHeader() {
        JsonNode jsonNode = this.json.get(this.schema.getHeaderFieldName());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        return new JupyterMessageHeaderBase((ObjectNode)jsonNode, new JupyterProtocolSchema.JupyterProtocolHeaderSchema(this.schema));
    }

    public void setHeader(@NotNull JupyterMessageHeader value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.json.set(this.schema.getHeaderFieldName(), (JsonNode)value.getJson());
    }

    @Override
    @Nullable
    public JupyterMessageHeader getParentHeader() {
        JsonNode parentHeaderJson = this.json.get(this.schema.getParentHeaderFieldName());
        if (parentHeaderJson instanceof ObjectNode && !((ObjectNode)parentHeaderJson).isEmpty()) {
            return new JupyterMessageHeaderBase((ObjectNode)parentHeaderJson, new JupyterProtocolSchema.JupyterProtocolHeaderSchema(this.schema));
        }
        return null;
    }

    public void setParentHeader(@Nullable JupyterMessageHeader value) {
        String string = this.schema.getParentHeaderFieldName();
        JupyterMessageHeader jupyterMessageHeader = value;
        if (jupyterMessageHeader == null || (jupyterMessageHeader = jupyterMessageHeader.getJson()) == null) {
            jupyterMessageHeader = JupyterJsonKt.getJackson().createObjectNode();
        }
        this.json.set(string, (JsonNode)jupyterMessageHeader);
    }

    @Override
    @NotNull
    public ObjectNode getMessageContent() {
        JsonNode jsonNode = this.json.get(this.schema.getContentFieldName());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        return (ObjectNode)jsonNode;
    }

    public void setMessageContent(@NotNull ObjectNode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.json.set(this.schema.getContentFieldName(), (JsonNode)value);
    }

    @Override
    @NotNull
    public JupyterMessageChannel getChannel() {
        String it = this.json.get(this.schema.getChannelFieldsName()).asText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return JupyterMessageChannel.Companion.byValue(it);
    }

    public void setChannel(@NotNull JupyterMessageChannel value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.json.put("channel", value.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WebSocketMessage serialize() {
        WebSocketMessage webSocketMessage;
        void this_$iv;
        JupyterMessageBase jupyterMessageBase = this;
        ObjectMapper objectMapper = JupyterJsonKt.getJackson();
        boolean $i$f$serialize = false;
        ObjectNode p0 = this_$iv.getJson();
        boolean $i$f$serialize$stub_for_inlining = false;
        boolean bl = false;
        String jsonString$iv = objectMapper.writeValueAsString((Object)p0);
        if (this_$iv.getBuffers().isEmpty()) {
            webSocketMessage = new StringWebSocketMessage(jsonString$iv);
        } else {
            ByteBuffer resultBuffer$iv;
            int n;
            byte[] byArray = jsonString$iv.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] jsonBytes$iv = byArray;
            int contentStart$iv = 4 * (2 + this_$iv.getBuffers().size());
            Iterable iterable = this_$iv.getBuffers();
            int n2 = contentStart$iv + jsonBytes$iv.length;
            int n3 = 0;
            for (Object t : iterable) {
                void it$iv;
                byte[] byArray2 = (byte[])t;
                n = n3;
                boolean bl2 = false;
                int n4 = ((void)it$iv).length;
                n3 = n + n4;
            }
            n = n3;
            ByteBuffer $this$serialize_u24lambda_u243$iv = resultBuffer$iv = ByteBuffer.allocate(n2 + n);
            boolean bl3 = false;
            $this$serialize_u24lambda_u243$iv.order(ByteOrder.BIG_ENDIAN);
            $this$serialize_u24lambda_u243$iv.putInt(this_$iv.getBuffers().size() + 1);
            ByteBuffer $this$serialize_u24lambda_u243_u24lambda_u242$iv = $this$serialize_u24lambda_u243$iv;
            boolean bl4 = false;
            int offset$iv = contentStart$iv;
            $this$serialize_u24lambda_u243_u24lambda_u242$iv.putInt(offset$iv);
            offset$iv += jsonBytes$iv.length;
            for (byte[] buffer$iv : this_$iv.getBuffers()) {
                $this$serialize_u24lambda_u243_u24lambda_u242$iv.putInt(offset$iv);
                offset$iv += buffer$iv.length;
            }
            $this$serialize_u24lambda_u243$iv.put(jsonBytes$iv);
            for (byte[] buffer$iv : this_$iv.getBuffers()) {
                $this$serialize_u24lambda_u243$iv.put(buffer$iv);
            }
            $this$serialize_u24lambda_u243$iv.rewind();
            Intrinsics.checkNotNull((Object)resultBuffer$iv);
            webSocketMessage = new BytesWebSocketMessage(resultBuffer$iv);
        }
        return webSocketMessage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WebSocketMessage serialize(@NotNull Function1<? super JsonNode, String> jsonSerializer) {
        ByteBuffer resultBuffer;
        int n;
        Intrinsics.checkNotNullParameter(jsonSerializer, (String)"jsonSerializer");
        boolean $i$f$serialize = false;
        String jsonString = (String)jsonSerializer.invoke((Object)this.getJson());
        if (this.getBuffers().isEmpty()) {
            return new StringWebSocketMessage(jsonString);
        }
        String string = jsonString;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] jsonBytes = byArray;
        int contentStart = 4 * (2 + this.getBuffers().size());
        Iterable iterable = this.getBuffers();
        int n2 = contentStart + jsonBytes.length;
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            byte[] byArray2 = (byte[])t;
            n = n3;
            boolean bl = false;
            int n4 = ((void)it).length;
            n3 = n + n4;
        }
        n = n3;
        ByteBuffer $this$serialize_u24lambda_u243 = resultBuffer = ByteBuffer.allocate(n2 + n);
        boolean bl = false;
        $this$serialize_u24lambda_u243.order(ByteOrder.BIG_ENDIAN);
        $this$serialize_u24lambda_u243.putInt(this.getBuffers().size() + 1);
        ByteBuffer $this$serialize_u24lambda_u243_u24lambda_u242 = $this$serialize_u24lambda_u243;
        boolean bl2 = false;
        int offset = contentStart;
        $this$serialize_u24lambda_u243_u24lambda_u242.putInt(offset);
        offset += jsonBytes.length;
        for (byte[] buffer : this.getBuffers()) {
            $this$serialize_u24lambda_u243_u24lambda_u242.putInt(offset);
            offset += buffer.length;
        }
        $this$serialize_u24lambda_u243.put(jsonBytes);
        for (byte[] buffer : this.getBuffers()) {
            $this$serialize_u24lambda_u243.put(buffer);
        }
        $this$serialize_u24lambda_u243.rewind();
        Intrinsics.checkNotNull((Object)resultBuffer);
        return new BytesWebSocketMessage(resultBuffer);
    }

    @NotNull
    public String toString() {
        return "JupyterMessage: " + JupyterJsonKt.getJackson().writeValueAsString((Object)this.json);
    }

    public boolean equals(@Nullable Object other) {
        String string = this.getHeader().getMessageId-j9c_AtQ();
        Object object = other instanceof JupyterMessage ? (JupyterMessage)other : null;
        String string2 = object != null && (object = object.getHeader()) != null ? object.getMessageId-j9c_AtQ() : null;
        return string2 == null ? false : JupyterMessageId.equals-impl0(string, string2);
    }

    public int hashCode() {
        return JupyterMessageId.hashCode-impl(this.getHeader().getMessageId-j9c_AtQ());
    }

    @JvmStatic
    @NotNull
    public static final JupyterMessage parse(@NotNull WebSocketMessage content, @NotNull JupyterProtocolSchema schema) {
        return Companion.parse(content, schema);
    }

    @JvmStatic
    private static final int[] readOffsets(IntBuffer intBuffer) {
        return JupyterMessageBase.Companion.readOffsets(intBuffer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageBase$Companion;", "", "<init>", "()V", "parse", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "content", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/WebSocketMessage;", "schema", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterProtocolSchema;", "readOffsets", "", "intBuffer", "Ljava/nio/IntBuffer;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterMessage parse(@NotNull WebSocketMessage content, @NotNull JupyterProtocolSchema schema) {
            JupyterMessage jupyterMessage;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            WebSocketMessage webSocketMessage = content;
            if (webSocketMessage instanceof StringWebSocketMessage) {
                Object object = JupyterJsonKt.getJackson().readValue(((StringWebSocketMessage)content).getString(), ObjectNode.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                jupyterMessage = new JupyterMessageBase((ObjectNode)object, CollectionsKt.emptyList(), schema);
            } else if (webSocketMessage instanceof BytesWebSocketMessage) {
                ByteBuffer $this$parse_u24lambda_u242 = ((BytesWebSocketMessage)content).getBytes();
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)$this$parse_u24lambda_u242.order(), (Object)ByteOrder.BIG_ENDIAN);
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                IntBuffer intBuffer = $this$parse_u24lambda_u242.asIntBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"asIntBuffer(...)");
                int[] offsets = Companion.readOffsets(intBuffer);
                offsets[offsets.length - 1] = ((BytesWebSocketMessage)content).getBytes().limit();
                List buffers = SequencesKt.toList((Sequence)SequencesKt.zipWithNext((Sequence)ArraysKt.asSequence((int[])offsets), (arg_0, arg_1) -> Companion.parse$lambda$2$lambda$0(content, arg_0, arg_1)));
                ObjectMapper objectMapper = JupyterJsonKt.getJackson();
                Object e = buffers.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Object object = objectMapper.readValue(IoKt.toByteArray$default((ByteBuffer)((ByteBuffer)e), (boolean)false, (int)1, null), ObjectNode.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                jupyterMessage = new JupyterMessageBase((ObjectNode)object, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)buffers), (int)1), Companion::parse$lambda$2$lambda$1)), schema);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return jupyterMessage;
        }

        @JvmStatic
        private final int[] readOffsets(IntBuffer intBuffer) {
            int[] offsets = new int[intBuffer.get() + 1];
            int n = offsets.length - 1;
            for (int i = 0; i < n; ++i) {
                offsets[i] = intBuffer.get();
            }
            return offsets;
        }

        private static final ByteBuffer parse$lambda$2$lambda$0(WebSocketMessage $content, int start2, int end) {
            ((BytesWebSocketMessage)$content).getBytes().limit(end);
            ((BytesWebSocketMessage)$content).getBytes().position(start2);
            return ((BytesWebSocketMessage)$content).getBytes().slice();
        }

        private static final byte[] parse$lambda$2$lambda$1(ByteBuffer it) {
            Intrinsics.checkNotNull((Object)it);
            return IoKt.toByteArray$default((ByteBuffer)it, (boolean)false, (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

