/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.JupyterCoreIcons;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.actions.JupyterRestartKernelActionKt;
import com.intellij.jupyter.core.jupyter.editor.JupyterNotebookDependencies;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Paint;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterRestartKernelAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "badgeDotProvider", "Lcom/intellij/ui/BadgeDotProvider;", "actionPerformed", "Companion", "intellij.jupyter.core"})
public class JupyterRestartKernelAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JupyterRestartKernelActionKt.access$checkKernelAvailable(e);
        e.getPresentation().setIcon(JupyterCoreIcons.RestartKernel);
        if (!e.getPresentation().isEnabled()) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        FileEditor fileEditor2 = fileEditor;
        JupyterNotebookDependencies.Status dependenciesStatus = JupyterNotebookDependencies.INSTANCE.getStatus(fileEditor2);
        if (Intrinsics.areEqual((Object)dependenciesStatus, (Object)JupyterNotebookDependencies.Status.UpToDate.INSTANCE)) {
            return;
        }
        if (!(dependenciesStatus instanceof JupyterNotebookDependencies.Status.NotUpToDate)) {
            throw new NoWhenBranchMatchedException();
        }
        Presentation presentation = e.getPresentation();
        Icon icon = JupyterCoreIcons.RestartKernel;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RestartKernel");
        Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
        presentation.setIcon((Icon)new BadgeIcon(icon, (Paint)color, (BadgeShapeProvider)this.badgeDotProvider()));
        e.getPresentation().setText(JupyterBundle.message("action.JupyterRestartKernelAction.text", new Object[0]) + "<br><br>" + ((JupyterNotebookDependencies.Status.NotUpToDate)dependenciesStatus).getMessage());
    }

    private final BadgeDotProvider badgeDotProvider() {
        double defaultX = new BadgeDotProvider(0.0, 0.0, 0.0, 0.0, 15, null).getX();
        return new BadgeDotProvider(1.0 - defaultX, 0.0, 0.0, 0.0, 14, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterRestartKernelActionKt.restartKernelAndLaunchAction$default((Editor)editor, null, 2, null);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterRestartKernelAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

