/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.jupyter.actions.CellRunMode;
import com.intellij.jupyter.core.jupyter.actions.JupyterExecutionData;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterRunner;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\r"}, d2={"doRunCell", "", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "mode", "Lcom/intellij/jupyter/core/jupyter/actions/CellRunMode;", "doRunAllAbove", "", "doRunAllBelow", "doRunAll", "getJupyterExecutionData", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterExecutionData;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterEditorRunActionsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterEditorRunActionsHandler.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterEditorRunActionsHandlerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1557#2:148\n1628#2,3:149\n1755#2,3:152\n*S KotlinDebug\n*F\n+ 1 JupyterEditorRunActionsHandler.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterEditorRunActionsHandlerKt\n*L\n82#1:148\n82#1:149,3\n91#1:152,3\n*E\n"})
public final class JupyterEditorRunActionsHandlerKt {
    /*
     * WARNING - void declaration
     */
    private static final List<NotebookIntervalPointer> doRunCell(DataContext dataContext, CellRunMode mode) {
        boolean anyMarkdownCells;
        List intervalPointers;
        block13: {
            void $this$mapTo$iv$iv;
            List intervalsToRun;
            EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
            if (editorImpl == null) {
                return null;
            }
            EditorImpl editor = editorImpl;
            if (editor.getEditorKind() == EditorKind.DIFF) {
                return null;
            }
            Project project = editor.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext);
            if (backedNotebookVirtualFile == null) {
                return null;
            }
            BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
            List selectedCellIntervals = JupyterHelper.INSTANCE.getSelectedIntervals((Editor)editor);
            List list = selectedCellIntervals;
            if (list == null) {
                list = CollectionsKt.listOfNotNull((Object)JupyterHelper.INSTANCE.getHoveredInterval((Editor)editor));
            }
            if ((intervalsToRun = list).isEmpty()) {
                return null;
            }
            Iterable $this$map$iv = intervalsToRun;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                NotebookIntervalPointerFactory factory2 = NotebookIntervalPointerFactory.Companion.get((Editor)editor);
                collection.add(factory2.create((NotebookCellLines.Interval)it));
            }
            intervalPointers = (List)destination$iv$iv;
            JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project2, intervalPointers, (Editor)editor, jupyterVirtualFile, mode, null, 32, null);
            JupyterNotebook jupyterNotebook = jupyterVirtualFile.getNotebookOrNull();
            Iterable $this$any$iv = intervalPointers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v4 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl;
                    NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv;
                    boolean bl2 = false;
                    if (it.get() == null) {
                        bl = false;
                    } else {
                        NotebookCellLines.Interval interval;
                        JupyterMetadataAware<JsonNode> jupyterMetadataAware = jupyterNotebook;
                        JupyterCellType cellType = jupyterMetadataAware != null && (jupyterMetadataAware = jupyterMetadataAware.getCellOrNull(interval.getOrdinal())) != null ? jupyterMetadataAware.getCellType() : null;
                        bl = cellType == JupyterCellType.MARKDOWN;
                    }
                    if (!bl) continue;
                    v4 = true;
                    break block13;
                }
                v4 = anyMarkdownCells = false;
            }
        }
        if (anyMarkdownCells) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("jupyter.preview.markdown.cell");
        }
        return intervalPointers;
    }

    static /* synthetic */ List doRunCell$default(DataContext dataContext, CellRunMode cellRunMode, int n, Object object) {
        if ((n & 2) != 0) {
            cellRunMode = CellRunMode.RUN;
        }
        return JupyterEditorRunActionsHandlerKt.doRunCell(dataContext, cellRunMode);
    }

    private static final void doRunAllAbove(DataContext dataContext) {
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionData jupyterExecutionData = JupyterEditorRunActionsHandlerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData result2 = jupyterExecutionData;
        Project project = result2.component1();
        Integer cellIndex = result2.component2();
        BackedNotebookVirtualFile jupyterVirtualFile = result2.component3();
        if (cellIndex == null) {
            return;
        }
        List cellPointers = CollectionsKt.take((Iterable)NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)editor), (int)cellIndex);
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, cellPointers, (Editor)editor, jupyterVirtualFile, null, null, 48, null);
    }

    private static final void doRunAllBelow(DataContext dataContext) {
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionData jupyterExecutionData = JupyterEditorRunActionsHandlerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData result2 = jupyterExecutionData;
        Project project = result2.component1();
        Integer cellIndex = result2.component2();
        BackedNotebookVirtualFile jupyterVirtualFile = result2.component3();
        Integer n = cellIndex;
        int firstIndex = n != null ? n : 0;
        List cellPointers = CollectionsKt.drop((Iterable)NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)editor), (int)firstIndex);
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, cellPointers, (Editor)editor, jupyterVirtualFile, null, null, 48, null);
    }

    public static final void doRunAll(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionData jupyterExecutionData = JupyterEditorRunActionsHandlerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData executionData = jupyterExecutionData;
        Project project = executionData.getProject();
        BackedNotebookVirtualFile jupyterVirtualFile = executionData.getNotebookVirtualFile();
        List<NotebookIntervalPointer> cellPointers = NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)editor);
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, cellPointers, (Editor)editor, jupyterVirtualFile, null, null, 48, null);
    }

    @Nullable
    public static final JupyterExecutionData getJupyterExecutionData(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataContext dataContext2 = dataContext;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext2);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext2);
        Integer cellIndex = interval != null ? Integer.valueOf(interval.getOrdinal()) : null;
        Editor editor = JupyterDataContextExtensionsKt.getEditor(dataContext2);
        if (editor == null || (editor = editor.getProject()) == null) {
            return null;
        }
        Editor project = editor;
        if (cellIndex != null && JupyterDebugger.INSTANCE.showWarningIfUnderDebugger((Project)project, jupyterVirtualFile)) {
            return null;
        }
        return new JupyterExecutionData((Project)project, cellIndex, jupyterVirtualFile);
    }

    public static final /* synthetic */ void access$doRunAllAbove(DataContext dataContext) {
        JupyterEditorRunActionsHandlerKt.doRunAllAbove(dataContext);
    }

    public static final /* synthetic */ void access$doRunAllBelow(DataContext dataContext) {
        JupyterEditorRunActionsHandlerKt.doRunAllBelow(dataContext);
    }
}

