/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.doubleFile;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.NotebookVirtualFileSaveListener;
import com.intellij.jupyter.core.core.impl.file.doubleFile.JupyterLargeFileWriteRequestor;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFileSystem;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebook.editor.BackFileViewProvider;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Deprecated(message="Don't use it directly, use functions from JupyterFileExtensions.kt instead")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 T2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001TB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0001H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010 H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0013H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\"\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\f0\u0011\u00a2\u0006\u0002\b/\u00a2\u0006\u0002\b0H\u0016J\b\u00101\u001a\u00020\u0013H\u0016J\b\u00102\u001a\u00020+H\u0016J\u0012\u00103\u001a\f0\u0011\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\b4H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u0013H\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020+H\u0016J\n\u0010;\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010<\u001a\u00020\u00152\b\u0010=\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010>\u001a\u00020\u0013H\u0016J\b\u0010?\u001a\u00020@H\u0016J\"\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u00020+H\u0016J\u0015\u0010G\u001a\n I*\u0004\u0018\u00010H0HH\u0002\u00a2\u0006\u0002\u0010JJ\u0013\u0010K\u001a\u00020\u00132\b\u0010L\u001a\u0004\u0018\u00010DH\u0096\u0002J\b\u0010M\u001a\u00020\u001cH\u0016J\u0012\u0010R\u001a\u00020\u00152\b\u0010S\u001a\u0004\u0018\u00010OH\u0007R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010N\u001a\u0004\u0018\u00010OX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\bP\u0010Q\u00a8\u0006U"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/notebook/editor/BackedVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFileWithId;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "originalFile", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;)V", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "setNotebook", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;)V", "contentFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getPresentablePath", "", "enforcePresentableName", "", "flush", "", "safelyClose", "closeable", "Ljava/io/Closeable;", "t", "", "getId", "", "getOriginFile", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "setWritable", "writable", "isWritable", "refresh", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getLength", "", "getFileSystem", "Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem;", "getPath", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "isDirectory", "getTimeStamp", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "contentsToByteArray", "", "isValid", "getInputStream", "Ljava/io/InputStream;", "getModificationStamp", "getDetectedLineSeparator", "setDetectedLineSeparator", "separator", "isInLocalFileSystem", "toNioPath", "Ljava/nio/file/Path;", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "newTimeStamp", "getPublisher", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "kotlin.jvm.PlatformType", "()Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "equals", "other", "hashCode", "saveListener", "Lcom/intellij/jupyter/core/core/impl/file/NotebookVirtualFileSaveListener;", "getSaveListener$annotations", "()V", "setSaveListener", "newSaveListener", "Companion", "intellij.jupyter.core"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nNotebookVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookVirtualFile.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFile\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,211:1\n14#2:212\n*S KotlinDebug\n*F\n+ 1 NotebookVirtualFile.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFile\n*L\n209#1:212\n*E\n"})
public final class NotebookVirtualFile
extends VirtualFile
implements BackedVirtualFile,
VirtualFileWithId,
VirtualFilePathWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile originalFile;
    @NotNull
    private volatile JupyterNotebook notebook;
    @NotNull
    private final LightVirtualFile contentFile;
    @Nullable
    private NotebookVirtualFileSaveListener saveListener;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public NotebookVirtualFile(@NotNull VirtualFile originalFile, @NotNull JupyterNotebook notebook) {
        void $this$contentFile_u24lambda_u240;
        LightVirtualFile lightVirtualFile;
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.originalFile = originalFile;
        this.notebook = notebook;
        LightVirtualFile lightVirtualFile2 = lightVirtualFile = new LightVirtualFile(this.originalFile, this.notebook.asSource(), this.originalFile.getModificationStamp());
        NotebookVirtualFile notebookVirtualFile = this;
        boolean bl = false;
        String lineSeparator = LoadTextUtil.detectLineSeparator((VirtualFile)this.originalFile, (boolean)true);
        VirtualFile virtualFile = (VirtualFile)$this$contentFile_u24lambda_u240;
        String string = lineSeparator;
        if (string == null) {
            string = DefaultIndenter.SYS_LF;
        }
        LoadTextUtil.changeLineSeparators(null, (VirtualFile)virtualFile, (String)string, (Object)$this$contentFile_u24lambda_u240);
        notebookVirtualFile.contentFile = lightVirtualFile;
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            throw new Exception("it shoundf NOT be called for single file");
        }
        this.originalFile.putUserData(BackFileViewProvider.FRONT_FILE_KEY, (Object)this);
    }

    @NotNull
    public final JupyterNotebook getNotebook() {
        return this.notebook;
    }

    public final void setNotebook(@NotNull JupyterNotebook jupyterNotebook) {
        Intrinsics.checkNotNullParameter((Object)jupyterNotebook, (String)"<set-?>");
        this.notebook = jupyterNotebook;
    }

    @NotNull
    public String getPresentablePath() {
        Project project = ProjectLocator.Companion.getInstance().guessProjectForFile(this.originalFile);
        if (project == null) {
            String string = this.originalFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }
        Project project2 = project;
        VirtualFile virtualFile = ProjectFileIndex.getInstance((Project)project2).getContentRootForFile(this.originalFile);
        if (virtualFile == null && (virtualFile = WorkspaceFileIndex.Companion.getInstance(project2).getContentFileSetRoot(this.originalFile, false)) == null) {
            String string = this.originalFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }
        VirtualFile root = virtualFile;
        String string = VfsUtilCore.getRelativePath((VirtualFile)this.originalFile, (VirtualFile)root);
        if (string == null) {
            String string2 = this.originalFile.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void flush() {
        block9: {
            if (!this.getOriginFile().isValid()) {
                return;
            }
            OutputStream outputStream = this.getOriginFile().getOutputStream((Object)JupyterLargeFileWriteRequestor.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            OutputStream outputStream2 = outputStream;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream2, Charsets.UTF_8);
            boolean shouldClose = true;
            try {
                this.notebook.writeJson(writer, this.getDetectedLineSeparator());
            }
            catch (OutOfMemoryError oom) {
                if (!(outputStream2 instanceof ByteArrayOutputStream)) {
                    this.safelyClose(writer, oom);
                }
                shouldClose = false;
            }
            catch (IOException ex) {
                this.safelyClose(writer, ex);
                shouldClose = false;
                {
                    catch (Throwable throwable) {
                        NotebookVirtualFile.safelyClose$default(this, writer, null, 2, null);
                        throw throwable;
                    }
                }
            }
            NotebookVirtualFile.safelyClose$default(this, writer, null, 2, null);
            this.getFileSystem().markUnmodified$intellij_jupyter_core(this);
            NotebookVirtualFileSaveListener notebookVirtualFileSaveListener = this.saveListener;
            if (notebookVirtualFileSaveListener == null) break block9;
            notebookVirtualFileSaveListener.saveFinished(BackedNotebookVirtualFile.Companion.create(this));
        }
    }

    private final void safelyClose(Closeable closeable, Throwable t) {
        block4: {
            Throwable loggedEx;
            Throwable throwable;
            Throwable closeError;
            block3: {
                closeError = null;
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    closeError = e;
                    Throwable throwable2 = t;
                    if (throwable2 == null) break block3;
                    ExceptionsKt.addSuppressed((Throwable)throwable2, (Throwable)e);
                }
            }
            if ((throwable = t) == null) {
                throwable = closeError;
            }
            Throwable throwable3 = loggedEx = throwable;
            if (throwable3 == null) break block4;
            Throwable it = throwable3;
            boolean bl = false;
            LOG.error("jupyter save file error", it);
        }
    }

    static /* synthetic */ void safelyClose$default(NotebookVirtualFile notebookVirtualFile, Closeable closeable, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        notebookVirtualFile.safelyClose(closeable, throwable);
    }

    public int getId() {
        VirtualFile virtualFile = this.originalFile;
        VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
        return virtualFileWithId != null ? virtualFileWithId.getId() : 0;
    }

    @NotNull
    public VirtualFile getOriginFile() {
        return this.originalFile;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.originalFile.getParent();
    }

    @NotNull
    public VirtualFile[] getChildren() {
        VirtualFile[] virtualFileArray = this.originalFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        return virtualFileArray;
    }

    public void setWritable(boolean writable) {
        this.originalFile.setWritable(writable);
    }

    public boolean isWritable() {
        return this.originalFile.isWritable();
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.originalFile.refresh(asynchronous, recursive, postRunnable);
    }

    public long getLength() {
        return this.contentFile.getLength();
    }

    @NotNull
    public NotebookVirtualFileSystem getFileSystem() {
        return NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem();
    }

    @NotNull
    public String getPath() {
        String string = this.originalFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public boolean isDirectory() {
        return false;
    }

    public long getTimeStamp() {
        return this.originalFile.getTimeStamp();
    }

    @NotNull
    public String getName() {
        String string = this.originalFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.contentFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return byArray;
    }

    public boolean isValid() {
        return this.contentFile.isValid();
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.contentFile.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    public long getModificationStamp() {
        return this.originalFile.getModificationStamp();
    }

    @Nullable
    public String getDetectedLineSeparator() {
        return this.originalFile.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(@Nullable String separator) {
        this.originalFile.setDetectedLineSeparator(separator);
    }

    public boolean isInLocalFileSystem() {
        return this.originalFile.getFileSystem() instanceof LocalFileSystem;
    }

    @NotNull
    public Path toNioPath() {
        Path path = this.originalFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        return path;
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)new ByteArrayOutputStream(this, requestor, newModificationStamp){
            final /* synthetic */ NotebookVirtualFile this$0;
            final /* synthetic */ Object $requestor;
            final /* synthetic */ long $newModificationStamp;
            {
                this.this$0 = $receiver;
                this.$requestor = $requestor;
                this.$newModificationStamp = $newModificationStamp;
            }

            public void close() {
                boolean bl = this.this$0.isWritable();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                VFileContentChangeEvent event = new VFileContentChangeEvent(this.$requestor, (VirtualFile)this.this$0, this.this$0.getModificationStamp(), this.$newModificationStamp);
                List events = CollectionsKt.listOf((Object)event);
                NotebookVirtualFile.access$getPublisher(this.this$0).before(events);
                try {
                    NotebookVirtualFile.access$getContentFile$p(this.this$0).setContent((Object)((Object)this.this$0), (CharSequence)this.toString(this.this$0.getCharset().name()), false);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                NotebookVirtualFile.access$getPublisher(this.this$0).after(events);
            }
        }, (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStreamAddingBOM(...)");
        return outputStream;
    }

    private final BulkFileListener getPublisher() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        return (BulkFileListener)messageBus.syncPublisher(topic);
    }

    public boolean equals(@Nullable Object other) {
        VirtualFile virtualFile = this.originalFile;
        VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
        Integer id = virtualFileWithId != null ? Integer.valueOf(virtualFileWithId.getId()) : null;
        NotebookVirtualFile notebookVirtualFile = other instanceof NotebookVirtualFile ? (NotebookVirtualFile)((Object)other) : null;
        VirtualFile virtualFile2 = notebookVirtualFile != null ? notebookVirtualFile.originalFile : null;
        VirtualFileWithId virtualFileWithId2 = virtualFile2 instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile2 : null;
        Integer otherId = virtualFileWithId2 != null ? Integer.valueOf(virtualFileWithId2.getId()) : null;
        return id != null && Intrinsics.areEqual((Object)id, (Object)otherId) || super.equals(other);
    }

    public int hashCode() {
        VirtualFile virtualFile = this.originalFile;
        VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
        return virtualFileWithId != null ? virtualFileWithId.getId() : super.hashCode();
    }

    private static /* synthetic */ void getSaveListener$annotations() {
    }

    @TestOnly
    public final void setSaveListener(@Nullable NotebookVirtualFileSaveListener newSaveListener) {
        this.saveListener = newSaveListener;
    }

    public static final /* synthetic */ BulkFileListener access$getPublisher(NotebookVirtualFile $this) {
        return $this.getPublisher();
    }

    public static final /* synthetic */ LightVirtualFile access$getContentFile$p(NotebookVirtualFile $this) {
        return $this.contentFile;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NotebookVirtualFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFile$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

